/*
 * sys/config.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef sys_config_h
#define sys_config_h


#include <sys/limits.h>
#include <machine/vm.h>
#include <machine/fpu.h>


#ifdef KERNEL

#define START_ADDRESS			0x1000					/* setup.SΥɤ˥ɥ쥹 */
#define ROOT_DEVICE				"/dev/dk3"				/* root file system device */
#define PAGING_BACKUP_DEVICE	"/dev/dk4"				/* Paging back store device */

/* ƥ */
#define UTSNAME_SYSNAME   "UNDEFINE"
#define UTSNAME_NODENAME  "UNDEFINE"
#define UTSNAME_RELEASE   "UNDEFINE"
#define UTSNAME_VERSION   "UNDEFINE"

#define TIMEZOME_NAME "tokyo"

#endif	// KERNEL

#define MAX_CPU 8										/* бcpu */
#define DMA_MEM_SIZE			0x100000				// DMA꡼ΰ襵

/*
 * ɥ쥹
 *
 * ͥǡͥ륹åɥ饤Сǡ桼ǡɣϥ꡼ޥå
 * 
 * 0            3ec00000          3f000000          40000000        e0000000            ffffffff
 *
 * 桼֤ϥɥ饤С֤鳫ϡɥ饤СåϥȤ˽ͭ
 */
#define IOMAP_BEG				0xe0000000							// ꡼ޥåIO˥ɥ쥹κǽ
#define KERNEL_END				0x3f000000							// ͥɥ쥹κǸ
#define KERNEL_DATA_BEG			0x100000							// ͥǡɥ쥹κǽ
#define KERNEL_DATA_END			KERNEL_STACK_BEG					// ͥǡɥ쥹κǸ
#define KERNEL_STACK_BEG		(KERNEL_STACK_END - PAGE_DIR_SIZE)	// ͥ륹åɥ쥹κǽ
#define KERNEL_STACK_END		KERNEL_END							// ͥ桼ͭ꡼ɥ쥹κǸ
#define KERNEL_SAVE_FPU			(KERNEL_STACK_END - FPU_SAVE_SIZE)	// FPU¸ɥ쥹
#define KERNEL_SWITCH_ESP		(KERNEL_SAVE_FPU - 4)				// ESP¸
#define KERNEL_SAVE_ESP			(KERNEL_SWITCH_ESP - 4)				// 桼ϥɥ
#define KERNEL_RETURN_POINT		(KERNEL_SAVE_ESP - 4)				// 桼ϥɥ餫äƤ륫ͥݥ
#define KERNEL_ESP_BEG			KERNEL_RETURN_POINT					// ͥ륹åݥ󥿤κǽ

/*
 *԰¸եɥ饤СΰѤkern/vm.c kern/vm.hΥۥ꡼¤Υѹɬ
 */
#define DRIVER_BEG				KERNEL_END							// ɥ饤Сɥ쥹κǽ
#define DRIVER_END				0x40000000							// ɥ饤Сɥ쥹κǸ
#define DRIVER_DATA_BEG			DRIVER_BEG							// ɥ饤Сǡɥ쥹κǽ
#define DRIVER_DATA_END			(DRIVER_END - DMA_MEM_SIZE)			// ɥ饤Сǡɥ쥹κǸ
#define DRIVER_DMA_BEG			DRIVER_DATA_END						// DMA꡼ΰκǽ
#define DRIVER_DMA_END			DRIVER_END							// DMA꡼ΰκǸ

#define USER_BEG				DRIVER_END							// 桼ɥ쥹κǽ
#define USER_END				IOMAP_BEG							// 桼ɥ쥹κǸ
#define USER_ESP_BEG			USER_END							// 桼åݥ󥿤κǽ顢user/include/system.h˱ƶ롣


#ifndef ASM_FILE

#define IP_ADDR(a, b, c, d) (a + (b << 8) + (c << 16) + (d << 24))

enum{
	TASK_TIME = 10,					// 1Ư(ms)
//	hz = (1000 / TASK_TIME),
	MAX_DEVICE_OPEN = 20,			// ǥХץǽ
	MAX_REGIST_FS = 16,				// ե륷ƥϿ
	TTY = 1,						// ͥå 1=console,2=com1,3=com2
	LOCAL_TIME_TOKYO = 32400,		// Ĵ 9

	/* Network. */
	IP_ADDRESS0			= IP_ADDR(172, 25,  0,  3),		/* eth0 IPɥ쥹 */
	IP_SUBNETMASK0		= IP_ADDR(255,255,  0,  0),		/* eth0 IP֥ͥåȥޥ */
	IP_ADDRESS1			= IP_ADDR(172, 25,  0,  4),		/* eth1 IPɥ쥹 */
	IP_SUBNETMASK1		= IP_ADDR(255,255,  0,  0),		/* eth1 IP֥ͥåȥޥ */
	IP_DEFAULT_GATEWAY	= IP_ADDR(172, 25,  0,224),		/* ǥեȥȥ */
};

#endif // ASM_FILE

#endif // sys_config_h
