/*
 * limits.h
 */


#ifndef SYS_LIMITS_H
#define	SYS_LIMITS_H

#include <machine/limits.h>
#include <machine/vm.h>			// PAGE_SIZE

// Minimum Values.
#define	_POSIX_AIO_LISTIO_MAX		2			// The number of I/O operations that can be specified in a list I/O call.
#define	_POSIX_AIO_MAX				1			// The number of outstanding asynchronous I/O operations.
#define	_POSIX_ARG_MAX				4096		// Maximum length of argument to the exec functions including environment data.
#define	_POSIX_CHILD_MAX			25			// Maximum number of simultaneous processes per real user ID.
#define	_POSIX_DELAYTIMER_MAX		32			// The number of timer expiration overruns.
#define	_POSIX_HOST_NAME_MAX		255			// Maximum length of a host name (not including the terminating null) as returned from the gethostname() function.
#define	_POSIX_LINK_MAX				8			// Maximum number of links to a single file.
#define	_POSIX_LOGIN_NAME_MAX		9			// The size of the storage required for a login name, in bytes, including the terminating null.
#define	_POSIX_MAX_CANON			255			// Maximum number of bytes in a terminal canonical input queue.
#define	_POSIX_MAX_INPUT			255			// Maximum number of bytes allowed in a terminal input queue.
#define	_POSIX_MQ_OPEN_MAX			8			// The number of message queues that can be open for a single process.
#define	_POSIX_MQ_PRIO_MAX			32			// The maximum number of message priorities supported by the implementation.
#define	_POSIX_NAME_MAX				14			// Maximum number of bytes in a filename (not including terminating null).
#define	_POSIX_NGROUPS_MAX			8			// Maximum number of simultaneous supplementary group IDs per process.
#define	_POSIX_OPEN_MAX				20			// Maximum number of files that one process can have open at any one time.
#define	_POSIX_PATH_MAX				256			// Maximum number of bytes in a pathname.
#define	_POSIX_PIPE_BUF				512			// Maximum number of bytes that is guaranteed to be atomic when writing to a pipe.
#define	_POSIX_RE_DUP_MAX			255			// The number of repeated occurrences of a BRE permitted by the regexec() and regcomp() functions when using the interval notation.
#define	_POSIX_RTSIG_MAX			8			// The number of realtime signal numbers reserved for application use.
#define	_POSIX_SEM_NSEMS_MAX		256			// The number of semaphores that a process may have.
#define	_POSIX_SEM_VALUE_MAX		32767		// The maximum value a semaphore may have.
#define	_POSIX_SIGQUEUE_MAX			32			// The number of queued signals that a process may send and have pending at the receiver(s) at any time.
#define	_POSIX_SSIZE_MAX			32767		// The value that can be stored in an object of type ssize_t.
#define	_POSIX_STREAM_MAX			8			// The number of streams that one process can have open at one time.
#define	_POSIX_SS_REPL_MAX			4			// The number of replenishment operations that may be simultaneously pending for a particular sporadic server scheduler.
#define	_POSIX_SYMLINK_MAX			255			// The number of bytes in a symbolic link.
#define	_POSIX_SYMLOOP_MAX			8			// The number of symbolic links that can be traversed in the resolution of a pathname in the absence of a loop.
#define	_POSIX_THREAD_DESTRUCTOR_ITERATIONS	4	// The number of attempts made to destroy a thread's thread-specific data values on thread exit.
#define	_POSIX_THREAD_KEYS_MAX		128			// The number of data keys per process.
#define	_POSIX_THREAD_THREADS_MAX	64			// The number of threads per process.
#define	_POSIX_TIMER_MAX			32			// The per-process number of timers.
#define	_POSIX_TRACE_EVENT_NAME_MAX	30			// The length in bytes of a trace event name.
#define	_POSIX_TRACE_NAME_MAX		8			// The length in bytes of a trace generation version string or a trace stream name.
#define	_POSIX_TRACE_SYS_MAX		8			// The number of trace streams that may simultaneously exist in the system.
#define	_POSIX_TRACE_USER_EVENT_MAX	32			// The number of user trace event type identifiers that may simultaneously exist in a traced process, including the predefined user trace event POSIX_TRACE_UNNAMED_USER_EVENT.
#define	_POSIX_TTY_NAME_MAX			9			// The size of the storage required for a terminal device name, in bytes, including the terminating null.
#define	_POSIX_TZNAME_MAX			6			// Maximum number of bytes supported for the name of a timezone (not of the TZ variable).
#define	_POSIX2_BC_BASE_MAX			99			// Maximum obase values allowed by the bc utility.
#define	_POSIX2_BC_DIM_MAX			2048		// Maximum number of elements permitted in an array by the bc utility.
#define	_POSIX2_BC_SCALE_MAX		99			// Maximum scale value allowed by the bc utility.
#define	_POSIX2_BC_STRING_MAX		1000		// Maximum length of a string constant accepted by the bc utility.
#define	_POSIX2_CHARCLASS_NAME_MAX	14			// Maximum number of bytes in a character class name.
#define	_POSIX2_COLL_WEIGHTS_MAX	2			// Maximum number of weights that can be assigned to an entry of the LC_COLLATE order keyword in the locale definition file.
#define	_POSIX2_EXPR_NEST_MAX		32			// Maximum number of expressions that can be nested within parentheses by the expr utility.
#define	_POSIX2_LINE_MAX			2048		// Unless otherwise noted, the maximum length, in bytes, of a utility's input line (either standard input or another file), when the utility is described as processing text files. The length includes room for the trailing.
#define	_POSIX2_RE_DUP_MAX			255			// Maximum number of repeated occurrences of a regular expression permitted when using the interval notation.
#define	_XOPEN_IOV_MAX				16			// Maximum number of iovec structures that one process has available for use with readv() or writev()	.
#define	_XOPEN_NAME_MAX				255			// Maximum number of bytes in a filename (not including the terminating null).
#define	_XOPEN_PATH_MAX				1024		// Maximum number of bytes in a pathname.

// Runtime Invariant Values (Possibly Indeterminate).
#define	PAGESIZE				PAGE_SIZE				// Size in bytes of a page.
#define	PATH_MAX				_POSIX_PATH_MAX
#define	PTHREAD_THREADS_MAX		_POSIX_THREAD_THREADS_MAX

// Numerical Limits.
#define	ARG_MAX					_POSIX_ARG_MAX			// Maximum length of argument to the exec functions including environment data.
#define	CHAR_BIT				_CHAR_BIT				// Number of bits in a type char.
#define	CHAR_MAX				SCHAR_MAX				// Maximum value of type char.
#define	CHAR_MIN				SCHAR_MIN				// Minimum value of type char.
#define	CHILD_MAX				_POSIX_CHILD_MAX		// Maximum number of simultaneous processes per real user ID.
#define	INT_MAX					_INT_MAX				// Maximum value of an int.
#define	LOGIN_NAME_MAX			_POSIX_LOGIN_NAME_MAX	// Maximum length of a login name.
#define	LONG_BIT				32						// Number of bits in a long.
#define	LONG_MAX				_LONG_MAX				// Maximum value of a long.
#define	MB_LEN_MAX				1						// Maximum number of bytes in a character, for any supported locale.
#define	NAME_MAX				PATH_MAX				// Maximum number of bytes in a filename (not including terminating null).
#define	SCHAR_MAX				_SCHAR_MAX				// Maximum value of type signed char.
#define	SHRT_MAX				_SHRT_MAX				// Maximum value of type short.
#define	SSIZE_MAX				_SSIZE_MAX				// Maximum value of an object of type ssize_t.
#define	UCHAR_MAX				_UCHAR_MAX				// Maximum value of type unsigned char.
#define	UINT_MAX				_UINT_MAX				// Maximum value of type unsigned.
#define	ULONG_MAX				_ULONG_MAX				// Maximum value of type unsigned long.
#define	USHRT_MAX				_USHRT_MAX				// Maximum value for a type unsigned short.
#define	WORD_BIT				32						// Number of bits in a type int.
#define	INT_MIN					_INT_MIN				// Minimum value of type int.
#define	LONG_MIN				_LONG_MIN				// Minimum value of type long.
#define	SCHAR_MIN				_SCHAR_MIN				// Minimum value of type signed char.
#define	SHRT_MIN				_SHRT_MIN				// Minimum value of type short.
#define	LLONG_MIN				QUAD_MIN				// Minimum value of type long long.
#define	LLONG_MAX				QUAD_MAX				// Maximum value of type long long.
#define	ULLONG_MAX				UQUAD_MAX				// Maximum value of type unsigned long long.


#endif
