/*	$NetBSD: proc.h,v 1.232.2.1 2007/04/01 16:16:20 bouyer Exp $	*/

/*-
 * Copyright (c) 1986, 1989, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)proc.h	8.15 (Berkeley) 5/19/95
 *
 * 2009: modified by minoru murashima.
 */

#ifndef _SYS_PROC_H_
#define	_SYS_PROC_H_

#include <sys/types.h>
#include <sys/param.h>

#define	NO_PGID		((pid_t)-1)
#define	S_LOGIN_SET	1				/* s_login set in this session */

struct tty;

struct proc {
	int dummy;
};

/*
 * One structure allocated per session.
 */
struct session {
	int				s_count;			/* Ref cnt; pgrps in session */
	u_int			s_flags;
//	struct proc		*s_leader;			/* Session leader */
//	struct vnode	*s_ttyvp;			/* Vnode of controlling terminal */
	struct tty		*s_ttyp;			/* Controlling terminal */
	char			s_login[MAXLOGNAME]; /* Setlogin() name */
	pid_t			s_sid;				/* Session ID (pid of leader) */
};

/*
 * One structure allocated per process group.s
 */
struct pgrp {
//	LIST_HEAD(, proc) pg_members;	/* Pointer to pgrp members */
	struct session	*pg_session;	/* Pointer to session */
	pid_t			pg_id;			/* Pgrp id */
//	int				pg_jobc;		/* Number of processes qualifying pgrp for job control */
};

#ifdef KERNEL

#include <kern/proc.h>
#include <sys/Thread.h>

#define PHOLD(p)
#define PRELE(p)

/*
 * ѡ桼
 * return : error number
 */
static inline int suser(
	const void *proc)
{
	return (getUid(getCurrentProc) == 0) ? NOERR : -EPERM;
}

#endif	/* KERNEL */

#endif	/* !_SYS_PROC_H_ */
