/*
 * Copyright (c) 1982, 1986, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)uio.h	8.5 (Berkeley) 2/22/94
 * $FreeBSD: src/sys/sys/uio.h,v 1.11.2.2 2003/10/02 16:49:49 nectar Exp $
 */

#ifndef _SYS_UIO_H_
#define	_SYS_UIO_H_


#include <sys/cdefs.h>
#include <sys/types.h>

#ifdef KERNEL
#include <kern/proc.h>
#endif


#ifndef ASM_FILE


enum uio_rw { 
	UIO_READ, 
	UIO_WRITE
};

/* Segment flag values. */
enum uio_seg {
	UIO_USERSPACE,		/* from user data space */
	UIO_SYSSPACE,		/* from system space */
	UIO_USERISPACE,		/* from user I space */
	UIO_NOCOPY			/* don't copy, already in object */
};

/*
 * iov_base should be a void *.
 */
struct iovec {
	char	*iov_base;	/* Base address. */
	size_t	 iov_len;	/* Length. */
};

struct uio {
	struct iovec	*uio_iov;
	int				uio_iovcnt;
	off_t			uio_offset;	// offset bytes.
	size_t			uio_resid;
	enum uio_seg	uio_segflg;
	enum uio_rw		uio_rw;
//	struct proc		*uio_procp;
};

#define	UIO_SETUP_SYSSPACE(uio)

#ifdef KERNEL

/*
 * Limits
 */
#define UIO_MAXIOV		1024		/* max 1K of iov's */
#define UIO_SMALLIOV	8			/* 8 on stack, else malloc */

struct vm_object;

extern int	uiomove __P((caddr_t, int, struct uio *));
extern void setUio(const int, enum uio_rw, const off_t, const int, struct iovec *, struct uio *);

#else /* !_KERNEL */

ssize_t	readv(int, const struct iovec *, int);
ssize_t	writev(int, const struct iovec *, int);

#endif /* _KERNEL */


#endif // !ASM_FILE


#endif /* !_SYS_UIO_H_ */
