/*
 * bootfsEntry.c
 * 
 * bootfsѥե륨ȥ꡼ơɸϤ˽Ϥ롣
 */

/*
 * bootfsȥ꡼쥤
 * ե̾NULLʸ󡢥ե륵intˡեǡ
 */
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>

//#define DEBUG

static void usage()
{
	printf("usage: bootfsEntry [file]\n");
}

/*
 * ѥե̾ʸƬݥ󥿤
 */
static const char *getFileName(
	const char *path)	// NULLʸ
{
	const char *str;
	const char *p;
	
	str = path;
	for (p = path; *p != '\0'; ++p) {
		if ((*p == '/') && (*(p + 1) != '\0')) {
			str = p + 1;
		}
	}
	
	return str;
}

/*
 * ɸϤ˽
 */
static void writeStdout(
	const char *name,
	const int size,
	void *data)
{
	write(1, name, strlen(name) + 1);
	write(1, &size, sizeof(int));
	write(1, data, size);
}

#ifdef DEBUG
static void test()
{
	char *str1 = "/dir1/dir2/file";
	char *str2 = "dir1/dir2/file";
	char *str3 = "file";
	char *str4 = "//file";
	const char *str;
	
	str = getFileName(str1);
	if (strcmp("file", str) != 0) {
		printf("getFileName error %s-%s\n", str1, str);
		exit(1);
	}
	str = getFileName(str2);
	if (strcmp("file", str) != 0) {
		printf("getFileName error %s-%s\n", str2, str);
		exit(1);
	}
	str = getFileName(str3);
	if (strcmp("file", str) != 0) {
		printf("getFileName error %s-%s\n", str3, str);
		exit(1);
	}
	str = getFileName(str4);
	if (strcmp("file", str) != 0) {
		printf("getFileName error %s-%s\n", str4, str);
		exit(1);
	}
}
#endif

int main(int argc,char *argv[])
{
	int fd;
	struct stat stat;
	void *buf;

#ifdef DEBUG
	test();
#endif

	if (argc < 2) {
		usage();
		return 1;
	}

	fd = open(argv[1], O_RDONLY);
	if (fd == -1) {
		printf("Don't open %s.\n", argv[1]);
		return 1;
	}
	if (fstat(fd, &stat) == -1) {
		printf("Don't state %s.\n", argv[1]);
		return 1;
	}
	buf = malloc(stat.st_size);
	if (buf == NULL) {
		printf("Don't alloc buf. size=%d\n", stat.st_size);
		return 1;
	}
	if (read(fd, buf, stat.st_size) < stat.st_size) {
		printf("Don't read %s.\n", argv[1]);
		return 1;
	}

	// ɸϤ˽
	writeStdout(getFileName(argv[1]), stat.st_size, buf);

	return 0;
}
