/*
 * sys/limits.h
 *
 * Copyright c 2001-2004 The IEEE and The Open Group, All Rights reserved.
 */

#ifndef LIMITS_H
#define LIMITS_H

#include <sys/limits.h>

// Runtime Invariant Values (Possibly Indeterminate).
#define	AIO_LISTIO_MAX			_POSIX_AIO_LISTIO_MAX		// Maximum number of I/O operations in a single list I/O call supported by the implementation.
#define	AIO_MAX					_POSIX_AIO_MAX				// Maximum number of outstanding asynchronous I/O operations supported by the implementation.
#define	AIO_PRIO_DELTA_MAX		0							// The maximum amount by which a process can decrease its asynchronous I/O priority level from its own scheduling priority.
#define	ATEXIT_MAX				32							// Maximum number of functions that may be registered with atexit().
#define	DELAYTIMER_MAX			_POSIX_DELAYTIMER_MAX		// Maximum number of timer expiration overruns.
#define	HOST_NAME_MAX			_POSIX_HOST_NAME_MAX		// Maximum length of a host name (not including the terminating null) as returned from the gethostname() function.
#define	IOV_MAX					_XOPEN_IOV_MAX				// Maximum number of iovec structures that one process has available for use with readv() or writev().
#define	MQ_OPEN_MAX				_POSIX_MQ_OPEN_MAX			// The maximum number of open message queue descriptors a process may hold.
#define	MQ_PRIO_MAX				_POSIX_MQ_PRIO_MAX			// The maximum number of message priorities supported by the implementation.
#define	OPEN_MAX				_POSIX_OPEN_MAX				// Maximum number of files that one process can have open at any one time.
#define	PTHREAD_DESTRUCTOR_ITERATIONS	_POSIX_THREAD_DESTRUCTOR_ITERATIONS	// Maximum number of attempts made to destroy a thread's thread-specific data values on thread exit.
#define	PTHREAD_KEYS_MAX		_POSIX_THREAD_KEYS_MAX		// Maximum number of data keys that can be created by a process.
#define	PTHREAD_STACK_MIN		0							// Minimum size in bytes of thread stack storage.
#define	RE_DUP_MAX				_POSIX2_RE_DUP_MAX			// The number of repeated occurrences of a BRE permitted by the regexec() and regcomp() functions when using the interval notation {\(m,n\}; see BREs Matching Multiple Characters.
#define	RTSIG_MAX				_POSIX_RTSIG_MAX			// Maximum number of realtime signals reserved for application use in this implementation.
#define	SEM_NSEMS_MAX			_POSIX_SEM_NSEMS_MAX		// Maximum number of semaphores that a process may have.
#define	SEM_VALUE_MAX			_POSIX_SEM_VALUE_MAX		// The maximum value a semaphore may have.
#define	SIGQUEUE_MAX			_POSIX_SIGQUEUE_MAX			// Maximum number of queued signals that a process may send and have pending at the receiver(s) at any time.
#define	SS_REPL_MAX				_POSIX_SS_REPL_MAX			// The maximum number of replenishment operations that may be simultaneously pending for a particular sporadic server scheduler.
#define	STREAM_MAX				_POSIX_STREAM_MAX			// The number of streams that one process can have open at one time. If defined, it has the same value as {FOPEN_MAX} (see <stdio.h>).
#define	SYMLOOP_MAX				_POSIX_SYMLOOP_MAX			// Maximum number of symbolic links that can be reliably traversed in the resolution of a pathname in the absence of a loop.
#define	TIMER_MAX				_POSIX_TIMER_MAX			// Maximum number of timers per process supported by the implementation.
#define	TRACE_EVENT_NAME_MAX	_POSIX_TRACE_EVENT_NAME_MAX	// Maximum length of the trace event name.
#define	TRACE_NAME_MAX			_POSIX_TRACE_NAME_MAX		// Maximum length of the trace generation version string or of the trace stream name.
#define	TRACE_SYS_MAX			_POSIX_TRACE_SYS_MAX		// Maximum number of trace streams that may simultaneously exist in the system.
#define	TRACE_USER_EVENT_MAX	_POSIX_TRACE_USER_EVENT_MAX	// Maximum number of user trace event type identifiers that may simultaneously exist in a traced process, including the predefined user trace event POSIX_TRACE_UNNAMED_USER_EVENT.
#define	TTY_NAME_MAX			_POSIX_TTY_NAME_MAX			// Maximum length of terminal device name.
#define	TZNAME_MAX				_POSIX_TZNAME_MAX			// Maximum number of bytes supported for the name of a timezone (not of the TZ variable).
#define	FILESIZEBITS			32							// Minimum number of bits needed to represent, as a signed integer value, the maximum size of a regular file allowed in the specified directory.
#define	LINK_MAX				_POSIX_LINK_MAX				// Maximum number of links to a single file.
#define	MAX_CANON				_POSIX_MAX_CANON			// Maximum number of bytes in a terminal canonical input line.
#define	MAX_INPUT				_POSIX_MAX_INPUT			// Minimum number of bytes for which space is available in a terminal input queue; therefore, the maximum number of bytes a conforming application may require to be typed as input before reading them.
#define	PIPE_BUF				_POSIX_PIPE_BUF				// Maximum number of bytes that is guaranteed to be atomic when writing to a pipe.
#define	POSIX_ALLOC_SIZE_MIN	0							// Minimum number of bytes of storage actually allocated for any portion of a file.
#define	POSIX_REC_INCR_XFER_SIZE	0						// Recommended increment for file transfer sizes between the {POSIX_REC_MIN_XFER_SIZE} and {POSIX_REC_MAX_XFER_SIZE} values.
#define	POSIX_REC_MAX_XFER_SIZE	0							// Maximum recommended file transfer size.
#define	POSIX_REC_MIN_XFER_SIZE	0							// Minimum recommended file transfer size.
#define	POSIX_REC_XFER_ALIGN	0							// Recommended file transfer buffer alignment.
#define	SYMLINK_MAX				_POSIX_SYMLINK_MAX			// Maximum number of bytes in a symbolic link.

// Runtime Increasable Values.
#define	BC_BASE_MAX				_POSIX2_BC_BASE_MAX			// Maximum obase values allowed by the bc utility.
#define	BC_DIM_MAX				_POSIX2_BC_DIM_MAX			// Maximum number of elements permitted in an array by the bc utility.
#define	BC_SCALE_MAX			_POSIX2_BC_SCALE_MAX		// Maximum scale value allowed by the bc utility.
#define	BC_STRING_MAX			_POSIX2_BC_STRING_MAX		// Maximum length of a string constant accepted by the bc utility.
#define	CHARCLASS_NAME_MAX		_POSIX2_CHARCLASS_NAME_MAX	// Maximum number of bytes in a character class name.
#define	COLL_WEIGHTS_MAX		_POSIX2_COLL_WEIGHTS_MAX	// Maximum number of weights that can be assigned to an entry of the LC_COLLATE order keyword in the locale definition file; see Locale.
#define	EXPR_NEST_MAX			_POSIX2_EXPR_NEST_MAX		// Maximum number of expressions that can be nested within parentheses by the expr utility.
#define	LINE_MAX				_POSIX2_LINE_MAX			// Unless otherwise noted, the maximum length, in bytes, of a utility's input line (either standard input or another file), when the utility is described as processing text files. The length includes room for the trailing <newline>.
#define	NGROUPS_MAX				_POSIX_NGROUPS_MAX			// Maximum number of simultaneous supplementary group IDs per process.
#define	RE_DUP_MAX				_POSIX2_RE_DUP_MAX			// Maximum number of repeated occurrences of a regular expression permitted when using the interval notation \{m,n\}; see Regular Expressions.
#define	_POSIX_CLOCKRES_MIN		20000000					// The resolution of the CLOCK_REALTIME clock, in nanoseconds.

// Other Invariant Values.
#define	NL_ARGMAX		9						// Maximum value of digit in calls to the printf() and scanf() functions.
#define	NL_LANGMAX		14						// Maximum number of bytes in a LANG name.
#define	NL_MSGMAX		32767					// Maximum message number.
#define	NL_NMAX			0						// Maximum number of bytes in an N-to-1 collation mapping.
#define	NL_SETMAX		255						// Maximum set number.
#define	NL_TEXTMAX		_POSIX2_LINE_MAX		// Maximum number of bytes in a message string.
#define	NZERO			20						// Default process priority.
#define	MAXCOMLEN		16						/* max command name remembered */

#endif
