/*
 * sched.h
 */


#ifndef sched_h
#define sched_h


#include <sys/types.h>
#include <sys/sched.h>
#include <time.h>


struct sched_param {
	int sched_priority;		// Process or thread execution scheduling priority. 

	/* In addition, if _POSIX_SPORADIC_SERVER or _POSIX_THREAD_SPORADIC_SERVER is defined, 
	 * the sched_param structure defined shall contain the following members in addition to those specified above:
	 * int             sched_ss_low_priority Low scheduling priority for sporadic server. 
	 * struct timespec sched_ss_repl_period  Replenishment period for sporadic server. 
	 * struct timespec sched_ss_init_budget  Initial budget for sporadic server. 
	 * int             sched_ss_max_repl     Maximum pending replenishments for sporadic server. 
	 */
};

extern int    sched_get_priority_max(int);
extern int    sched_get_priority_min(int);
extern int    sched_getparam(pid_t, struct sched_param *);
extern int    sched_getscheduler(pid_t);
extern int    sched_rr_get_interval(pid_t, struct timespec *);
extern int    sched_setparam(pid_t, const struct sched_param *);
extern int    sched_setscheduler(pid_t, int, const struct sched_param *);
extern int    sched_yield(void);


#endif
