/*
 * ⥸塼ᥤ
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <errno.h>
#include <machine/bios32.h>
#include <machine/pcibios.h>
#include <pci/pcivar.h>
#include <ata/atavar.h>
#include <module/Module.h>

extern struct cdevsw wd_cdevsw;

/*
 * Configure the system's hardware.
 */
static void configure(void)
{
	extern struct cfdriver *cfdriver_list_initial[];
	extern struct cfattachinit cfattachinit[];
	extern struct cfdata cfdata[];
	extern short cfroots[];

	setInitialTable(cfdriver_list_initial, cfattachinit, cfdata, cfroots);

	callout_startup();

	/* Initialize data structures. */
	config_init();

	/*
	 * Do the machine-dependent portion of autoconfiguration.  This
	 * sets the configuration machinery here in motion by "finding"
	 * the root bus.  When this function returns, we expect interrupts
	 * to be enabled.
	 */
	bios32_init();
	pcibios_init();
}

int main()
{
	extern void setWaitObj(void*, void*);
	static struct pcibus_attach_args pba;
	void *waitAggrObj;
	void *waitIdentObj;
	int error;

	// ⥸塼
	if (initModule(&waitAggrObj, &waitIdentObj) != 0) {
		printf("initModue failed!\n");
		return 0;
	}
	setWaitObj(waitAggrObj, waitIdentObj);

	// ǥХϿ
	configure();

	// PCIBUSϿ
	pba.pba_iot = X86_BUS_SPACE_IO;
	pba.pba_memt = X86_BUS_SPACE_MEM;
	pba.pba_dmat = &pci_bus_dma_tag;
	pba.pba_dmat64 = NULL;
	pba.pba_pc = NULL;
	pba.pba_flags = pci_bus_flags();
	pba.pba_bus = 0;
	pba.pba_bridgetag = NULL;
	if (config_rootfound("pci", &pba) == NULL) {
		panic("configure: pcibus not configured");
	}
//	if (config_rootfound("mainbus", NULL) == NULL) {
//		panic("configure: mainbus not configured");
//	}

	// ꡼
	error = sleepModule();
	if (error != 0) {
		printf("Module sleep error! : %d\n", errno);
	}

	// ̥ץޤäƤʤ

	printf("Module was deleted\n");

	return 0;
}
