/*	$NetBSD: consinit.c,v 1.12 2006/08/13 20:22:27 jmcneill Exp $	*/

/*
 * Copyright (c) 1998
 *	Matthias Drochner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 2008: modified by minoru murashima.
 *
 */

#include <sys/errno.h>
#include <ic/i8042reg.h>
#include <ic/pckbcvar.h>
#include <isa/isareg.h>
#include <isa/pcdisplayvar.h>
#include <i386lib/bus.h>

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * consinit:
 * initialize the system console.
 * XXX - shouldn't deal with this initted thing, but then,
 * it shouldn't be called from init386 either.
 */
void consinit()
{
//	const struct btinfo_console *consinfo;
	static int initted = 0;

	if (initted) {
		return;
	}
	initted = 1;
/*
#ifndef CONS_OVERRIDE
	consinfo = lookup_bootinfo(BTINFO_CONSOLE);
	if (!consinfo)
#endif
		consinfo = &default_consinfo;

#if (NPC > 0) || (NVGA > 0) || (NEGA > 0) || (NPCDISPLAY > 0) || (NVESAFB > 0)
	if (!strcmp(consinfo->devname, "pc")) {
*/
		int error;
/*
#if (NVESAFB > 0)
		if (!vesafb_cnattach())
			goto dokbd;
#endif
#if (NVGA > 0)
		if (!vga_cnattach(X86_BUS_SPACE_IO, X86_BUS_SPACE_MEM, -1, 1))
			goto dokbd;
#endif
#if (NEGA > 0)
		if (!ega_cnattach(X86_BUS_SPACE_IO, X86_BUS_SPACE_MEM))
			goto dokbd;
#endif
*/
#if (NPCDISPLAY > 0)
		if (!pcdisplay_cnattach(X86_BUS_SPACE_IO, X86_BUS_SPACE_MEM))
			goto dokbd;
#endif
/*
#if (NPC > 0)
		pccnattach();
#endif
*/
//		if (0) goto dokbd; /* XXX stupid gcc */
dokbd:
		error = ENODEV;
//#if (NPCKBC > 0)
		error = pckbc_cnattach(X86_BUS_SPACE_IO, IO_KBD, KBCMDP, PCKBC_KBD_SLOT);
//#endif
/*
#if (NUKBD > 0)
		if (error)
			error = ukbd_cnattach();
#endif
		if (error)
			printf("WARNING: no console keyboard, error=%d\n", error);
		return;
	}
*/
//#endif /* PC | VT | VGA | PCDISPLAY | VESAFB */
/*
#if (NCOM > 0)
	if (!strcmp(consinfo->devname, "com")) {
		bus_space_tag_t tag = X86_BUS_SPACE_IO;
		int addr = consinfo->addr;
		int speed = consinfo->speed;

		if (addr == 0)
			addr = CONADDR;
		if (speed == 0)
			speed = CONSPEED;

		if (comcnattach(tag, addr, speed, COM_FREQ, COM_TYPE_NORMAL, comcnmode))
			panic("can't init serial console @%x", consinfo->addr);

		return;
	}
#endif
	panic("invalid console device %s", consinfo->devname);
*/
}
