/*	$NetBSD: mainbus.c,v 1.70 2006/11/26 12:30:05 cube Exp $	*/

/*
 * Copyright (c) 1996 Christopher G. Demetriou.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Christopher G. Demetriou
 *	for the NetBSD Project.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 2008: modified by minoru murashima.
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <isa/isavar.h>
#include <pci/pcivar.h>
#include <machine/bus.h>
#include <machine/pci_machdep.h>

//=====================================  ===================================================

union mainbus_attach_args {
	const char *mba_busname;		/* first elem of all */
	struct pcibus_attach_args mba_pba;
//	struct isabus_attach_args mba_iba;
//	struct pnpbios_attach_args mba_paa;
//	struct acpibus_attach_args mba_acpi;
//	struct ipmi_attach_args mba_ipmi;
};

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * Probe for the mainbus; always succeeds.
 */
static int mainbus_match(
	struct device *parent, 
	struct cfdata *match, 
	void *aux)
{
	return 1;
}

/*
 * Attach the mainbus.
 */
void mainbus_attach(
	struct device *parent, 
	struct device *self, 
	void *aux)
{
	union mainbus_attach_args mba;

//	int acpi_present = 0;
//	int mpbios_present = 0;
//	int pci_maxbus = 0;
//	int mpacpi_active = 0;

	aprint_naive("\n");
	aprint_normal("\n");

//	mpbios_present = mpbios_probe(self);

	/*
	 * ACPI needs to be able to access PCI configuration space.
	 */
	pci_mode = pci_mode_detect();
//	if (pci_mode != 0) {
//		pci_maxbus = pci_bus_fixup(NULL, 0);
//		aprint_debug("PCI bus max, after pci_bus_fixup: %i\n", pci_maxbus);
//		pciaddr.extent_port = NULL;
//		pciaddr.extent_mem = NULL;
//		pci_addr_fixup(NULL, pci_maxbus);
//	}

//	if (acpi_check(self, "acpibus"))
//		acpi_present = acpi_probe();
	/*
	 * First, see if the MADT contains CPUs, and possibly I/O APICs.
	 * Building the interrupt routing structures can only
	 * be done later (via a callback).
	 */
//	if (acpi_present)
//		mpacpi_active = mpacpi_scan_apics(self, &numcpus, &numioapics);

//	if (!mpacpi_active) {
//		if (mpbios_present)
//			mpbios_scan(self, &numcpus, &numioapics);
//		else
//		if (numcpus == 0) {
//			struct cpu_attach_args caa;
//
//			memset(&caa, 0, sizeof(caa));
//			caa.caa_name = "cpu";
//			caa.cpu_number = 0;
//			caa.cpu_role = CPU_ROLE_SP;
//			caa.cpu_func = 0;
//
//			config_found_ia(self, "cpubus", &caa, mainbus_print);
//		}
//	}

//	if (vbeprobe())
//		config_found_ia(self, "vesabiosbus", 0, 0);

	/*
	 * ACPI and PNPBIOS need ISA DMA initialized before they start probing.
	 */
//	isa_dmainit(&x86_isa_chipset, X86_BUS_SPACE_IO, &isa_bus_dma_tag,
//	    self);

//	if (acpi_present) {
//		mba.mba_acpi.aa_iot = X86_BUS_SPACE_IO;
//		mba.mba_acpi.aa_memt = X86_BUS_SPACE_MEM;
//		mba.mba_acpi.aa_pc = NULL;
//		mba.mba_acpi.aa_pciflags =
//		    PCI_FLAGS_IO_ENABLED | PCI_FLAGS_MEM_ENABLED |
//		    PCI_FLAGS_MRL_OKAY | PCI_FLAGS_MRM_OKAY |
//		    PCI_FLAGS_MWI_OKAY;
//		mba.mba_acpi.aa_ic = &x86_isa_chipset;
//		config_found_ia(self, "acpibus", &mba.mba_acpi, 0);
//	}

//	if (acpi_active == 0)
//	if (pnpbios_probe()) {
//		mba.mba_paa.paa_ic = &x86_isa_chipset;
//		config_found_ia(self, "pnpbiosbus", &mba.mba_paa, 0);
//	}

//	memset(&mba.mba_ipmi, 0, sizeof(mba.mba_ipmi));
//	mba.mba_ipmi.iaa_iot = X86_BUS_SPACE_IO;
//	mba.mba_ipmi.iaa_memt = X86_BUS_SPACE_MEM;
//	if (ipmi_probe(&mba.mba_ipmi))
//		config_found_ia(self, "ipmibus", &mba.mba_ipmi, 0);
	/*
	 * XXX Note also that the presence of a PCI bus should
	 * XXX _always_ be checked, and if present the bus should be
	 * XXX 'found'.  However, because of the structure of the code,
	 * XXX that's not currently possible.
	 */
	if (pci_mode != 0) {
		mba.mba_pba.pba_iot = X86_BUS_SPACE_IO;
		mba.mba_pba.pba_memt = X86_BUS_SPACE_MEM;
		mba.mba_pba.pba_dmat = &pci_bus_dma_tag;
		mba.mba_pba.pba_dmat64 = NULL;
		mba.mba_pba.pba_pc = NULL;
		mba.mba_pba.pba_flags = pci_bus_flags();
		mba.mba_pba.pba_bus = 0;
		mba.mba_pba.pba_bridgetag = NULL;
//		if (mpacpi_active)
//			mpacpi_scan_pci(self, &mba.mba_pba, pcibusprint);
//		else
//		if (mpbios_scanned != 0)
//			mpbios_scan_pci(self, &mba.mba_pba, pcibusprint);
//		else
		config_found_ia(self, "pcibus", &mba.mba_pba, pcibusprint);
//		if (mp_verbose)
//			acpi_pci_link_state();
	}

//	if (mainbusIsIsaSeen() == NO) {
//		config_found_ia(self, "isabus", getIsabusAttachArgs(), isabusprint);
//s	}

//	if (acpi_active == 0)
//	if (apm_busprobe())
//		config_found_ia(self, "apmbus", 0, 0);
}

//===================================== PUBLIC =====================================================

CFATTACH_DECL(mainbus, sizeof(struct device), mainbus_match, mainbus_attach, NULL, NULL);
/*
struct cfattach mainbus_ca = {
	 "mainbus", 
	 { ((void *)0), ((void *)0) }, 
	 sizeof(struct device), 
	 mainbus_match, 
	 mainbus_attach, 
	 ((void *)0), 
	 ((void *)0), 
	 0, 
	 0
};
*/
