/*	$NetBSD: bus_dma.c,v 1.32 2006/11/16 01:32:39 christos Exp $	*/

/*-
 * Copyright (c) 1996, 1997, 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Charles M. Hannum and by Jason R. Thorpe of the Numerical Aerospace
 * Simulation Facility, NASA Ames Research Center.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * 2009: modified by minoru murashima.
 */

/*
 * The following is included because _bus_dma_uiomove is derived from
 * uiomove() in kern_subr.c.
 */

/*
 * Copyright (c) 1982, 1986, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * 2009: modified by minoru murashima.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/uio.h>
#include <sys/proc.h>
#include <errno.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <machine/bus.h>

//=====================================  ===================================================

extern int allocDmaMemory(const uint size, bus_addr_t *physAddr, bus_addr_t *linearAddr);

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * Allocate physical memory from the given physical address range.
 * return : error number
 */
int _bus_dmamem_alloc(
	bus_dma_tag_t tag, 
	bus_size_t size, 
	bus_size_t alignment,
    bus_size_t boundary, 
    bus_dma_segment_t *segs,
    int nsegs, 
    int *rsegs,
    int flags)
{
	// ʪ꡼ơʪ꡼ɥ쥹꡼ɥ쥹
	// ʪ꡼ɥ쥹ds_addr[0]Τߤ˥åȤrsegsϲ⥻åȤʤ
	errno = 0;
	allocDmaMemory(size, &tag->physAddr, &tag->linearAddr);
	return errno;
}

/*
 * DMAʪ꡼ۥɥ쥹˥ޥåפ
 */
int _bus_dmamem_map(
	bus_dma_tag_t tag, 
    caddr_t *o_kvap,			// ޥå׸βۥɥ쥹
    bus_addr_t *o_physAddr,		// ޥå׸ʪɥ쥹
    int flags)
{
	// ɥ쥹Τߤ֤
	*o_kvap = (caddr_t) tag->linearAddr;
	*o_physAddr = tag->physAddr;
	return (0);
}

/*
 * DMA map ¤ΤƤƽ
 * return : error number
 */
int _bus_dmamap_create(
	bus_dma_tag_t tag, 
	bus_size_t size, 
	int nsegments,
    bus_size_t maxsegsz, 
    bus_size_t boundary, 
    int flags, 
    bus_dmamap_t *o_dmamp)
{
//	size_t mapsize = sizeof(struct x86_bus_dmamap) + (sizeof(bus_dma_segment_t) * (nsegments - 1));
//	bus_dmamap_t map = malloc(mapsize);
//	if (map == NULL) {
//		return ENOMEM;
//	}
//	memset(map, 0, sizeof(*map));
//	map->_dm_segcnt = nsegments;
//	map->dm_maxsegsz = maxsegsz;
//	map->dm_nsegs = 0;
//	*o_dmamp = map;
//	return 0;
	return ENODEV;
}

/*
 * ɥ쥹꡼ʪɥ쥹DMA map ¤Τꤹ롣
 * return : error number
 */
int _bus_dmamap_load(
	bus_dma_tag_t tag, 
	bus_dmamap_t map, 
	void *buf,				// ɥ쥹꡼
	bus_size_t buflen,		// ɥ쥹꡼
	struct proc *p, 
	int flags)
{
	// ʪɥ쥹Τߤ򥻥å
//	map->dm_segs[0].ds_addr = tag->physAddr;
//	return (0);
	return ENODEV;
}

/*
 * Like _bus_dmamap_load(), but for uios.
 * return : error number
 */
int _bus_dmamap_load_uio(
	bus_dma_tag_t t, 
	bus_dmamap_t map, 
	struct uio *uio,	// ꡼ʪ꡼åȤƤ뤳
	int flags)
{
//	int i;
//
//	if (map->_dm_segcnt < uio->uio_iovcnt) {
//		return EFBIG;
//	}
//	map->dm_nsegs = uio->uio_iovcnt;
//	for (i = 0; i < map->dm_nsegs; ++i) {
//		map->dm_segs[i].ds_addr = (bus_addr_t) uio->uio_iov[i].iov_base;
//		map->dm_segs[i].ds_len = uio->uio_iov[i].iov_len;
//	}
//	return (0);
	return ENODEV;
}

/*
 * Unload a DMA map.
 */
void _bus_dmamap_unload(
	bus_dma_tag_t t, 
	bus_dmamap_t map)
{
//	map->dm_nsegs = 0;
}

/*
 * Synchronize a DMA map.
 */
void _bus_dmamap_sync(
	bus_dma_tag_t t, 
	bus_dmamap_t map, 
	bus_addr_t offset,
	bus_size_t len, 
	int ops)
{
	// ⤷ʤ
}

//--------------------------------------------------------------------------------------------------
// ̤
//--------------------------------------------------------------------------------------------------

/*
 * ʪ꡼
 */
void _bus_dmamem_free(
	bus_dma_tag_t t, 
	bus_dma_segment_t *segs, 
	int nsegs)
{
	// ̤
	panic("Assertion! : %s line=%d \n",__FILE__, __LINE__);
}

/*
 * ۥɥ쥹꡼
 */
void _bus_dmamem_unmap(
	bus_dma_tag_t t, 
	caddr_t kva, 
	size_t size)
{
	// ̤
	panic("Assertion! : %s line=%d \n",__FILE__, __LINE__);
}

/*
 * Common functin for mmap(2)'ing DMA-safe memory.  May be called by
 * bus-specific DMA mmap(2)'ing functions.
 */
paddr_t _bus_dmamem_mmap(
	bus_dma_tag_t t, 
	bus_dma_segment_t *segs, 
	int nsegs,
	off_t off, 
	int prot, 
	int flags)
{
	// ̤
	panic("Assertion! : %s line=%d \n",__FILE__, __LINE__);
	return 0;
}

/*
 * Destroy a DMA map.
 */
void _bus_dmamap_destroy(
	bus_dma_tag_t t, 
	bus_dmamap_t map)
{
	panic("Assertion! : %s line=%d \n",__FILE__, __LINE__);
}

/*
 * Like _bus_dmamap_load(), but for mbufs.
 */
int _bus_dmamap_load_mbuf(
	bus_dma_tag_t t, 
	bus_dmamap_t map, 
	struct mbuf *m0,
	int flags)
{
	// ̤
	panic("Assertion! : %s line=%d \n",__FILE__, __LINE__);
	return (0);
}

/*
 * Like _bus_dmamap_load(), but for raw memory allocated with
 * bus_dmamem_alloc().
 */
int _bus_dmamap_load_raw(
	bus_dma_tag_t t, 
	bus_dmamap_t map,
	bus_dma_segment_t *segs, 
	int nsegs,
	bus_size_t size, 
	int flags)
{
	// ̤
	panic("_bus_dmamap_load_raw: not implemented");
	
	return 0;
}
