/*	$NetBSD: intr.h,v 1.21 2006/07/04 00:30:22 christos Exp $	*/

/*-
 * Copyright (c) 1998, 2001 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Charles M. Hannum, and by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * 2008: modified by minoru murashima.
 */

#ifndef _X86_INTR_H_
#define _X86_INTR_H_

#include <machine/intrdefs.h>

struct intrstub {
	void *ist_entry;
	void *ist_recurse; 
	void *ist_resume;
};

/*
 * Interrupt handler chains.  *_intr_establish() insert a handler into
 * the list.  The handler is called with its (single) argument.
 */
struct intrhand {
//	int		(*ih_fun)(void *);
//	void	*ih_arg;
//	int		ih_level;
//	int		(*ih_realfun)(void *);
//	void	*ih_realarg;
//	struct	intrhand *ih_next;
	int		ih_pin;
//	int		ih_slot;
//	struct cpu_info *ih_cpu;
};

/*
 * ߥ٥ι⤤ΤĤˤ
 *Բ
 * return : 0
 */
//static inline int splhigh()
//{
	// Ȥꤢ⤷ʤ
//	asm volatile("cli");
//	return 0;
//}

/*
 *Բ
 * return : 0
 */
//static inline int spltty()
//{
	// Ȥꤢ⤷ʤ
//	asm volatile("cli");
//	return 0;
//}

void *intr_establish(int, int, int, int, int (*)(void *), void *);
void intr_disestablish(struct intrhand *);
const char *intr_string(int);

#endif /* !_X86_INTR_H_ */
