/*
 * driver_decl.c
 */

#include <sys/param.h>
#include <sys/device.h>

static const struct cfiattrdata gpibdevcf_iattrdata = {
	"gpibdev", 1,
	{
		{"address", "-1", -1},
	}
};
static const struct cfiattrdata ymcf_iattrdata = {
	"ym", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata acpibuscf_iattrdata = {
	"acpibus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata caccf_iattrdata = {
	"cac", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata spicf_iattrdata = {
	"spi", 1,
	{
		{"slave", "NULL", 0},
	}
};
static const struct cfiattrdata radiodevcf_iattrdata = {
	"radiodev", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata ydscf_iattrdata = {
	"yds", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata mlxcf_iattrdata = {
	"mlx", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata ieee1394ifcf_iattrdata = {
	"ieee1394if", 2,
	{
		{"euihi", "-1", -1},
		{"euilo", "-1", -1},
	}
};
static const struct cfiattrdata scsibuscf_iattrdata = {
	"scsibus", 2,
	{
		{"target", "-1", -1},
		{"lun", "-1", -1},
	}
};
static const struct cfiattrdata ucombuscf_iattrdata = {
	"ucombus", 1,
	{
		{"portno", "-1", -1},
	}
};
static const struct cfiattrdata amrcf_iattrdata = {
	"amr", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata eisacf_iattrdata = {
	"eisa", 1,
	{
		{"slot", "-1", -1},
	}
};
static const struct cfiattrdata pnpbiosbuscf_iattrdata = {
	"pnpbiosbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata isabuscf_iattrdata = {
	"isabus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata apmbuscf_iattrdata = {
	"apmbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata i2cbuscf_iattrdata = {
	"i2cbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata ata_hlcf_iattrdata = {
	"ata_hl", 1,
	{
		{"drive", "-1", -1},
	}
};
static const struct cfiattrdata twacf_iattrdata = {
	"twa", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata fdccf_iattrdata = {
	"fdc", 1,
	{
		{"drive", "-1", -1},
	}
};
static const struct cfiattrdata twecf_iattrdata = {
	"twe", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata adt7467ccf_iattrdata = {
	"adt7467c", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata bthubcf_iattrdata = {
	"bthub", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata bthidbuscf_iattrdata = {
	"bthidbus", 1,
	{
		{"reportid", "-1", -1},
	}
};
static const struct cfiattrdata xirccf_iattrdata = {
	"xirc", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata pcppicf_iattrdata = {
	"pcppi", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata depcacf_iattrdata = {
	"depca", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata sbpcf_iattrdata = {
	"sbp", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata svcf_iattrdata = {
	"sv", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata ppbuscf_iattrdata = {
	"ppbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata commulticf_iattrdata = {
	"commulti", 1,
	{
		{"slave", "-1", -1},
	}
};
static const struct cfiattrdata eisabuscf_iattrdata = {
	"eisabus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata atapicf_iattrdata = {
	"atapi", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata atapibuscf_iattrdata = {
	"atapibus", 1,
	{
		{"drive", "-1", -1},
	}
};
static const struct cfiattrdata tcbuscf_iattrdata = {
	"tcbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata skccf_iattrdata = {
	"skc", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata gpibcf_iattrdata = {
	"gpib", 1,
	{
		{"address", "-1", -1},
	}
};
static const struct cfiattrdata onewirebuscf_iattrdata = {
	"onewirebus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata tsdiocf_iattrdata = {
	"tsdio", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata cardbuscf_iattrdata = {
	"cardbus", 1,
	{
		{"function", "-1", -1},
	}
};
static const struct cfiattrdata tapcf_iattrdata = {
	"tap", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata fmscf_iattrdata = {
	"fms", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata iopcf_iattrdata = {
	"iop", 1,
	{
		{"tid", "-1", -1},
	}
};
static const struct cfiattrdata vmecf_iattrdata = {
	"vme", 11,
	{
		{"addr", "-1", -1},
		{"addr#1", "-1", -1},
		{"addr#2", "-1", -1},
		{"len", "-1", -1},
		{"len#1", "-1", -1},
		{"len#2", "-1", -1},
		{"am", "-1", -1},
		{"am#1", "-1", -1},
		{"am#2", "-1", -1},
		{"irq", "-1", -1},
		{"vect", "-1", -1},
	}
};
static const struct cfiattrdata gpiocf_iattrdata = {
	"gpio", 2,
	{
		{"offset", "NULL", 0},
		{"mask", "NULL", 0},
	}
};
static const struct cfiattrdata cbbuscf_iattrdata = {
	"cbbus", 1,
	{
		{"slot", "-1", -1},
	}
};
static const struct cfiattrdata geodegcbcf_iattrdata = {
	"geodegcb", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata mdcf_iattrdata = {
	"md", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata cpubuscf_iattrdata = {
	"cpubus", 1,
	{
		{"apid", "-1", -1},
	}
};
static const struct cfiattrdata xyccf_iattrdata = {
	"xyc", 1,
	{
		{"drive", "-1", -1},
	}
};
static const struct cfiattrdata gpiobuscf_iattrdata = {
	"gpiobus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata wsscf_iattrdata = {
	"wss", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata pcmcomcf_iattrdata = {
	"pcmcom", 1,
	{
		{"slave", "-1", -1},
	}
};
static const struct cfiattrdata pckbportcf_iattrdata = {
	"pckbport", 1,
	{
		{"slot", "-1", -1},
	}
};
static const struct cfiattrdata irbuscf_iattrdata = {
	"irbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata aaccf_iattrdata = {
	"aac", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata vesabiosbuscf_iattrdata = {
	"vesabiosbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata pcibuscf_iattrdata = {
	"pcibus", 1,
	{
		{"bus", "-1", -1},
	}
};
static const struct cfiattrdata irframecf_iattrdata = {
	"irframe", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata vndcf_iattrdata = {
	"vnd", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata upccf_iattrdata = {
	"upc", 1,
	{
		{"offset", "-1", -1},
	}
};
static const struct cfiattrdata iiccf_iattrdata = {
	"iic", 2,
	{
		{"addr", "NULL", 0},
		{"size", "-1", -1},
	}
};
static const struct cfiattrdata eapcf_iattrdata = {
	"eap", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata onewirecf_iattrdata = {
	"onewire", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata adm1030ccf_iattrdata = {
	"adm1030c", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata mcabuscf_iattrdata = {
	"mcabus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata pnpbioscf_iattrdata = {
	"pnpbios", 1,
	{
		{"index", "-1", -1},
	}
};
static const struct cfiattrdata pcicf_iattrdata = {
	"pci", 2,
	{
		{"dev", "-1", -1},
		{"function", "-1", -1},
	}
};
static const struct cfiattrdata vesabioscf_iattrdata = {
	"vesabios", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata wsdisplaydevcf_iattrdata = {
	"wsdisplaydev", 1,
	{
		{"kbdmux", "1", 1},
	}
};
static const struct cfiattrdata miicf_iattrdata = {
	"mii", 1,
	{
		{"phy", "-1", -1},
	}
};
static const struct cfiattrdata cpcbuscf_iattrdata = {
	"cpcbus", 2,
	{
		{"addr", "NULL", 0},
		{"irq", "-1", -1},
	}
};
static const struct cfiattrdata nelecf_iattrdata = {
	"nele", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata acpiapmbuscf_iattrdata = {
	"acpiapmbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata parportcf_iattrdata = {
	"parport", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata pcmciacf_iattrdata = {
	"pcmcia", 1,
	{
		{"function", "-1", -1},
	}
};
static const struct cfiattrdata mskccf_iattrdata = {
	"mskc", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata adt7463ccf_iattrdata = {
	"adt7463c", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata etheripcf_iattrdata = {
	"etherip", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata ataraidcf_iattrdata = {
	"ataraid", 2,
	{
		{"vendtype", "-1", -1},
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata usbdevifcf_iattrdata = {
	"usbdevif", 6,
	{
		{"port", "-1", -1},
		{"configuration", "-1", -1},
		{"interface", "-1", -1},
		{"vendor", "-1", -1},
		{"product", "-1", -1},
		{"release", "-1", -1},
	}
};
static const struct cfiattrdata ipmibuscf_iattrdata = {
	"ipmibus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata wskbddevcf_iattrdata = {
	"wskbddev", 2,
	{
		{"console", "-1", -1},
		{"mux", "1", 1},
	}
};
static const struct cfiattrdata audiobuscf_iattrdata = {
	"audiobus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata sbdspcf_iattrdata = {
	"sbdsp", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata viapmcf_iattrdata = {
	"viapm", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata xdccf_iattrdata = {
	"xdc", 1,
	{
		{"drive", "-1", -1},
	}
};
static const struct cfiattrdata btbuscf_iattrdata = {
	"btbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata raidcf_iattrdata = {
	"raid", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata agpbuscf_iattrdata = {
	"agpbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata cs80buscf_iattrdata = {
	"cs80bus", 2,
	{
		{"slave", "-1", -1},
		{"punit", "-1", -1},
	}
};
static const struct cfiattrdata isapnpcf_iattrdata = {
	"isapnp", 6,
	{
		{"port", "-1", -1},
		{"size", "0", 0},
		{"iomem", "-1", -1},
		{"iosiz", "0", 0},
		{"irq", "-1", -1},
		{"drq", "-1", -1},
	}
};
static const struct cfiattrdata cmpcicf_iattrdata = {
	"cmpci", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata midibuscf_iattrdata = {
	"midibus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata mcacf_iattrdata = {
	"mca", 1,
	{
		{"slot", "-1", -1},
	}
};
static const struct cfiattrdata vmebuscf_iattrdata = {
	"vmebus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata wsemuldisplaydevcf_iattrdata = {
	"wsemuldisplaydev", 2,
	{
		{"console", "-1", -1},
		{"kbdmux", "1", 1},
	}
};
static const struct cfiattrdata mhzccf_iattrdata = {
	"mhzc", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata uhidbuscf_iattrdata = {
	"uhidbus", 1,
	{
		{"reportid", "-1", -1},
	}
};
static const struct cfiattrdata icpcf_iattrdata = {
	"icp", 1,
	{
		{"unit", "-1", -1},
	}
};
static const struct cfiattrdata isacf_iattrdata = {
	"isa", 7,
	{
		{"port", "-1", -1},
		{"size", "0", 0},
		{"iomem", "-1", -1},
		{"iosiz", "0", 0},
		{"irq", "-1", -1},
		{"drq", "-1", -1},
		{"drq2", "-1", -1},
	}
};
static const struct cfiattrdata comcf_iattrdata = {
	"com", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata spiflashbuscf_iattrdata = {
	"spiflashbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata eslcf_iattrdata = {
	"esl", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata fwbuscf_iattrdata = {
	"fwbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata esocf_iattrdata = {
	"eso", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata puccf_iattrdata = {
	"puc", 1,
	{
		{"port", "-1", -1},
	}
};
static const struct cfiattrdata esscf_iattrdata = {
	"ess", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata edccf_iattrdata = {
	"edc", 1,
	{
		{"drive", "-1", -1},
	}
};
static const struct cfiattrdata acpinodebuscf_iattrdata = {
	"acpinodebus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata pcmciaslotcf_iattrdata = {
	"pcmciaslot", 1,
	{
		{"slot", "-1", -1},
	}
};
static const struct cfiattrdata bicccf_iattrdata = {
	"bicc", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata usbuscf_iattrdata = {
	"usbus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata wsmousedevcf_iattrdata = {
	"wsmousedev", 1,
	{
		{"mux", "0", 0},
	}
};
static const struct cfiattrdata scsicf_iattrdata = {
	"scsi", 1,
	{
		{"channel", "-1", -1},
	}
};
static const struct cfiattrdata spibuscf_iattrdata = {
	"spibus", 0, {
		{ NULL, NULL, 0 },
	}
};
static const struct cfiattrdata atacf_iattrdata = {
	"ata", 1,
	{
		{"channel", "-1", -1},
	}
};
static const struct cfiattrdata pcmciabuscf_iattrdata = {
	"pcmciabus", 2,
	{
		{"controller", "-1", -1},
		{"socket", "-1", -1},
	}
};
static const struct cfiattrdata jmide_hlcf_iattrdata = {
	"jmide_hl", 0, {
		{ NULL, NULL, 0 },
	}
};

CFDRIVER_DECL(audio, DV_DULL, NULL);

CFDRIVER_DECL(midi, DV_DULL, NULL);

static const struct cfiattrdata * const iic_attrs[] = { &iiccf_iattrdata, NULL };
CFDRIVER_DECL(iic, DV_DULL, iic_attrs);

static const struct cfiattrdata * const irframe_attrs[] = { &irframecf_iattrdata, NULL };
CFDRIVER_DECL(irframe, DV_DULL, irframe_attrs);

CFDRIVER_DECL(lpt, DV_DULL, NULL);

CFDRIVER_DECL(ld, DV_DISK, NULL);

CFDRIVER_DECL(acphy, DV_DULL, NULL);

CFDRIVER_DECL(amhphy, DV_DULL, NULL);

CFDRIVER_DECL(bmtphy, DV_DULL, NULL);

CFDRIVER_DECL(brgphy, DV_DULL, NULL);

CFDRIVER_DECL(tlphy, DV_DULL, NULL);

CFDRIVER_DECL(nsphy, DV_DULL, NULL);

CFDRIVER_DECL(nsphyter, DV_DULL, NULL);

CFDRIVER_DECL(gentbi, DV_DULL, NULL);

CFDRIVER_DECL(glxtphy, DV_DULL, NULL);

CFDRIVER_DECL(gphyter, DV_DULL, NULL);

CFDRIVER_DECL(qsphy, DV_DULL, NULL);

CFDRIVER_DECL(inphy, DV_DULL, NULL);

CFDRIVER_DECL(iophy, DV_DULL, NULL);

CFDRIVER_DECL(exphy, DV_DULL, NULL);

CFDRIVER_DECL(lxtphy, DV_DULL, NULL);

CFDRIVER_DECL(makphy, DV_DULL, NULL);

CFDRIVER_DECL(icsphy, DV_DULL, NULL);

CFDRIVER_DECL(igphy, DV_DULL, NULL);

CFDRIVER_DECL(ikphy, DV_DULL, NULL);

CFDRIVER_DECL(sqphy, DV_DULL, NULL);

CFDRIVER_DECL(tqphy, DV_DULL, NULL);

CFDRIVER_DECL(dmphy, DV_DULL, NULL);

CFDRIVER_DECL(pnaphy, DV_DULL, NULL);

CFDRIVER_DECL(rgephy, DV_DULL, NULL);

CFDRIVER_DECL(urlphy, DV_DULL, NULL);

CFDRIVER_DECL(ukphy, DV_DULL, NULL);

CFDRIVER_DECL(ciphy, DV_DULL, NULL);

CFDRIVER_DECL(rlphy, DV_DULL, NULL);

static const struct cfiattrdata * const raid_attrs[] = { &raidcf_iattrdata, NULL };
CFDRIVER_DECL(raid, DV_DISK, raid_attrs);

static const struct cfiattrdata * const aic_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(aic, DV_DULL, aic_attrs);

static const struct cfiattrdata * const ahc_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(ahc, DV_DULL, ahc_attrs);

static const struct cfiattrdata * const ahd_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(ahd, DV_DULL, ahd_attrs);

static const struct cfiattrdata * const dpt_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(dpt, DV_DULL, dpt_attrs);

static const struct cfiattrdata * const cac_attrs[] = { &caccf_iattrdata, NULL };
CFDRIVER_DECL(cac, DV_DULL, cac_attrs);

static const struct cfiattrdata * const ciss_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(ciss, DV_DULL, ciss_attrs);

static const struct cfiattrdata * const mlx_attrs[] = { &mlxcf_iattrdata, NULL };
CFDRIVER_DECL(mlx, DV_DULL, mlx_attrs);

static const struct cfiattrdata * const icp_attrs[] = { &icpcf_iattrdata, NULL };
CFDRIVER_DECL(icp, DV_DULL, icp_attrs);

static const struct cfiattrdata * const icpsp_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(icpsp, DV_DULL, icpsp_attrs);

static const struct cfiattrdata * const aac_attrs[] = { &aaccf_iattrdata, NULL };
CFDRIVER_DECL(aac, DV_DULL, aac_attrs);

static const struct cfiattrdata * const adv_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(adv, DV_DULL, adv_attrs);

static const struct cfiattrdata * const adw_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(adw, DV_DULL, adw_attrs);

static const struct cfiattrdata * const bha_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(bha, DV_DULL, bha_attrs);

static const struct cfiattrdata * const aha_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(aha, DV_DULL, aha_attrs);

static const struct cfiattrdata * const iha_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(iha, DV_DULL, iha_attrs);

static const struct cfiattrdata * const isp_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(isp, DV_DULL, isp_attrs);

static const struct cfiattrdata * const mfi_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(mfi, DV_DULL, mfi_attrs);

static const struct cfiattrdata * const mpt_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(mpt, DV_DULL, mpt_attrs);

static const struct cfiattrdata * const njs_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(njs, DV_DULL, njs_attrs);

static const struct cfiattrdata * const siop_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(siop, DV_DULL, siop_attrs);

static const struct cfiattrdata * const esiop_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(esiop, DV_DULL, esiop_attrs);

static const struct cfiattrdata * const uha_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(uha, DV_DULL, uha_attrs);

CFDRIVER_DECL(an, DV_IFNET, NULL);

CFDRIVER_DECL(awi, DV_IFNET, NULL);

CFDRIVER_DECL(wi, DV_IFNET, NULL);

CFDRIVER_DECL(ath, DV_IFNET, NULL);

CFDRIVER_DECL(atw, DV_IFNET, NULL);

CFDRIVER_DECL(rtw, DV_IFNET, NULL);

CFDRIVER_DECL(ral, DV_IFNET, NULL);

static const struct cfiattrdata * const ep_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(ep, DV_IFNET, ep_attrs);

static const struct cfiattrdata * const ex_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(ex, DV_IFNET, ex_attrs);

CFDRIVER_DECL(lc, DV_IFNET, NULL);

CFDRIVER_DECL(le, DV_IFNET, NULL);

static const struct cfiattrdata * const hme_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(hme, DV_IFNET, hme_attrs);

CFDRIVER_DECL(tr, DV_IFNET, NULL);

CFDRIVER_DECL(cy, DV_TTY, NULL);

CFDRIVER_DECL(en, DV_IFNET, NULL);

static const struct cfiattrdata * const esp_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(esp, DV_DULL, esp_attrs);

static const struct cfiattrdata * const spc_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(spc, DV_DULL, spc_attrs);

CFDRIVER_DECL(ntwoc, DV_IFNET, NULL);

static const struct cfiattrdata * const fxp_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(fxp, DV_IFNET, fxp_attrs);

static const struct cfiattrdata * const sm_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(sm, DV_IFNET, sm_attrs);

static const struct cfiattrdata * const epic_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(epic, DV_IFNET, epic_attrs);

CFDRIVER_DECL(mbe, DV_IFNET, NULL);

static const struct cfiattrdata * const ne_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(ne, DV_IFNET, ne_attrs);

static const struct cfiattrdata * const com_attrs[] = { &comcf_iattrdata, NULL };
CFDRIVER_DECL(com, DV_TTY, com_attrs);

static const struct cfiattrdata * const pckbc_attrs[] = { &pckbportcf_iattrdata, NULL };
CFDRIVER_DECL(pckbc, DV_DULL, pckbc_attrs);

CFDRIVER_DECL(attimer, DV_DULL, NULL);

CFDRIVER_DECL(esh, DV_IFNET, NULL);

static const struct cfiattrdata * const opl_attrs[] = { &midibuscf_iattrdata, NULL };
CFDRIVER_DECL(opl, DV_DULL, opl_attrs);

static const struct cfiattrdata * const mpu_attrs[] = { &midibuscf_iattrdata, NULL };
CFDRIVER_DECL(mpu, DV_DULL, mpu_attrs);

static const struct cfiattrdata * const rtk_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(rtk, DV_IFNET, rtk_attrs);

static const struct cfiattrdata * const re_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(re, DV_IFNET, re_attrs);

static const struct cfiattrdata * const wdc_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(wdc, DV_DULL, wdc_attrs);

static const struct cfiattrdata * const atabus_attrs[] = { &ata_hlcf_iattrdata, &atapicf_iattrdata, NULL };
CFDRIVER_DECL(atabus, DV_DULL, atabus_attrs);

static const struct cfiattrdata * const ahcisata_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(ahcisata, DV_DULL, ahcisata_attrs);

static const struct cfiattrdata * const tlp_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(tlp, DV_IFNET, tlp_attrs);

static const struct cfiattrdata * const sf_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(sf, DV_IFNET, sf_attrs);

CFDRIVER_DECL(we, DV_IFNET, NULL);

CFDRIVER_DECL(ate, DV_IFNET, NULL);

CFDRIVER_DECL(fmv, DV_IFNET, NULL);

CFDRIVER_DECL(cs, DV_IFNET, NULL);

static const struct cfiattrdata * const vga_attrs[] = { &wsemuldisplaydevcf_iattrdata, NULL };
CFDRIVER_DECL(vga, DV_DULL, vga_attrs);

static const struct cfiattrdata * const uhci_attrs[] = { &usbuscf_iattrdata, NULL };
CFDRIVER_DECL(uhci, DV_DULL, uhci_attrs);

static const struct cfiattrdata * const ohci_attrs[] = { &usbuscf_iattrdata, NULL };
CFDRIVER_DECL(ohci, DV_DULL, ohci_attrs);

static const struct cfiattrdata * const ehci_attrs[] = { &usbuscf_iattrdata, NULL };
CFDRIVER_DECL(ehci, DV_DULL, ehci_attrs);

static const struct cfiattrdata * const mtd_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(mtd, DV_IFNET, mtd_attrs);

CFDRIVER_DECL(radio, DV_DULL, NULL);

static const struct cfiattrdata * const fwohci_attrs[] = { &fwbuscf_iattrdata, NULL };
CFDRIVER_DECL(fwohci, DV_DULL, fwohci_attrs);

static const struct cfiattrdata * const spic_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(spic, DV_DULL, spic_attrs);

static const struct cfiattrdata * const vnd_attrs[] = { &vndcf_iattrdata, NULL };
CFDRIVER_DECL(vnd, DV_DISK, vnd_attrs);

static const struct cfiattrdata * const md_attrs[] = { &mdcf_iattrdata, NULL };
CFDRIVER_DECL(md, DV_DISK, md_attrs);

static const struct cfiattrdata * const tap_attrs[] = { &tapcf_iattrdata, NULL };
CFDRIVER_DECL(tap, DV_IFNET, tap_attrs);

CFDRIVER_DECL(joy, DV_DULL, NULL);

static const struct cfiattrdata * const gpio_attrs[] = { &gpiocf_iattrdata, NULL };
CFDRIVER_DECL(gpio, DV_DULL, gpio_attrs);

CFDRIVER_DECL(ioapic, DV_DULL, NULL);

static const struct cfiattrdata * const scsibus_attrs[] = { &scsibuscf_iattrdata, NULL };
CFDRIVER_DECL(scsibus, DV_DULL, scsibus_attrs);

static const struct cfiattrdata * const atapibus_attrs[] = { &atapibuscf_iattrdata, NULL };
CFDRIVER_DECL(atapibus, DV_DULL, atapibus_attrs);
/*
struct cfdriver atapibus_cd = {
	{ ((void *)0), ((void *)0) }, 
	{ ((void *)0) }, 
	((void *)0), 
	"atapibus", 
	DV_DULL, 
	0, 
	atapibus_attrs 
};
*/

CFDRIVER_DECL(cd, DV_DISK, NULL);

CFDRIVER_DECL(ch, DV_DULL, NULL);

CFDRIVER_DECL(sd, DV_DISK, NULL);

CFDRIVER_DECL(st, DV_TAPE, NULL);

CFDRIVER_DECL(ses, DV_DULL, NULL);

CFDRIVER_DECL(ss, DV_DULL, NULL);

CFDRIVER_DECL(uk, DV_DULL, NULL);

CFDRIVER_DECL(wd, DV_DISK, NULL);
/*
struct cfdriver wd_cd = { 
	{ ((void *)0), ((void *)0) }, 
	{ ((void *)0) }, 
	((void *)0), 
	"wd", 
	DV_DISK, 
	0, 
	((void *)0) 
};
*/

static const struct cfiattrdata * const ataraid_attrs[] = { &ataraidcf_iattrdata, NULL };
CFDRIVER_DECL(ataraid, DV_DULL, ataraid_attrs);

static const struct cfiattrdata * const iop_attrs[] = { &iopcf_iattrdata, NULL };
CFDRIVER_DECL(iop, DV_DULL, iop_attrs);

static const struct cfiattrdata * const iopsp_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(iopsp, DV_DULL, iopsp_attrs);

CFDRIVER_DECL(dpti, DV_DULL, NULL);

static const struct cfiattrdata * const mainbus_attrs[] = { &ipmibuscf_iattrdata, &vesabiosbuscf_iattrdata, &pnpbiosbuscf_iattrdata, &apmbuscf_iattrdata, &cpubuscf_iattrdata, &acpibuscf_iattrdata, &pcibuscf_iattrdata, &mcabuscf_iattrdata, &eisabuscf_iattrdata, &isabuscf_iattrdata, NULL };
CFDRIVER_DECL(mainbus, DV_DULL, mainbus_attrs);
/*
struct cfdriver mainbus_cd = { 
	{ ((void *)0), ((void *)0) }, 
	{ ((void *)0) }, 
	((void *)0), 
	"mainbus", 
	DV_DULL, 
	0, 
	mainbus_attrs 
};
*/

static const struct cfiattrdata * const pci_attrs[] = { &pcicf_iattrdata, NULL };
CFDRIVER_DECL(pci, DV_DULL, pci_attrs);

static const struct cfiattrdata * const twe_attrs[] = { &twecf_iattrdata, NULL };
CFDRIVER_DECL(twe, DV_DULL, twe_attrs);

static const struct cfiattrdata * const twa_attrs[] = { &twacf_iattrdata, NULL };
CFDRIVER_DECL(twa, DV_DULL, twa_attrs);

static const struct cfiattrdata * const amr_attrs[] = { &amrcf_iattrdata, NULL };
CFDRIVER_DECL(amr, DV_DULL, amr_attrs);

static const struct cfiattrdata * const mly_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(mly, DV_DULL, mly_attrs);

static const struct cfiattrdata * const pcscp_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(pcscp, DV_DULL, pcscp_attrs);

CFDRIVER_DECL(fpa, DV_IFNET, NULL);

static const struct cfiattrdata * const pcn_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(pcn, DV_IFNET, pcn_attrs);

static const struct cfiattrdata * const trm_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(trm, DV_DULL, trm_attrs);

static const struct cfiattrdata * const pciide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(pciide, DV_DULL, pciide_attrs);

static const struct cfiattrdata * const acardide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(acardide, DV_DULL, acardide_attrs);

static const struct cfiattrdata * const aceride_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(aceride, DV_DULL, aceride_attrs);

static const struct cfiattrdata * const artsata_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(artsata, DV_DULL, artsata_attrs);

static const struct cfiattrdata * const cmdide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(cmdide, DV_DULL, cmdide_attrs);

static const struct cfiattrdata * const cypide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(cypide, DV_DULL, cypide_attrs);

static const struct cfiattrdata * const geodeide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(geodeide, DV_DULL, geodeide_attrs);

static const struct cfiattrdata * const hptide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(hptide, DV_DULL, hptide_attrs);

static const struct cfiattrdata * const iteide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(iteide, DV_DULL, iteide_attrs);

static const struct cfiattrdata * const jmide_attrs[] = { &jmide_hlcf_iattrdata, &atacf_iattrdata, NULL };
CFDRIVER_DECL(jmide, DV_DULL, jmide_attrs);

static const struct cfiattrdata * const optiide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(optiide, DV_DULL, optiide_attrs);

static const struct cfiattrdata * const piixide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(piixide, DV_DULL, piixide_attrs);

static const struct cfiattrdata * const pdcsata_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(pdcsata, DV_DULL, pdcsata_attrs);

static const struct cfiattrdata * const pdcide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(pdcide, DV_DULL, pdcide_attrs);

static const struct cfiattrdata * const rccide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(rccide, DV_DULL, rccide_attrs);

static const struct cfiattrdata * const svwsata_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(svwsata, DV_DULL, svwsata_attrs);

static const struct cfiattrdata * const satalink_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(satalink, DV_DULL, satalink_attrs);

static const struct cfiattrdata * const siside_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(siside, DV_DULL, siside_attrs);

static const struct cfiattrdata * const slide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(slide, DV_DULL, slide_attrs);

static const struct cfiattrdata * const viaide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(viaide, DV_DULL, viaide_attrs);

static const struct cfiattrdata * const stpcide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(stpcide, DV_DULL, stpcide_attrs);

static const struct cfiattrdata * const ixpide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(ixpide, DV_DULL, ixpide_attrs);

static const struct cfiattrdata * const ppb_attrs[] = { &pcibuscf_iattrdata, NULL };
CFDRIVER_DECL(ppb, DV_DULL, ppb_attrs);

CFDRIVER_DECL(cz, DV_DULL, NULL);

static const struct cfiattrdata * const tl_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(tl, DV_IFNET, tl_attrs);

CFDRIVER_DECL(lmc, DV_IFNET, NULL);

static const struct cfiattrdata * const bktr_attrs[] = { &radiodevcf_iattrdata, NULL };
CFDRIVER_DECL(bktr, DV_DULL, bktr_attrs);

static const struct cfiattrdata * const clcs_attrs[] = { &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(clcs, DV_DULL, clcs_attrs);

static const struct cfiattrdata * const clct_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(clct, DV_DULL, clct_attrs);

static const struct cfiattrdata * const fms_attrs[] = { &fmscf_iattrdata, &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(fms, DV_DULL, fms_attrs);

static const struct cfiattrdata * const eap_attrs[] = { &eapcf_iattrdata, &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(eap, DV_DULL, eap_attrs);

static const struct cfiattrdata * const auacer_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(auacer, DV_DULL, auacer_attrs);

static const struct cfiattrdata * const auich_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(auich, DV_DULL, auich_attrs);

static const struct cfiattrdata * const auvia_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(auvia, DV_DULL, auvia_attrs);

static const struct cfiattrdata * const auixp_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(auixp, DV_DULL, auixp_attrs);

static const struct cfiattrdata * const azalia_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(azalia, DV_DULL, azalia_attrs);

static const struct cfiattrdata * const neo_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(neo, DV_DULL, neo_attrs);

static const struct cfiattrdata * const esa_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(esa, DV_DULL, esa_attrs);

static const struct cfiattrdata * const eso_attrs[] = { &esocf_iattrdata, &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(eso, DV_DULL, eso_attrs);

static const struct cfiattrdata * const esm_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(esm, DV_DULL, esm_attrs);

static const struct cfiattrdata * const sv_attrs[] = { &svcf_iattrdata, &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(sv, DV_DULL, sv_attrs);

static const struct cfiattrdata * const cmpci_attrs[] = { &cmpcicf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(cmpci, DV_DULL, cmpci_attrs);

static const struct cfiattrdata * const yds_attrs[] = { &ydscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(yds, DV_DULL, yds_attrs);

static const struct cfiattrdata * const emuxki_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(emuxki, DV_DULL, emuxki_attrs);

static const struct cfiattrdata * const autri_attrs[] = { &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(autri, DV_DULL, autri_attrs);

static const struct cfiattrdata * const puc_attrs[] = { &puccf_iattrdata, NULL };
CFDRIVER_DECL(puc, DV_DULL, puc_attrs);

static const struct cfiattrdata * const vr_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(vr, DV_IFNET, vr_attrs);

static const struct cfiattrdata * const sip_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(sip, DV_IFNET, sip_attrs);

static const struct cfiattrdata * const gsip_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(gsip, DV_IFNET, gsip_attrs);

static const struct cfiattrdata * const stge_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(stge, DV_IFNET, stge_attrs);

static const struct cfiattrdata * const wm_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(wm, DV_IFNET, wm_attrs);

static const struct cfiattrdata * const bge_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(bge, DV_IFNET, bge_attrs);

static const struct cfiattrdata * const bnx_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(bnx, DV_IFNET, bnx_attrs);

CFDRIVER_DECL(ti, DV_IFNET, NULL);

static const struct cfiattrdata * const ste_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(ste, DV_IFNET, ste_attrs);

static const struct cfiattrdata * const cbb_attrs[] = { &pcmciaslotcf_iattrdata, NULL };
CFDRIVER_DECL(cbb, DV_DULL, cbb_attrs);

static const struct cfiattrdata * const piixpm_attrs[] = { &i2cbuscf_iattrdata, NULL };
CFDRIVER_DECL(piixpm, DV_DULL, piixpm_attrs);

static const struct cfiattrdata * const amdpm_attrs[] = { &i2cbuscf_iattrdata, NULL };
CFDRIVER_DECL(amdpm, DV_DULL, amdpm_attrs);

CFDRIVER_DECL(hifn, DV_DULL, NULL);

CFDRIVER_DECL(ubsec, DV_DULL, NULL);

static const struct cfiattrdata * const oboe_attrs[] = { &irbuscf_iattrdata, NULL };
CFDRIVER_DECL(oboe, DV_DULL, oboe_attrs);

CFDRIVER_DECL(weasel, DV_DULL, NULL);

CFDRIVER_DECL(txp, DV_IFNET, NULL);

static const struct cfiattrdata * const skc_attrs[] = { &skccf_iattrdata, NULL };
CFDRIVER_DECL(skc, DV_DULL, skc_attrs);

static const struct cfiattrdata * const sk_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(sk, DV_IFNET, sk_attrs);

static const struct cfiattrdata * const bce_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(bce, DV_IFNET, bce_attrs);

CFDRIVER_DECL(dge, DV_IFNET, NULL);

CFDRIVER_DECL(ipw, DV_IFNET, NULL);

CFDRIVER_DECL(iwi, DV_IFNET, NULL);

CFDRIVER_DECL(wpi, DV_IFNET, NULL);

CFDRIVER_DECL(xge, DV_IFNET, NULL);

static const struct cfiattrdata * const vge_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(vge, DV_IFNET, vge_attrs);

static const struct cfiattrdata * const nfe_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(nfe, DV_IFNET, nfe_attrs);

static const struct cfiattrdata * const mskc_attrs[] = { &mskccf_iattrdata, NULL };
CFDRIVER_DECL(mskc, DV_DULL, mskc_attrs);

static const struct cfiattrdata * const msk_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(msk, DV_IFNET, msk_attrs);

CFDRIVER_DECL(agp, DV_DULL, NULL);

static const struct cfiattrdata * const pchb_attrs[] = { &agpbuscf_iattrdata, &pcibuscf_iattrdata, NULL };
CFDRIVER_DECL(pchb, DV_DULL, pchb_attrs);

static const struct cfiattrdata * const elansc_attrs[] = { &gpiobuscf_iattrdata, NULL };
CFDRIVER_DECL(elansc, DV_DULL, elansc_attrs);

static const struct cfiattrdata * const gcscide_attrs[] = { &atacf_iattrdata, NULL };
CFDRIVER_DECL(gcscide, DV_DULL, gcscide_attrs);

static const struct cfiattrdata * const geodegcb_attrs[] = { &geodegcbcf_iattrdata, NULL };
CFDRIVER_DECL(geodegcb, DV_DULL, geodegcb_attrs);

static const struct cfiattrdata * const geodewdog_attrs[] = { &geodegcbcf_iattrdata, NULL };
CFDRIVER_DECL(geodewdog, DV_DULL, geodewdog_attrs);

static const struct cfiattrdata * const geodecntr_attrs[] = { &geodegcbcf_iattrdata, NULL };
CFDRIVER_DECL(geodecntr, DV_DULL, geodecntr_attrs);

static const struct cfiattrdata * const pceb_attrs[] = { &isabuscf_iattrdata, &eisabuscf_iattrdata, NULL };
CFDRIVER_DECL(pceb, DV_DULL, pceb_attrs);

static const struct cfiattrdata * const pcib_attrs[] = { &isabuscf_iattrdata, NULL };
CFDRIVER_DECL(pcib, DV_DULL, pcib_attrs);

static const struct cfiattrdata * const piixpcib_attrs[] = { &isabuscf_iattrdata, NULL };
CFDRIVER_DECL(piixpcib, DV_DULL, piixpcib_attrs);

static const struct cfiattrdata * const pcmb_attrs[] = { &mcabuscf_iattrdata, NULL };
CFDRIVER_DECL(pcmb, DV_DULL, pcmb_attrs);

static const struct cfiattrdata * const isa_attrs[] = { &isacf_iattrdata, NULL };
CFDRIVER_DECL(isa, DV_DULL, isa_attrs);

static const struct cfiattrdata * const sea_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(sea, DV_DULL, sea_attrs);

static const struct cfiattrdata * const wds_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(wds, DV_DULL, wds_attrs);

CFDRIVER_DECL(ec, DV_IFNET, NULL);

CFDRIVER_DECL(eg, DV_IFNET, NULL);

CFDRIVER_DECL(el, DV_IFNET, NULL);

CFDRIVER_DECL(iy, DV_IFNET, NULL);

static const struct cfiattrdata * const nele_attrs[] = { &nelecf_iattrdata, NULL };
CFDRIVER_DECL(nele, DV_DULL, nele_attrs);

static const struct cfiattrdata * const bicc_attrs[] = { &bicccf_iattrdata, NULL };
CFDRIVER_DECL(bicc, DV_DULL, bicc_attrs);

CFDRIVER_DECL(ef, DV_IFNET, NULL);

CFDRIVER_DECL(ai, DV_IFNET, NULL);

CFDRIVER_DECL(ix, DV_IFNET, NULL);

static const struct cfiattrdata * const sb_attrs[] = { &midibuscf_iattrdata, &sbdspcf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(sb, DV_DULL, sb_attrs);

static const struct cfiattrdata * const pas_attrs[] = { &sbdspcf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(pas, DV_DULL, pas_attrs);

static const struct cfiattrdata * const wss_attrs[] = { &wsscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(wss, DV_DULL, wss_attrs);

static const struct cfiattrdata * const ess_attrs[] = { &esscf_iattrdata, &midibuscf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(ess, DV_DULL, ess_attrs);

static const struct cfiattrdata * const ym_attrs[] = { &ymcf_iattrdata, &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(ym, DV_DULL, ym_attrs);

static const struct cfiattrdata * const gus_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(gus, DV_DULL, gus_attrs);

static const struct cfiattrdata * const pcdisplay_attrs[] = { &wsemuldisplaydevcf_iattrdata, NULL };
CFDRIVER_DECL(pcdisplay, DV_DULL, pcdisplay_attrs);

static const struct cfiattrdata * const pcppi_attrs[] = { &pcppicf_iattrdata, NULL };
CFDRIVER_DECL(pcppi, DV_DULL, pcppi_attrs);

static const struct cfiattrdata * const isapnp_attrs[] = { &isapnpcf_iattrdata, NULL };
CFDRIVER_DECL(isapnp, DV_DULL, isapnp_attrs);

static const struct cfiattrdata * const guspnp_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(guspnp, DV_DULL, guspnp_attrs);

CFDRIVER_DECL(npx, DV_DULL, NULL);

static const struct cfiattrdata * const lms_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(lms, DV_DULL, lms_attrs);

static const struct cfiattrdata * const mms_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(mms, DV_DULL, mms_attrs);

CFDRIVER_DECL(wsdisplay, DV_DULL, NULL);
/*
struct cfdriver wsdisplay_cd = { 
	{ ((void *)0), 
	((void *)0) }, 
	{ ((void *)0) }, 
	((void *)0), 
	"wsdisplay", 
	DV_DULL, 
	0, 
	((void *)0) 
};
*/
CFDRIVER_DECL(wskbd, DV_DULL, NULL);

CFDRIVER_DECL(wsmouse, DV_DULL, NULL);

static const struct cfiattrdata * const pckbd_attrs[] = { &wskbddevcf_iattrdata, NULL };
CFDRIVER_DECL(pckbd, DV_DULL, pckbd_attrs);

static const struct cfiattrdata * const pms_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(pms, DV_DULL, pms_attrs);

CFDRIVER_DECL(sysbeep, DV_DULL, NULL);

static const struct cfiattrdata * const fdc_attrs[] = { &fdccf_iattrdata, NULL };
CFDRIVER_DECL(fdc, DV_DULL, fdc_attrs);

CFDRIVER_DECL(fd, DV_DISK, NULL);

static const struct cfiattrdata * const eisa_attrs[] = { &eisacf_iattrdata, NULL };
CFDRIVER_DECL(eisa, DV_DULL, eisa_attrs);

static const struct cfiattrdata * const ahb_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(ahb, DV_DULL, ahb_attrs);

CFDRIVER_DECL(fea, DV_IFNET, NULL);

static const struct cfiattrdata * const mca_attrs[] = { &mcacf_iattrdata, NULL };
CFDRIVER_DECL(mca, DV_DULL, mca_attrs);

CFDRIVER_DECL(elmc, DV_IFNET, NULL);

static const struct cfiattrdata * const edc_attrs[] = { &edccf_iattrdata, NULL };
CFDRIVER_DECL(edc, DV_DULL, edc_attrs);

CFDRIVER_DECL(ed, DV_DISK, NULL);

CFDRIVER_DECL(tra, DV_IFNET, NULL);

CFDRIVER_DECL(cpu, DV_DULL, NULL);

static const struct cfiattrdata * const cardslot_attrs[] = { &pcmciabuscf_iattrdata, &cbbuscf_iattrdata, NULL };
CFDRIVER_DECL(cardslot, DV_DULL, cardslot_attrs);

static const struct cfiattrdata * const cardbus_attrs[] = { &cardbuscf_iattrdata, NULL };
CFDRIVER_DECL(cardbus, DV_DULL, cardbus_attrs);

static const struct cfiattrdata * const pcic_attrs[] = { &pcmciabuscf_iattrdata, NULL };
CFDRIVER_DECL(pcic, DV_DULL, pcic_attrs);

static const struct cfiattrdata * const tcic_attrs[] = { &pcmciabuscf_iattrdata, NULL };
CFDRIVER_DECL(tcic, DV_DULL, tcic_attrs);

static const struct cfiattrdata * const pcmcia_attrs[] = { &pcmciacf_iattrdata, NULL };
CFDRIVER_DECL(pcmcia, DV_DULL, pcmcia_attrs);

static const struct cfiattrdata * const pcmcom_attrs[] = { &pcmcomcf_iattrdata, NULL };
CFDRIVER_DECL(pcmcom, DV_DULL, pcmcom_attrs);

CFDRIVER_DECL(cnw, DV_IFNET, NULL);

static const struct cfiattrdata * const mhzc_attrs[] = { &mhzccf_iattrdata, NULL };
CFDRIVER_DECL(mhzc, DV_DULL, mhzc_attrs);

CFDRIVER_DECL(ray, DV_IFNET, NULL);

static const struct cfiattrdata * const xirc_attrs[] = { &xirccf_iattrdata, NULL };
CFDRIVER_DECL(xirc, DV_DULL, xirc_attrs);

static const struct cfiattrdata * const xi_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(xi, DV_IFNET, xi_attrs);

static const struct cfiattrdata * const bt3c_attrs[] = { &btbuscf_iattrdata, NULL };
CFDRIVER_DECL(bt3c, DV_DULL, bt3c_attrs);

static const struct cfiattrdata * const usb_attrs[] = { &usbdevifcf_iattrdata, NULL };
CFDRIVER_DECL(usb, DV_DULL, usb_attrs);

static const struct cfiattrdata * const uhub_attrs[] = { &usbdevifcf_iattrdata, NULL };
CFDRIVER_DECL(uhub, DV_DULL, uhub_attrs);

static const struct cfiattrdata * const uaudio_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(uaudio, DV_DULL, uaudio_attrs);

static const struct cfiattrdata * const umidi_attrs[] = { &midibuscf_iattrdata, NULL };
CFDRIVER_DECL(umidi, DV_DULL, umidi_attrs);

CFDRIVER_DECL(ucom, DV_DULL, NULL);

CFDRIVER_DECL(ugen, DV_DULL, NULL);

static const struct cfiattrdata * const uhidev_attrs[] = { &uhidbuscf_iattrdata, NULL };
CFDRIVER_DECL(uhidev, DV_DULL, uhidev_attrs);

CFDRIVER_DECL(uhid, DV_DULL, NULL);

static const struct cfiattrdata * const ukbd_attrs[] = { &wskbddevcf_iattrdata, NULL };
CFDRIVER_DECL(ukbd, DV_DULL, ukbd_attrs);

static const struct cfiattrdata * const ums_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(ums, DV_DULL, ums_attrs);

static const struct cfiattrdata * const uep_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(uep, DV_DULL, uep_attrs);

CFDRIVER_DECL(ucycom, DV_DULL, NULL);

CFDRIVER_DECL(ulpt, DV_DULL, NULL);

static const struct cfiattrdata * const umass_attrs[] = { &ata_hlcf_iattrdata, &atapicf_iattrdata, &scsicf_iattrdata, NULL };
CFDRIVER_DECL(umass, DV_DULL, umass_attrs);

static const struct cfiattrdata * const uirda_attrs[] = { &irbuscf_iattrdata, NULL };
CFDRIVER_DECL(uirda, DV_DULL, uirda_attrs);

static const struct cfiattrdata * const ustir_attrs[] = { &irbuscf_iattrdata, NULL };
CFDRIVER_DECL(ustir, DV_DULL, ustir_attrs);

static const struct cfiattrdata * const ubt_attrs[] = { &btbuscf_iattrdata, NULL };
CFDRIVER_DECL(ubt, DV_DULL, ubt_attrs);

CFDRIVER_DECL(urio, DV_DULL, NULL);

static const struct cfiattrdata * const uvisor_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(uvisor, DV_DULL, uvisor_attrs);

CFDRIVER_DECL(uyap, DV_DULL, NULL);

static const struct cfiattrdata * const udsbr_attrs[] = { &radiodevcf_iattrdata, NULL };
CFDRIVER_DECL(udsbr, DV_DULL, udsbr_attrs);

static const struct cfiattrdata * const aue_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(aue, DV_IFNET, aue_attrs);

CFDRIVER_DECL(cdce, DV_IFNET, NULL);

CFDRIVER_DECL(cue, DV_IFNET, NULL);

CFDRIVER_DECL(kue, DV_IFNET, NULL);

CFDRIVER_DECL(upl, DV_IFNET, NULL);

static const struct cfiattrdata * const url_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(url, DV_IFNET, url_attrs);

static const struct cfiattrdata * const axe_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(axe, DV_IFNET, axe_attrs);

static const struct cfiattrdata * const udav_attrs[] = { &miicf_iattrdata, NULL };
CFDRIVER_DECL(udav, DV_IFNET, udav_attrs);

static const struct cfiattrdata * const umodem_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(umodem, DV_DULL, umodem_attrs);

static const struct cfiattrdata * const uftdi_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(uftdi, DV_DULL, uftdi_attrs);

static const struct cfiattrdata * const uplcom_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(uplcom, DV_DULL, uplcom_attrs);

static const struct cfiattrdata * const umct_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(umct, DV_DULL, umct_attrs);

static const struct cfiattrdata * const uvscom_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(uvscom, DV_DULL, uvscom_attrs);

static const struct cfiattrdata * const ubsa_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(ubsa, DV_DULL, ubsa_attrs);

static const struct cfiattrdata * const uipaq_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(uipaq, DV_DULL, uipaq_attrs);

static const struct cfiattrdata * const ukyopon_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(ukyopon, DV_DULL, ukyopon_attrs);

static const struct cfiattrdata * const uslsa_attrs[] = { &ucombuscf_iattrdata, NULL };
CFDRIVER_DECL(uslsa, DV_DULL, uslsa_attrs);

CFDRIVER_DECL(uscanner, DV_DULL, NULL);

static const struct cfiattrdata * const usscanner_attrs[] = { &scsicf_iattrdata, NULL };
CFDRIVER_DECL(usscanner, DV_DULL, usscanner_attrs);

CFDRIVER_DECL(atu, DV_IFNET, NULL);

CFDRIVER_DECL(rum, DV_IFNET, NULL);

CFDRIVER_DECL(utoppy, DV_DULL, NULL);

static const struct cfiattrdata * const bthub_attrs[] = { &bthubcf_iattrdata, NULL };
CFDRIVER_DECL(bthub, DV_DULL, bthub_attrs);

static const struct cfiattrdata * const bthidev_attrs[] = { &bthidbuscf_iattrdata, NULL };
CFDRIVER_DECL(bthidev, DV_DULL, bthidev_attrs);

static const struct cfiattrdata * const btkbd_attrs[] = { &wskbddevcf_iattrdata, NULL };
CFDRIVER_DECL(btkbd, DV_DULL, btkbd_attrs);

static const struct cfiattrdata * const btms_attrs[] = { &wsmousedevcf_iattrdata, NULL };
CFDRIVER_DECL(btms, DV_DULL, btms_attrs);

static const struct cfiattrdata * const btsco_attrs[] = { &audiobuscf_iattrdata, NULL };
CFDRIVER_DECL(btsco, DV_DULL, btsco_attrs);

static const struct cfiattrdata * const ieee1394if_attrs[] = { &ieee1394ifcf_iattrdata, NULL };
CFDRIVER_DECL(ieee1394if, DV_DULL, ieee1394if_attrs);

CFDRIVER_DECL(fwip, DV_IFNET, NULL);

static const struct cfiattrdata * const sbp_attrs[] = { &sbpcf_iattrdata, &scsicf_iattrdata, NULL };
CFDRIVER_DECL(sbp, DV_DULL, sbp_attrs);

static const struct cfiattrdata * const acpi_attrs[] = { &acpinodebuscf_iattrdata, &acpiapmbuscf_iattrdata, NULL };
CFDRIVER_DECL(acpi, DV_DULL, acpi_attrs);

CFDRIVER_DECL(acpiec, DV_DULL, NULL);

CFDRIVER_DECL(acpilid, DV_DULL, NULL);

CFDRIVER_DECL(acpibut, DV_DULL, NULL);

CFDRIVER_DECL(acpiacad, DV_DULL, NULL);

CFDRIVER_DECL(acpibat, DV_DULL, NULL);

CFDRIVER_DECL(acpitz, DV_DULL, NULL);

CFDRIVER_DECL(vald, DV_DULL, NULL);

CFDRIVER_DECL(sony, DV_DULL, NULL);

CFDRIVER_DECL(glxsb, DV_DULL, NULL);
