/*	$NetBSD: libkern.h,v 1.67 2006/10/08 03:14:55 thorpej Exp $	*/

/*-
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)libkern.h	8.2 (Berkeley) 8/5/94
 *
 * 2009: modified by minoru murashima.
 */

#ifndef _LIB_LIBKERN_LIBKERN_H_
#define _LIB_LIBKERN_LIBKERN_H_

#include <sys/types.h>

#ifndef LIBKERN_INLINE
#define LIBKERN_INLINE	static inline
#define LIBKERN_BODY
#endif

#ifdef LIBKERN_BODY
LIBKERN_INLINE int imax(int a, int b)
{
	return (a > b ? a : b);
}

LIBKERN_INLINE int imin(int a, int b)
{
	return (a < b ? a : b);
}

LIBKERN_INLINE long lmax(long a, long b)
{
	return (a > b ? a : b);
}

LIBKERN_INLINE long lmin(long a, long b)
{
	return (a < b ? a : b);
}

LIBKERN_INLINE u_int max(u_int a, u_int b)
{
	return (a > b ? a : b);
}

LIBKERN_INLINE u_int min(u_int a, u_int b)
{
	return (a < b ? a : b);
}

LIBKERN_INLINE u_long ulmax(u_long a, u_long b)
{
	return (a > b ? a : b);
}

LIBKERN_INLINE u_long ulmin(u_long a, u_long b)
{
	return (a < b ? a : b);
}
/*
LIBKERN_INLINE int abs(int j)
{
	return(j < 0 ? -j : j);
}
*/
LIBKERN_INLINE int isspace(int ch)
{
	return (ch == ' ' || (ch >= '\t' && ch <= '\r'));
}

LIBKERN_INLINE int isascii(int ch)
{
	return ((ch & ~0x7f) == 0);
}

LIBKERN_INLINE int isupper(int ch)
{
	return (ch >= 'A' && ch <= 'Z');
}

LIBKERN_INLINE int islower(int ch)
{
	return (ch >= 'a' && ch <= 'z');
}

LIBKERN_INLINE int isalpha(int ch)
{
	return (isupper(ch) || islower(ch));
}

LIBKERN_INLINE int isdigit(int ch)
{
	return (ch >= '0' && ch <= '9');
}

LIBKERN_INLINE int isxdigit(int ch)
{
	return (isdigit(ch) ||
	    (ch >= 'A' && ch <= 'F') ||
	    (ch >= 'a' && ch <= 'f'));
}

LIBKERN_INLINE int toupper(int ch)
{
	if (islower(ch))
		return (ch - 0x20);
	return (ch);
}

LIBKERN_INLINE int tolower(int ch)
{
	if (isupper(ch))
		return (ch + 0x20);
	return (ch);
}
#endif

#define	__NULL_STMT		do { } while (/* CONSTCOND */ 0)

#ifdef NDEBUG						/* tradition! */
#define	assert(e)	((void)0)
#else
#ifdef __STDC__
#define	assert(e)	(__predict_true((e)) ? (void)0 :		    \
			    __assert("", __FILE__, __LINE__, #e))
#else
#define	assert(e)	(__predict_true((e)) ? (void)0 :		    \
			    __assert("", __FILE__, __LINE__, "e"))
#endif
#endif

#ifdef __COVERITY__
#ifndef DIAGNOSTIC
#define DIAGNOSTIC
#endif
#endif

#ifndef DEBUG
#ifdef lint
#define	KDASSERT(e)	/* NOTHING */
#else /* lint */
#define	KDASSERT(e)	((void)0)
#endif /* lint */
#else
#ifdef __STDC__
#define	KDASSERT(e)	(__predict_true((e)) ? (void)0 :		    \
			    __assert("debugging ", __FILE__, __LINE__, #e))
#else
#define	KDASSERT(e)	(__predict_true((e)) ? (void)0 :		    \
			    __assert("debugging ", __FILE__, __LINE__, "e"))
#endif
#endif
/*
 * XXX: For compatibility we use SMALL_RANDOM by default.
 */
#define SMALL_RANDOM

extern int	 pmatch(const char *, const char *, const char **);
extern long	 random(void);

#endif /* !_LIB_LIBKERN_LIBKERN_H_ */
