/*	$NetBSD: subr_devsw.c,v 1.10 2006/11/01 10:17:58 yamt Exp $	*/
/*-
 * Copyright (c) 2001,2002 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by MAEKAWA Masahide <gehenna@NetBSD.org>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * 2008: modified by minoru murashima.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <ctype.h>
#include <stddef.h>
#include <string.h>

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern const struct bdevsw **bdevsw;
extern struct devsw_conv *devsw_conv;
extern struct cdevsw **cdevsw;
extern int max_devsw_convs;
extern int max_bdevsws;
extern int max_cdevsws;

//===================================== PRIVATE ====================================================


//===================================== PUBLIC =====================================================

int bdevsw_lookup_major(
	const struct bdevsw *bdev)
{
	int bmajor;

	for (bmajor = 0 ; bmajor < max_bdevsws ; bmajor++) {
		if (bdevsw[bmajor] == bdev) {
			return (bmajor);
		}
	}

	return (-1);
}

int cdevsw_lookup_major(
	const struct cdevsw *cdev)
{
	int cmajor;

	for (cmajor = 0 ; cmajor < max_cdevsws ; cmajor++) {
		if (cdevsw[cmajor] == cdev) {
			return (cmajor);
		}
	}

	return (-1);
}

const struct cdevsw *cdevsw_lookup(
	dev_t dev)
{
	int cmajor;

	if (dev == NODEV) {
		return (NULL);
	}
	cmajor = major(dev);
	if (cmajor < 0 || max_cdevsws <= cmajor) {
		return (NULL);
	}

	return (cdevsw[cmajor]);
}

/*
 * Convert from device name to block major number.
 */
int devsw_name2blk(
	const char *name, 
	char *devname, 
	size_t devnamelen)
{
	struct devsw_conv *conv;
	int bmajor, i;

	if (name == NULL) {
		return (-1);
	}

	for (i = 0 ; i < max_devsw_convs ; i++) {
		size_t len;

		conv = &devsw_conv[i];
		if (conv->d_name == NULL) {
			continue;
		}
		len = strlen(conv->d_name);
		if (strncmp(conv->d_name, name, len) != 0) {
			continue;
		}
		if (*(name +len) && !isdigit(*(name + len))) {
			continue;
		}
		bmajor = conv->d_bmajor;
		if (bmajor < 0 || bmajor >= max_bdevsws || bdevsw[bmajor] == NULL) {
			break;
		}
		if (devname != NULL) {
			strncpy(devname, conv->d_name, devnamelen);
			devname[devnamelen - 1] = '\0';
		}
		return (bmajor);
	}

	return (-1);
}
