/*	$NetBSD: sys_generic.c,v 1.97.2.1 2007/09/11 09:58:24 xtraeme Exp $	*/

/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)sys_generic.c	8.9 (Berkeley) 2/14/95
 */

#include <sys/systm.h>
#include <sys/queue.h>
#include <sys/poll.h>
#include <sys/selinfo.h>

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern int _wakeup(void*);

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * Record a select request.
 */
void selrecord(
	struct lwp *selector, 
	struct selinfo *sip)
{
/*
	struct lwp	*l;
	struct proc	*p;
	pid_t		mypid;

	mypid = selector->l_proc->p_pid;
	if (sip->sel_pid == mypid) {
		return;
	}
	if (sip->sel_pid && (p = pfind(sip->sel_pid))) {
		LIST_FOREACH(l, &p->p_lwps, l_sibling) {
			if (l->l_wchan == (caddr_t) &selwait) {
				sip->sel_collision = 1;
				return;
			}
		}
	}

	sip->sel_pid = mypid;
*/
	sip->waitTask = selector;		// POLLƤӽФ
}

/*
 * Do a wakeup when a selectable event occurs.
 */
void selwakeup(
	struct selinfo *sip)
{
/*
	struct lwp *l;
	struct proc *p;
	int s;

	if (sip->sel_pid == 0) {
		return;
	}
	if (sip->sel_collision) {
		sip->sel_pid = 0;
		nselcoll++;
		sip->sel_collision = 0;
		wakeup((caddr_t) &selwait);
		return;
	}
	p = pfind(sip->sel_pid);
	sip->sel_pid = 0;
	if (p != NULL) {
		LIST_FOREACH(l, &p->p_lwps, l_sibling) {
			SCHED_LOCK(s);
			if (l->l_wchan == (caddr_t)&selwait) {
				if (l->l_stat == LSSLEEP) {
					setrunnable(l);
				}
				else {
					unsleep(l);
				}
			} 
			else if (l->l_flag & L_SELECT) {
				l->l_flag &= ~L_SELECT;
			}
			SCHED_UNLOCK(s);
		}
	}
*/
	extern int awakeTask(void*);

	if (sip->waitTask != NULL) {
		awakeTask(sip->waitTask);
		sip->waitTask = NULL;
	}
}

/*ARGSUSED*/
int seltrue(
	dev_t dev, 
	int events, 
	struct lwp *l)
{
	return (events & (POLLIN | POLLOUT | POLLRDNORM | POLLWRNORM));
}

void selnotify(
	struct selinfo *sip, 
	long knhint)
{
	selwakeup(sip);
}
