/*
 * ⥸塼ᥤ
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/conf.h>
#include <sys/callout.h>
#include <errno.h>
#include <module/Module.h>

extern const struct cdevsw wsmouse_cdevsw;

/*
 * Configure the system's hardware.
 */
static void configure(void)
{
	extern struct cfdriver *cfdriver_list_initial[];
	extern struct cfattachinit cfattachinit[];
	extern struct cfdata cfdata[];
	extern short cfroots[];

	setInitialTable(cfdriver_list_initial, cfattachinit, cfdata, cfroots);

	callout_startup();

	/* Initialize data structures. */
	config_init();

	/*
	 * Do the machine-dependent portion of autoconfiguration.  This
	 * sets the configuration machinery here in motion by "finding"
	 * the root bus.  When this function returns, we expect interrupts
	 * to be enabled.
	 */
//	bios32_init();
//	pcibios_init();
}

int main()
{
	extern void setWaitObj(void*, void*);
	extern void *getReturnMethod();
	void *waitAggrObj;
	void *waitIdentObj;
	int error;

	// ⥸塼
	if (initModule(&waitAggrObj, &waitIdentObj) != 0) {
		printf("initModue failed!\n");
		return 0;
	}
	setWaitObj(waitAggrObj, waitIdentObj);

	// ǥХϿ
	configure();

	// ISABUSϿ
	if (config_rootfound("isa",getIsabusAttachArgs()) == NULL) {
		panic("configure: isabus not configured");
	}

	// ⥸塼Ͽ
	if (cdevsw_attach("mouse", &wsmouse_cdevsw, makedev(cdevsw_lookup_major(&wsmouse_cdevsw), 0), getReturnMethod()) != 0) {
		printf("cdevsw_attach failed!\n");
		return 0;
	}

	// ꡼
	error = sleepModule();
	if (error != 0) {
		printf("Module sleep error! : %d\n", errno);
	}

	// ̥ץޤäƤʤ

	printf("Module was deleted\n");

	return 0;
}
