/*
 * ⥸塼ᥤ
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/conf.h>
#include <machine/bios32.h>
#include <errno.h>
#include <pci/pcivar.h>

extern struct cdevsw pci_cdevsw;

/*
 * Configure the system's hardware.
 */
static void configure(void)
{
	extern struct cfdriver *cfdriver_list_initial[];
	extern struct cfattachinit cfattachinit[];
	extern struct cfdata cfdata[];
	extern short cfroots[];
	extern struct cdevsw **cdevsw;
	extern int max_cdevsws;

	setInitialTable(cfdriver_list_initial, cfattachinit, cfdata, cfroots);
	setCdevsw(cdevsw);
	setMaxCdevsws(max_cdevsws);

	callout_startup();

	/* Initialize data structures. */
	config_init();

	/*
	 * Do the machine-dependent portion of autoconfiguration.  This
	 * sets the configuration machinery here in motion by "finding"
	 * the root bus.  When this function returns, we expect interrupts
	 * to be enabled.
	 */
	bios32_init();
	pcibios_init();
}

int main()
{
	static struct pcibus_attach_args pba;
	int error;

	// ⥸塼
	if (initModule() != 0) {
		printf("initModue failed!\n");
		return 0;
	}

	// ǥХϿ
	configure();

	// PCIBUSϿ
	pba.pba_iot = X86_BUS_SPACE_IO;
	pba.pba_memt = X86_BUS_SPACE_MEM;
	pba.pba_dmat = &pci_bus_dma_tag;
	pba.pba_dmat64 = NULL;
	pba.pba_pc = NULL;
	pba.pba_flags = pci_bus_flags();
	pba.pba_bus = 0;
	pba.pba_bridgetag = NULL;
	if (config_rootfound("pci", &pba) == NULL) {
		panic("configure: pcibus not configured");
	}

	// ⥸塼Ͽ
	if (cdevsw_attach("pci", &pci_cdevsw, cdevsw_lookup_major(&pci_cdevsw), getReturnMethod()) != 0) {
		printf("cdevsw_attach failed!\n");
		return 0;
	}

	// ꡼
	error = sleepModule();
	if (error != 0) {
		printf("Module sleep error! : %d\n", errno);
	}

	// ̥ץޤäƤʤ

	printf("Module was deleted\n");

	return 0;
}
