/*	$NetBSD: buf.h,v 1.90 2006/11/14 15:50:00 reinoud Exp $	*/

/*-
 * Copyright (c) 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe of the Numerical Aerospace Simulation Facility,
 * NASA Ames Research Center.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)buf.h	8.9 (Berkeley) 3/30/95
 *
 * 2009: modified by minoru murashima.
 */

#ifndef _SYS_BUF_H_
#define	_SYS_BUF_H_

#include <sys/lock.h>
#include <sys/workqueue.h>

/*
 * These flags are kept in b_flags.
 */
#define	B_AGE		0x00000001	/* Move to age queue when I/O done. */
#define	B_ASYNC		0x00000004	/* Start I/O, do not wait. */
#define	B_BAD		0x00000008	/* Bad block revectoring in progress. */
#define	B_BUSY		0x00000010	/* I/O in progress. */
#define B_SCANNED	0x00000020	/* Block already pushed during sync */
#define	B_CALL		0x00000040	/* Call b_iodone from biodone. */
#define	B_DELWRI	0x00000080	/* Delay I/O until buffer reused. */
#define	B_DIRTY		0x00000100	/* Dirty page to be pushed out async. */
#define	B_DONE		0x00000200	/* I/O completed. */
#define	B_ERROR		0x00000800	/* I/O error occurred. */
#define	B_GATHERED	0x00001000	/* LFS: already in a segment. */
#define	B_INVAL		0x00002000	/* Does not contain valid info. */
#define	B_LOCKED	0x00004000	/* Locked in core (not reusable). */
#define	B_NOCACHE	0x00008000	/* Do not cache block after use. */
#define	B_CACHE		0x00020000	/* Bread found us in the cache. */
#define	B_PHYS		0x00040000	/* I/O to user memory. */
#define	B_RAW		0x00080000	/* Set by physio for raw transfers. */
#define	B_READ		0x00100000	/* Read buffer. */
#define	B_TAPE		0x00200000	/* Magnetic tape I/O. */
#define	B_WANTED	0x00800000	/* Process wants this buffer. */
#define	B_WRITE		0x00000000	/* Write buffer (pseudo flag). */
#define	B_XXX		0x02000000	/* Debugging flag. */
#define	B_VFLUSH	0x04000000	/* Buffer is being synced. */

#define	BIO_GETPRIO(bp)			((bp)->b_prio)
#define	BIO_SETPRIO(bp, prio)	(bp)->b_prio = (prio)
#define	BIO_COPYPRIO(bp1, bp2)	BIO_SETPRIO(bp1, BIO_GETPRIO(bp2))

#define	BPRIO_NPRIO				3
#define	BPRIO_TIMECRITICAL		2
#define	BPRIO_TIMELIMITED		1
#define	BPRIO_TIMENONCRITICAL	0
#define	BPRIO_DEFAULT			BPRIO_TIMELIMITED

#define NOLIST ((struct buf *)0x87654321)

#define	BUF_INIT(bp)									\
do {													\
	LIST_INIT(&(bp)->b_dep);							\
	simple_lock_init(&(bp)->b_interlock);				\
	(bp)->b_dev = NODEV;								\
	BIO_SETPRIO((bp), BPRIO_DEFAULT);					\
} while (/*CONSTCOND*/0)

LIST_HEAD(workhead, worklist);

/*
 * The buffer header describes an I/O operation in the kernel.
 */
struct buf {
	union {
		TAILQ_ENTRY(buf) u_actq;		/* Device driver queue when active. */
		struct work	u_work;
	} b_u;
#define	b_actq		b_u.u_actq
#define	b_work		b_u.u_work
	struct simplelock b_interlock;		/* Lock for b_flags changes */
	volatile int	b_flags;			/* B_* flags. */
	int				b_error;			/* Errno value. */
	int				b_prio;				/* Hint for buffer queue discipline. */
	int				b_bufsize;			/* Allocated buffer size. */
	int				b_bcount;			/* Valid bytes in buffer. */
	int				b_resid;			/* Remaining I/O. */
	dev_t			b_dev;				/* Device associated with buffer. */
	struct {
		caddr_t		b_addr;				/* Memory, superblocks, indirect etc. */
	} b_un;
	daddr_t			b_blkno;			/* Underlying physical block number (partition relative) */
	daddr_t			b_rawblkno;			/* Raw underlying physical block number (not partition relative) */
	void	(*b_iodone)(struct buf *);	/* Function to call upon completion. */
//	struct proc		*b_proc;			/* Associated proc if B_PHYS set. */
//	struct vnode 	*b_vp;				/* File vnode. */
//	struct workhead	b_dep;				/* List of filesystem dependencies. */
	void			*b_saveaddr;		/* Original b_addr for physio. */

	/*
	 * private data for owner.
	 *  - buffer cache buffers are owned by corresponding filesystem.
	 *  - non-buffer cache buffers are owned by subsystem which
	 *    allocated them. (filesystem, disk driver, etc)
	 */
	union {
		void		*bf_private;
		off_t		bf_dcookie;			/* NFS: Offset cookie if dir block */
	} b_fspriv;
#define	b_data	 	b_un.b_addr			/* b_un.b_addr is not changeable. */
#define	b_private	b_fspriv.bf_private
#define	b_dcookie	b_fspriv.bf_dcookie
#define	b_cylinder	b_resid				/* Cylinder number for disksort(). */

	/*
	 * buffer cache specific data
	 */
	LIST_ENTRY(buf) b_hash;				/* Hash chain. */
	LIST_ENTRY(buf) b_vnbufs;			/* Buffer's associated vnode. */
	TAILQ_ENTRY(buf) b_freelist;		/* Free list position if not active. */
	daddr_t			b_lblkno;			/* Logical block number. */
	int				b_freelistindex;	/* Free list index. (BQ_) */
//********************************************************************
	struct uio		*uio;
	void			*task;
//********************************************************************
};

/*
 * These are currently used only by the soft dependency code, hence
 * are stored once in a global variable. If other subsystems wanted
 * to use these hooks, a pointer to a set of bio_ops could be added
 * to each buffer.
 */
struct bio_ops {
 	void	(*io_start)(struct buf *);
 	void	(*io_complete)(struct buf *);
 	void	(*io_deallocate)(struct buf *);
// 	int		(*io_fsync)(struct vnode *, int);
// 	int		(*io_sync)(struct mount *);
	void	(*io_movedeps)(struct buf *, struct buf *);
	int		(*io_countdeps)(struct buf *, int);
	void	(*io_pageiodone)(struct buf *);
};

/*
 * Disassociate a buffer from a vnode.
 */
static inline void brelvp(
	struct buf *bp)
{
//	bp->b_vp = NULL;
}

struct kauth_cred;

extern struct buf *geteblk(int);
extern int	biowait(struct buf *);
//extern int	physio(void (*)(struct buf *), struct buf *, dev_t, int, void (*)(struct buf *), struct uio *);
extern int	physio(void (*)(struct buf *), struct buf *, dev_t, int, void*, struct uio *);
extern void	biodone(struct buf *);

#endif /* !_SYS_BUF_H_ */
