/*	$NetBSD: param.h,v 1.244.2.9.2.2 2008/10/05 08:44:03 bouyer Exp $	*/

/*-
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)param.h	8.3 (Berkeley) 4/4/95
 *
 * 2008: modified by minoru murashima.
 */

#ifndef _SYS_PARAM_H_
#define	_SYS_PARAM_H_

#include <sys/limits.h>
#include <machine/param.h>
#include <machine/int_fmtio.h>

#define	MAXBSIZE		MAXPHYS
#define	NGROUPS_MAX		_POSIX_NGROUPS_MAX	/* max supplemental group id's */
#define	NGROUPS			NGROUPS_MAX			/* max number groups */

/*
 * Priorities.  Note that with 32 run queues, differences less than 4 are
 * insignificant.
 */
#define	PSWP	0
#define	PVM		4
#define	PINOD	8
#define	PRIBIO	16
#define	PVFS	20
#define	PZERO	22		/* No longer magic, shouldn't be here.  XXX */
#define	PSOCK	24
#define	PWAIT	32
#define	PLOCK	36
#define	PPAUSE	40
#define	PUSER	50
#define	MAXPRI	127		/* Priorities range from 0 through MAXPRI. */

#define	PRIMASK 		0x0ff
#define	PCATCH			0x100		/* OR'd with pri for tsleep to check signals */
#define	PNORELOCK		0x200		/* OR'd with pri for cond_wait() to not relock the interlock */
#define PNOEXITERR     	0x400		/* OR'd with pri for tsleep to not exit with an error code when LWPs are exiting */

#define	CBLOCK	64					/* Clist block size, must be a power of 2. */
#define	CBQSIZE	(CBLOCK / NBBY)		/* Quote bytes/cblock - can do better. */
#define	CBSIZE	(CBLOCK - (int)sizeof(struct cblock *) - CBQSIZE)

#define	MAXLOGNAME	(LOGIN_NAME_MAX - 1) /* max login name length */

#define	howmany(x, y)	(((x)+((y)-1))/(y))
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))
#define rounddown(x,y)	(((x)/(y))*(y))

/*
 * Round off or truncate to the nearest page.  These will work
 * for either addresses or counts (i.e., 1 byte rounds to 1 page).
 */
#define	round_page(x)	(((x) + PAGE_MASK) & ~PAGE_MASK)
#define	trunc_page(x)	((x) & ~PAGE_MASK)

#define	setbit(a,i)		((a)[(i) / NBBY] |= 1 << ((i) % NBBY))
#define	clrbit(a,i)		((a)[(i) / NBBY] &= ~(1 << ((i) % NBBY)))
#define	isset(a,i)		((a)[(i) / NBBY] & (1 << ((i) % NBBY)))
#define	isclr(a,i)		(((a)[(i) / NBBY] & (1 << ((i) % NBBY))) == 0)

/* bytes to disk blocks */
#define	dbtob(x)	((x) << DEV_BSHIFT)
#define	btodb(x)	((x) >> DEV_BSHIFT)

#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))

#define	NODEV		(dev_t)(-1)	/* non-existent device */
#define	CLR(t, f)	((t) &= ~(f))
#define SET(t, f)	((t) |= (f))
#define	ISSET(t, f)	((t) & (f))

enum {
	YES		= 1,
	NO		= 0,

	TRUE	= 1,
	FALSE	= 0,
};

/*
 * macro to convert from milliseconds to hz without integer overflow
 * Default version using only 32bits arithmetics.
 * 64bit port can define 64bit version in their <machine/param.h>
 * 0x20000 is safe for hz < 20000
 */
#ifndef mstohz
// ms򤽤Τޤ֤
#define mstohz(ms) 	ms
/*	(__predict_false((ms) >= 0x20000) ? \
	    ((ms +0u) / 1000u) * hz : \
	    ((ms +0u) * hz) / 1000u)
*/
#endif

#endif /* !_SYS_PARAM_H_ */
