/*	$NetBSD: pool.h,v 1.54 2006/08/20 09:35:25 yamt Exp $	*/

/*-
 * Copyright (c) 1997, 1998, 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Paul Kranenburg; by Jason R. Thorpe of the Numerical Aerospace
 * Simulation Facility, NASA Ames Research Center.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * 2009: modified by minoru murashima.
 */

#ifndef _SYS_POOL_H_
#define _SYS_POOL_H_

#include <stdlib.h>

#define	PR_NOWAIT		0x00	/* for symmetry */
#define PR_WAITOK		0x02
#define PR_WANTED		0x04
#define PR_PHINPAGE		0x40
#define PR_LOGGING		0x80
#define PR_LIMITFAIL	0x100	/* even if waiting, fail if we hit limit */
#define PR_RECURSIVE	0x200	/* pool contains pools, for vmstat(8) */
#define PR_NOTOUCH		0x400	/* don't use free items to keep internal state*/
#define PR_NOALIGN		0x800	/* don't assume backend alignment */

struct pool {
	unsigned int	pr_size;		/* Size of item */
};

struct pool_allocator {
	int dummy;
};

#define	POOL_INIT(pp, size, align, align_offset, flags, wchan, palloc)	\
struct pool pp = {														\
	.pr_size = size,													\
}

static inline void pool_init(
	struct pool *pp, 
	size_t size, 
	u_int align, 
	u_int ioff, 
	int flags,
    const char *wchan, 
    struct pool_allocator *palloc)
{
	pp->pr_size = size;
}

static inline void *pool_get(
	struct pool *pp, 
	int dummy)
{
	return malloc(pp->pr_size);
}

static inline void pool_put(
	struct pool *pp, 
	void *mem)
{
	free(mem);
}

#endif /* _SYS_POOL_H_ */
