/*	$NetBSD: systm.h,v 1.228 2008/09/23 22:20:24 pooka Exp $	*/

/*-
 * Copyright (c) 1982, 1988, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)systm.h	8.7 (Berkeley) 3/29/95
 *
 * 2008: modified by minoru murashima.
 */

#ifndef _SYS_SYSTM_H_
#define _SYS_SYSTM_H_

#include <sys/lock.h>
#include <sys/uio.h>
#include <sys/kauth.h>
#include <sys/proc.h>
#include <stdlib.h>
#include <string.h>
#include <machine/stdarg.h>

#define	KM_SLEEP		0x00000001	/* can sleep */
#define	KM_NOSLEEP		0x00000002	/* don't sleep */

#define PWR_RESUME		0
#define PWR_SUSPEND		1
#define PWR_STANDBY		2
#define PWR_SOFTRESUME	3
#define PWR_SOFTSUSPEND	4
#define PWR_SOFTSTANDBY	5

/* These flags are kept in l_flag. [*] is shared with p_flag */
#define	L_INMEM			0x00000004 /* [*] Loaded into memory. */
#define	L_SELECT		0x00000040 /* [*] Selecting; wakeup/waiting danger. */
#define	L_SINTR			0x00000080 /* [*] Sleep is interruptible. */
#define	L_SA			0x00000400 /* [*] Scheduler activations LWP */
#define	L_SA_UPCALL		0x00200000 /* SA upcall is pending */
#define	L_SA_BLOCKING	0x00400000 /* Blocking in tsleep() */
#define	L_DETACHED		0x00800000 /* Won't be waited for. */
#define	L_CANCELLED		0x02000000 /* tsleep should not sleep */
#define	L_SA_PAGEFAULT	0x04000000 /* SA LWP in pagefault handler */
#define	L_TIMEOUT		0x08000000 /* Timing out during sleep. */
#define	L_SA_YIELD		0x10000000 /* LWP on VP is yielding */
#define	L_SA_IDLE		0x20000000 /* VP is idle */
#define	L_COWINPROGRESS	0x40000000 /* UFS: doing copy on write */
#define	L_SA_SWITCHING	0x80000000 /* SA LWP in context switch */

#define	cpu_number()	0

#define	hz	1

enum hashtype {
	HASH_LIST,
	HASH_TAILQ
};

typedef unsigned int km_flag_t;

struct lwp {
	struct kauth_cred *l_cred;	/* Cached credentials */
};

struct malloc_type {
	int dummy;
};

/*
 * Convert pointer to 64 bit unsigned integer for struct
 * kinfo_proc2, etc.
 */
#define PTRTOUINT64(p) ((uint64_t)(uintptr_t)(p))
#define UINT64TOPTR(u) ((void *)(uintptr_t)(u))

extern int lbolt;		/* once a second sleep address */

/*
 * General function declarations.
 */
extern int	nullop(void *);
extern int	enodev(void);
extern int	enosys(void);
extern int	enoioctl(void);
extern int	enxio(void);
extern int	eopnotsupp(void);

/* Compatibility with old, non-interlocked tsleep call */
#define	tsleep(chan, pri, wmesg, timo)					\
	ltsleep(chan, pri, wmesg, timo, NULL)

#define splhigh	getSemaphoreWait
#define spltty	getSemaphoreWait
#define splbio	getSemaphoreWait
#define splx	releaseSemaphoreAwake

extern void	cpu_configure(void);
extern int	ltsleep(volatile const void *, int, const char *, int, volatile struct simplelock *);
extern void	wakeup(volatile const void *);
extern int	uiomove(void *, size_t, struct uio *);
extern int	scanc (u_int, const u_char *, const u_char *, int);
extern int	seltrue(dev_t, int, struct lwp *);
extern char	*bitmask_snprintf(u_quad_t, const char *, char *, size_t);
extern int	humanize_number(char *, size_t, uint64_t, const char *, int);
extern int	format_bytes(char *, size_t, uint64_t);
extern void	*hashinit(u_int, enum hashtype, struct malloc_type *, int, u_long *);
extern void	vprintf(const char *, va_list);
extern void printf(const char *fmt, ...);
extern void panic(const char *fmt, ...) __attribute__((__noreturn__));
extern void aprint_normal(const char *fmt, ...);
extern void aprint_naive(const char *str, ...);
extern void aprint_error(const char *fmt, ...);
extern int getSemaphoreWait();
extern void releaseSemaphoreAwake(int);
extern int getTask(void**);
extern int awakeIntr(void*);
extern int waitIntr();
extern void	consinit(void);

static inline int copyin(const void *from, void *to, size_t len)
{
	memcpy(to, from, len);
	return 0;
}

static inline int copyout(const void *from, void *to, size_t len)
{
	memcpy(to, from, len);
	return 0;
}

static inline int copyinstr(const void *from, void *to, size_t len, size_t *plen)
{
	memcpy(to, from, len);
	return 0;
}

/*
 * Power management hooks.
 */
extern void	*powerhook_establish(const char *, void (*)(int, void *), void *);

#ifdef DEBUG
 #define KASSERT(__cond) if (!(__cond)) {panic("Assertion! : %s line=%d \n",__FILE__, __LINE__);}
#else
 #define KASSERT(__cond)
#endif

#endif	/* !_SYS_SYSTM_H_ */
