/*	$NetBSD: vnode.h,v 1.162 2006/11/21 02:37:20 simonb Exp $	*/

/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)vnode.h	8.17 (Berkeley) 5/20/95
 *
 * 2008: modified by minoru murashima.
 */

#ifndef _SYS_VNODE_H_
#define	_SYS_VNODE_H_

/*
 * Flags for ioflag.
 */
#define	IO_UNIT					0x00010			/* do I/O as atomic unit */
#define	IO_APPEND				0x00020			/* append write to end */
#define	IO_SYNC					(0x04|IO_DSYNC)	/* sync I/O file integrity completion */
#define	IO_NODELOCKED			0x00080			/* underlying node already locked */
#define	IO_NDELAY				0x00100			/* FNDELAY flag set in file table */
#define	IO_DSYNC				0x00200			/* sync I/O data integrity completion */
#define	IO_ALTSEMANTICS			0x00400			/* use alternate i/o semantics */
#define	IO_NORMAL				0x00800			/* operate on regular data */
#define	IO_EXT					0x01000			/* operate on extended attributes */
#define	IO_DIRECT				0x02000			/* direct I/O hint */
#define	IO_ADV_MASK				0x00003			/* access pattern hint */

#define	IO_ADV_SHIFT			0
#define	IO_ADV_ENCODE(adv)		(((adv) << IO_ADV_SHIFT) & IO_ADV_MASK)
#define	IO_ADV_DECODE(ioflag)	(((ioflag) & IO_ADV_MASK) >> IO_ADV_SHIFT)

#define	V_INCR_NUMOUTPUT(vp)
#define	VOP_STRATEGY(pvn, pbf)

struct vnode {
	int dummy;
};

#endif /* !_SYS_VNODE_H_ */
