/*
 * allocDmaMemory.c
 */

#include <sys/config.h>
#include <sys/param.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

extern int allocDmaMemory(const uint size, uint *physAddr, uint *linearAddr);

int main(void)
{
	uint physAddr;
	uint linearAddr;
	int error;

	error = allocDmaMemory(0xf1001, &physAddr, &linearAddr);
	if (error != 0) {
		printf("allocDmaMemory error! : %d\n", error);
		return 0;
	}
	if (linearAddr != DRIVER_DMA_BEG) {
		printf("allocDmaMemory linearAddr error! : %x\n", linearAddr);
		return 0;
	}

	error = allocDmaMemory(0xe000, &physAddr, &linearAddr);
	if (error != 0) {
		printf("allocDmaMemory error! : %d\n", error);
		return 0;
	}
	if (linearAddr != DRIVER_DMA_BEG + 0xf2000) {
		printf("allocDmaMemory linearAddr error! : %x\n", linearAddr);
		return 0;
	}

	error = allocDmaMemory(0x1, &physAddr, &linearAddr);
	if (error == 0) {
		printf("allocDmaMemory error!\n");
		return 0;
	}

	printf("allocDmaMemory OK\n");
	return 0;
}
