/*
 * init.c
 */

#include <sys/param.h>
#include <sys/fcntl.h>
#include <sys/signal.h>
#include <sys/ttycom.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stropts.h>

static void runCommand(
	const char *path,
	char *argv[])
{
	printf("Run %s\n", path);
	pid_t pid = fork();
	if (pid == 0) {
		execv(path, argv);
		printf("failed %s!\n", path);
		exit(0);
	}
	else if (0 < pid) {
		wait(NULL);
	}
	else {
		printf("failed fork!\n");
		exit(0);
	}
}

/*
 * ͥ륳󥽡closeƥ⥸塼륳󥽡open
 * return NOERR or ERR
 */
static int openConsole(
	const char *console)		// 󥽡ǥХѥ
{
	int fd;

	fd = open(console, O_RDONLY, 0);
	if (fd == 0) {
		fcntl(fd, F_SETFD, 0);
	}
	else if (fd < 0) {
		return ERR;
	}
	else {
		if (fcntl(fd, F_DUPFD, 0) != 0) {
			return ERR;
		}
		close(fd);
	}

	fd = open(console, O_WRONLY, 0);
	if (fd == 1) {
		fcntl(fd, F_SETFD, 0);
	}
	else if (fd < 0) {
		return ERR;
	}
	else {
		if (fcntl(fd, F_DUPFD, 1) != 1) {
			return ERR;
		}
		close(fd);
	}

	fd = open(console, O_WRONLY, 0);
	if (fd == 2) {
		fcntl(fd, F_SETFD, 0);
	}
	else if (fd < 0) {
		return ERR;
	}
	else {
		if (fcntl(fd, F_DUPFD, 2) != 2) {
			return ERR;
		}
		close(fd);
	}
	
	return NOERR;
}

int main()
{
	char *argv[2];
	sigset_t sigMask;
	pid_t pid;

	// ͥ륳󥽡򳫤
	if (openConsole("/dev/consolek") == ERR) {
		return 0;
	}

	printf("Run init\n");

	// ɥ饤С⥸塼Υ
	argv[0] = "keybord.mod";
	argv[1] = '\0';
	runCommand("/module/console.mod", argv);

	// ͥ륳󥽡Ĥƥ⥸塼륳󥽡򳫤
	close(0);
	close(1);
	close(2);
	if (openConsole("/dev/console") == ERR) {
		printf("Init failed openConsole!\n");
		return 0;
	}

	sigMask = sigmask(SIGCHLD);
	if (sigprocmask(SIG_BLOCK, &sigMask, NULL) != 0) {
		printf("Init failed sigprocmask\n");
		return 0;
	}

	/* Ķͤü̾ */
	setenv("TERM","pc",1);
	
	// ǽεư
	argv[0] = "setup.sh";
	argv[1] = '\0';
	runCommand("/etc/setup.sh", argv);

	// init command
	argv[0] = "rc";
	argv[1] = '\0';
	runCommand("/etc/rc", argv);

	// exec shell.
	pid = fork();
	if (pid == 0) {
		/* å󳫻ϡ */
		if (setsid() < 0) {
			printf("Init failed setsid\n");
			return 0;
		}

		/* üμ */
		if (ioctl(0, TIOCSCTTY) < 0) {
			printf("Init failed ioctl!\n");
			return 0;
		}

		argv[0] = "-sh";
		argv[1] = '\0';
		execv("/sbin/bash", argv);
		printf("failed /sbin/bash!\n");

		return 0;
	}
	else if (pid < 0) {
		printf("failed fork!\n");
		return 0;
	}

	for (;;) {
		int status;
		wait(&status);
	}
	// ˤϤʤϤ

	return 0;
}
