#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>

static int cmp(
	const char *mem1,
	const char *mem2,
	const int size)
{
	int i;
	for (i = 0; i < size; ++i) {
		if (mem1[i] != mem2[i]) {
			printf("%x %x\n", mem1[i], mem2[i]);
			break;
		}
	}
	
	return i;
}

int main(int argc, char **argv)
{
	enum {BUFSIZE = 0x400};
	extern int errno;
	char file1[16];
	char file2[16];
	int fd1;
	int fd2;
	char *buf1;
	char *buf2;
	int len1;
	int len2;
	int i;

	switch (fork()) {
	case 0:
		sprintf(file1, "test2.dat");
		sprintf(file2, "test21.dat");
		break;
	case -1:
		printf("fork error!\n");
		return 0;
	default:
		switch (fork()) {
		case 0:
			sprintf(file1, "test3.dat");
			sprintf(file2, "test31.dat");
			break;
		case -1:
			printf("fork error!\n");
			return 0;
		default:
			sprintf(file1, "test1.dat");
			sprintf(file2, "test11.dat");
			break;
		}
		break;
	}

	buf1 = malloc(BUFSIZE);
	if (buf1 == NULL) {
		printf("malloc error!\n");
		return 0;
	}

	fd1 = open(file1, O_RDWR);
	fd2 = open(file2, O_RDWR | O_CREAT | O_TRUNC, DEFFILEMODE);
	if ((fd1 == -1) || (fd2 == -1)){
		printf("open error!\n");
		return 0;
	}
	
	printf("%s copy start\n", file2);

	do {
		len1 = read(fd1, buf1, BUFSIZE);
		if (len1 < 0) {
			printf("read error! : %d \n", errno);
			return 0;
		}
		if (write(fd2, buf1, len1) != len1) {
			printf("write error!\n");
			return 0;
		}
	} while (len1 == BUFSIZE);

	printf("%s copy end\n", file2);

	if ((lseek(fd1, 0, SEEK_SET) < 0) || (lseek(fd2, 0, SEEK_SET) < 0)) {
		printf("lseek error!\n");
		return 0;
	}

	buf2 = malloc(BUFSIZE);
	if (buf2 == NULL) {
		printf("malloc error!\n");
		return 0;
	}

	printf("%s compare start\n", file2);
	i = 0;
	do {
		len1 = read(fd1, buf1, BUFSIZE);
		if (len1 < 0) {
			printf("read error! : %d\n", errno);
			break;
		}
		len2 = read(fd2, buf2, len1);
		if (len2 != len1) {
			printf("read error! : %d\n", errno);
			break;
		}
//***************************************************************************		
/*		if (memcmp(buf1, buf2, len1) != 0) {
			printf("memcmp error! %d, %d\n", i * BUFSIZE, len1);
			break;
		}
*/		{
			int len = cmp(buf1, buf2, len1);
			if (len != len1) {
				printf("memcmp error! %d-%d\n", i * BUFSIZE, len);
				break;
			}
		}
//***************************************************************************		
		++i;
	} while (len1 == BUFSIZE);

	printf("%s compare end\n", file2);

	return 0;
}
