#include	"ping.h"


struct proto	proto_v4 = { proc_v4, send_v4, NULL, NULL, 0, IPPROTO_ICMP };
int	datalen = 56;		/* data that goes with ICMP echo request */


int main(int argc, char **argv)
{
	int				c;
	struct addrinfo	*ai;

	opterr = 0;		/* don't want getopt() writing to stderr */
	while ( (c = getopt(argc, argv, "v")) != -1) {
		switch (c) {
		case 'v':
			verbose++;
			break;
		case '?':
			err_quit("unrecognized option: %c", c);
		}
	}
	if (optind != argc-1) {
		err_quit("usage: ping [ -v ] <hostname>");
	}
	host = argv[optind];
	pid = getpid();
	Signal(SIGALRM, sig_alrm);

	ai = Host_serv(host, NULL, 0, 0);

	printf("PING %s (%s): %d data bytes\n", ai->ai_canonname, Sock_ntop_host(ai->ai_addr, ai->ai_addrlen), datalen);

	/* 4initialize according to protocol */
	if (ai->ai_family == AF_INET) {
		pr = &proto_v4;
	}
	else {
		err_quit("unknown address family %d", ai->ai_family);
	}

	pr->sasend = ai->ai_addr;
	pr->sarecv = Calloc(1, ai->ai_addrlen);
	pr->salen = ai->ai_addrlen;

	readloop();

	exit(0);
}
