#include	"ping.h"

void proc_v4(
	char *ptr, 
	ssize_t len, 
	struct timeval *tvrecv)
{
	int				hlen1, icmplen;
	double			rtt;
	struct ip		*ip;
	struct icmp		*icmp;
	struct timeval	*tvsend;

	ip = (struct ip *) ptr;					/* start of IP header */
	hlen1 = ip->ip_hl << 2;					/* length of IP header */

	icmp = (struct icmp *) (ptr + hlen1);	/* start of ICMP header */
	if ( (icmplen = len - hlen1) < 8) {
		err_quit("icmplen (%d) < 8", icmplen);
	}

	if (icmp->icmp_type == ICMP_ECHOREPLY) {
		if (icmp->icmp_id != pid) {
			return;							/* not a response to our ECHO_REQUEST */
		}
		if (icmplen < 16) {
			err_quit("icmplen (%d) < 16", icmplen);
		}

		tvsend = (struct timeval *) icmp->icmp_data;
		tv_sub(tvrecv, tvsend);
		rtt = tvrecv->tv_sec * 1000.0 + tvrecv->tv_usec / 1000.0;
		printf("%d bytes from %s: seq=%u, ttl=%d, rtt=%.3f ms\n",
			icmplen, Sock_ntop_host(pr->sarecv, pr->salen),icmp->icmp_seq, ip->ip_ttl, rtt);

	}
	else if (verbose) {
		printf("%d bytes from %s: type = %d, code = %d\n",
			icmplen, Sock_ntop_host(pr->sarecv, pr->salen),icmp->icmp_type, icmp->icmp_code);
	}
}
