/*
 * pthread_create.c
 *
 *Գסpthread_create()Υƥ
 */

#include <sys/config.h>
#include <sys/param.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <limits.h>
#include <pthread.h>
#include "lib/syscall_lib.h"

static int times;

static void do_thread(
	int *times)
{
//	printf("thread %d\n", *times);
}

void max_create()
{
	pthread_t thread;

	for (;;) {
		++times;
		if (pthread_create(&thread, NULL, (void*) do_thread, &times) != 0) {
			if (times < PTHREAD_THREADS_MAX) {
				printf("pthread_create max error, max count wrong! : %d\n", times);
				exit(1);
			}
			else if (errno != EAGAIN) {
				perror("pthread_create max error, errno wrong!"); 
				exit(1);
			}
			else {
				break;
			}
		}
		else {
			if (PTHREAD_THREADS_MAX < times) {
				printf("pthread_create max error, max count over! : %d\n", times);
				exit(1);
			}
		}
	}
}

static void test_pthread_create()
{
	// Arg error 1.
	argError(pthread_create, 0, (uint) NULL, (uint) do_thread, (uint) &times, 0, 0, "pthread_create 1");
	if (errno != EFAULT) {
		perror("pthread_create 1"); 
		exit(1);
	}

	argError(pthread_create, USER_BEG - 1, (uint) NULL, (uint) do_thread, (uint) &times, 0, 0, "pthread_create 2");
	if (errno != EFAULT) {
		perror("pthread_create 2"); 
		exit(1);
	}

	argError(pthread_create, USER_END - sizeof(uint), (uint) NULL, (uint) do_thread, (uint) &times, 0, 0, "pthread_create 5");
	if (errno != EFAULT) {
		perror("pthread_create 5"); 
		exit(1);
	}

	// Arg error 2.
	argError(pthread_create, USER_BEG, USER_BEG - 1, (uint) do_thread, (uint) &times, 0, 0, "pthread_create 6");
	if (errno != EFAULT) {
		perror("pthread_create 6"); 
		exit(1);
	}

	// Max create.
	max_create();
}

int main(void)
{
	test_pthread_create();

	printf("System call \"pthread_create\" OK\n");

	return 0;
}
