/*
 * pthread_join.c
 *
 *Գסpthread_join()Υƥ
 *
 */

#include <sys/config.h>
#include <sys/param.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <limits.h>
#include <pthread.h>
#include "lib/syscall_lib.h"

static int times;

static void do_thread(
	int *times)
{
//	printf("thread %d\n", *times);
}

void duplex_join()
{
	pthread_t thread;
	void *value;

	if (pthread_create(&thread, NULL, (void*) do_thread, &times) != 0) {
		perror("pthread_join pthread_create error!");
		exit(1);
	}
	if (pthread_create(&thread, NULL, (void*) do_thread, &times) != 0) {
		perror("pthread_join pthread_create error!");
		exit(1);
	}

	// 顼ˤʤʤϤ
	if (pthread_join(thread, &value) != 0) {
		printf("pthread_join duplex error, occurs error!");
		exit(1);
	}

	// pthread_join()ȯԺѤʤΤǥ顼ˤʤϤ
	if (pthread_join(thread, &value) == 0) {
		printf("pthread_join duplex error, no error!");
		exit(1);
	}
	else {
		if (errno != EINVAL) {
			perror("pthread_join duplex"); 
			exit(1);
		}
	}
}

static void test_pthread_join()
{
	pthread_t thread;
	void *value;
	
	// Arg error 1.
	if (pthread_create(&thread, NULL, (void*) do_thread, &times) != 0) {
		printf("pthread_join error, pthread_create error!\n");
		exit(1);
	}

	argError(pthread_join, 0, (uint) &value, 0, 0, 0, 0, "pthread_join 1");
	if (errno != ESRCH) {
		perror("pthread_join 1"); 
		exit(1);
	}

	argNoError(pthread_join, thread, (uint) &value, 0, 0, 0, 0, "pthread_join 2");

	// duplex join error.
	duplex_join();
}

int main(void)
{
	test_pthread_join();

	printf("System call \"pthread_join\" OK\n");

	return 0;
}
