/*
 * read.c
 *
 *Գסread()Υƥ
 */

#include <sys/fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

static void test_read()
{
	const char *file = "read_test";
	const char *str = "123456789";
	const int size = strlen(str) + 1;
	char *buf;
	int fd;
	
	buf = malloc(size);
	if (buf == NULL) {
		printf("Don't malloc %d bytes. file=%s line=%d\n", size, __FILE__, __LINE__);
		exit(1);
	}
	memcpy(buf, str, size);

	fd = open(file, O_CREAT | O_RDWR, S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
	if (fd == -1) {
		printf("Don't open %s. errno=%d file=%s line=%d\n", file, errno, __FILE__, __LINE__);
		exit(1);
	}
	if (write(fd, buf, size) != size) {
		printf("Don't write. errno=%d file=%s line=%d\n", errno, __FILE__, __LINE__);
		exit(1);
	}
	if (lseek(fd, 0, SEEK_SET) == -1) {
		printf("Don't seek. errno=%d file=%s line=%d\n", errno, __FILE__, __LINE__);
		exit(1);
	}
	
	// Test 1
	if (read(fd, buf, size - 2) != size - 2) {
		printf("Read error. errno=%d file=%s line=%d\n", errno, __FILE__, __LINE__);
		exit(1);
	}
	if (read(fd, buf + (size - 2), size) != 2) {
		printf("Don't read. errno=%d file=%s line=%d\n", errno, __FILE__, __LINE__);
		exit(1);
	}
	if (strcmp(buf, str) != 0) {
		printf("Strcmp error. file=%s line=%d\n", __FILE__, __LINE__);
		exit(1);
	}
	if (read(fd, buf, size) != 0) {
		printf("Don't read. errno=%d file=%s line=%d\n", errno, __FILE__, __LINE__);
		exit(1);
	}
	
	if (close(fd) == -1) {
		printf("Don't close %s. errno=%d file=%s line=%d\n", file, errno, __FILE__, __LINE__);
		exit(1);
	}
	if (unlink(file) == -1) {
		printf("Don't unlilnk %s. errno=%d file=%s line=%d\n", file, errno, __FILE__, __LINE__);
		exit(1);
	}
}

int main(void)
{
	test_read();

	printf("System call \"read\" OK\n");

	return 0;
}
