/*
 * vm.c
 *
 * Test system calls for vm.
 */

#include <sys/config.h>
#include <sys/param.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <limits.h>
#include "lib/syscall_lib.h"

extern int setUserIoAccess(const uint, const uint);

static void test_setUserIoAccess()
{
	enum {
		START	= 0,
		SIZE	= 0x2000,
	};
	int volatile *value = (int*) (START + 0x10);
	int volatile *value2 = (int*) (START + SIZE - sizeof(int));
	int get;

	if (setUserIoAccess(0, 0x2000) != 0) {
		printf("setUserIoAccess error! errno=%d file=%s line=%d\n", errno, __FILE__, __LINE__);
		exit(1);
	}

	*value = 0x5f5f5f5f;
	if (*value != 0x5f5f5f5f) {
		printf("setUserIoAccess write error! file=%s line=%d\n", __FILE__, __LINE__);
		exit(1);
	}
	
	get = *value2;
	*value2 = get;
}

int main(void)
{
	test_setUserIoAccess();

	printf("Test system call \"setUserIoAccess\" OK\n");

	return 0;
}
