/*
 * mp.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ޥץåѥ롼
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"proc.h"
#include"interrupt.h"
#include"mm.h"
#include"time.h"
#include"lock.h"
#include"time.h"
#include"sp.h"
#include"mp.h"


enum{
	/* MPơ֥ط */
	FLOAT_HEADER_ADDRES=4,			/* MP configuration table address */
	FLOAT_CONFIG_TYPE=11,			/* MP System Configuration Type(8Х) */
	FLOAT_IMCR_FLAG=12,				/* IMCR presence bit(7ӥå) */

	HEADER_LENGTH=44,				/* Header table length(Х) */
	HEADER_TABLE_LENGTH=4,			/* Base configuration length(16Х) */
	HEADER_ENTRY_COUNT=34,			/* Base configuration table count(16Х) */
	HEADER_LOCAL_APIC_ADDRES=36,	/* Local APIC address */

	TABLE_ENTRY_TYPE=0,				/* Configuration table entry type(8Х) */

	TYPE_PROCESSOR=0,				/* CPUץ */
	TYPE_BUS=1,						/* BUSץ */
	TYPE_IO_APIC=2,					/* IO_APICץ */
	TYPE_IO_INTERRUPT=3,			/* IO_INTERRUPTץ */
	TYPE_LOCAL_INTERRUPT=4,			/* LOCAL_INTERRUPTץ */

	TABLE_PROCESSOR_LENGTH=20,		/* PROCESSOR table length(Х) */
	TABLE_PROCESSOR_FLAG=3,			/* CPU enable flag(0ӥå) */
	TABLE_PROCESSOR_FAMILY=5,		/* CPU Family (8Х)*/

	TABLE_IO_APIC_ID=1,				/* IO_APIC ID */
	TABLE_IO_APIC_FLAG=3,			/* IO_APIC enable flag(0ӥå) */
	TABLE_IO_APIC_ADDRESS=4,		/* IO_APIC address */

	/* LOCAL_APIC١ɥ쥹 */
	LOCAL_APIC_BASE=0xfee00000,

	/* IO APIC register */
	IO_APIC_REGSEL=	0xfec00000,
	IO_APIC_WIN=	0xfec00010,
	IO_APIC_MASK=	0x10000,
	IO_APIC_ID=		0,
	IO_APIC_VER=	1
};


uint ioapic_lrt[16]=									/* IRQȤIOAPIC LRTɥ쥹 */
{
	IO_APIC_LRT2 ,IO_APIC_LRT1 ,0            ,IO_APIC_LRT3 ,IO_APIC_LRT4 ,IO_APIC_LRT5 ,
	IO_APIC_LRT6 ,IO_APIC_LRT7 ,IO_APIC_LRT8 ,IO_APIC_LRT9 ,IO_APIC_LRT10,IO_APIC_LRT11,
	IO_APIC_LRT12,IO_APIC_LRT13,IO_APIC_LRT14,IO_APIC_LRT15
};
uint ioapic_hrt[16]=									/* IRQȤIOAPIC HRTɥ쥹 */
{
	IO_APIC_HRT2 ,IO_APIC_HRT1 ,0            ,IO_APIC_HRT3 ,IO_APIC_HRT4 ,IO_APIC_HRT5 ,
	IO_APIC_HRT6 ,IO_APIC_HRT7 ,IO_APIC_HRT8 ,IO_APIC_HRT9 ,IO_APIC_HRT10,IO_APIC_HRT11,
	IO_APIC_HRT12,IO_APIC_HRT13,IO_APIC_HRT14,IO_APIC_HRT15
};
uchar ioapic_intr_vect[16]=
{
	IRQ0_VECT ,IRQ1_VECT ,0         ,IRQ3_VECT ,IRQ4_VECT ,IRQ5_VECT ,IRQ6_VECT ,IRQ7_VECT ,
	IRQ8_VECT ,IRQ9_VECT ,IRQ10_VECT,IRQ11_VECT,IRQ12_VECT,IRQ13_VECT,IRQ14_VECT,IRQ15_VECT
};
uint MFPS_addres;										/* MFPSɥ쥹setup.S */
int *activ_cpu=(int*)ACTIV_CPU;							/* Numbers of active cpu */
uint volatile *local_apic=(uint*)LOCAL_APIC_BASE;		/* LOCAL APIC base address */
uint volatile *io_apic_regsel=(uint*)IO_APIC_REGSEL;	/* IOAPIC REGSEL address */
uint volatile *io_apic_win=(uint*)IO_APIC_WIN;			/* IOAPIC WIN address */
static uint task_count;									/* 1ư֤APICޡ */

extern void start_tasking();
static void mp_eoi(uchar);
static void release_ioapic_mask(uchar);
static void set_ioapic_mask(uchar);
static void init_localapic(int);
static void init_ioapic(int);
static void boot_acpu();
static uint count_apictimer();
static void wr_apic_msr(uint);
static int apictimer_handler();
static int flash_pagedir_handler(INTERRUPT_FRAME);


/*
 * APIC TIMERΣsΥȿ¬ꤹ
 * return : sΥȿ
 */
uint count_apictimer()
{
	int low,high;
	int apictimer_count;
	double time;


	outb(PIT_CTR,0x30);		/* CLK0,LSB.MSB,⡼0,binary */
	outb(PIT_CNR0,0);		/* LSB */
	outb(PIT_CNR0,0);		/* MSB */

	local_apic[LOCAL_APIC_ICNT]=0xffffffff;								/* APIC TIMERư */
	for(;;)if(0xffffffff-local_apic[LOCAL_APIC_CCNT]>0x200000)break;	/* ٱ */

	apictimer_count=local_apic[LOCAL_APIC_CCNT];

	low=inb(PIT_CNR0);
	high=inb(PIT_CNR0);

	time=(0xffff-low-(high<<8))/(double)PIT_HZ;
	apictimer_count=(0xffffffff-apictimer_count)/time;

	return apictimer_count;  /* 1sΥȲ */
}


/*
 * Issue interrupt to cpu
 * parameters : Cpu number,Interrupt vecter
 */
void issue_interrupt_to_cpu(int cpu,int vecter)
{
	local_apic[LOCAL_APIC_ICR2]=cpu<<24;
	local_apic[LOCAL_APIC_ICR1]=0x00004000|vecter;	/* ǥƥ͡⡼ʪ */
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);		/* ãơγǧ */
}


/*
 * APIC TIMER handler
 * smpƥΥ󥰤Ԥ
 * returns : Task switch on
 */
int apictimer_handler(INTERRUPT_FRAME frame)
{
/*******************************************/
	{
		static char value[MAX_CPU]={0,0,0,0};
		char *p=(char*)(0xb8000+80);
		int cpu;

		cpu=get_current_cpu();
		*(p+cpu*4)=(value[cpu]%10)+'0';
		++value[cpu];
	}
/********************************************/
	local_apic[LOCAL_APIC_ICNT]=task_count;	/* restart APIC TIMER */

	return 1;
}


/*
 * Page directory flash handler
 * returns : Task switch on
 */
int flash_pagedir_handler(INTERRUPT_FRAME frame)
{
	flash_tbl(cputask[get_current_cpu()].current_task->pagedir);
	local_apic[LOCAL_APIC_EOI]=0;		/* issue EOI */

	return 1;
}


/*
 * ϡɳEOIؿ
 */
void mp_eoi(uchar i)
{
	local_apic[LOCAL_APIC_EOI]=0;		/* issue EOI */
}


/*
 * Release interrupt mask
 * prameters : IRQ number
 */
void release_ioapic_mask(uchar irq)
{
	write_ioapic(ioapic_lrt[irq],read_ioapic(ioapic_lrt[irq])&~IO_APIC_MASK);
}


/*
 * Set interrupt mask
 * prameters : IRQ number
 */
void set_ioapic_mask(uchar irq)
{
	write_ioapic(ioapic_lrt[irq],read_ioapic(ioapic_lrt[irq])|IO_APIC_MASK);
}


/********************************************************************************************************
 *
 * Boot Application prosseser
 *
 *********************************************************************************************************/


/*
 * Boot Application prosseser
 */
void boot_acpu()
{
	enum{
		WARMBOOT_IP=0x467,	/* Warm bootɥݥɥ쥹 */
		WARMBOOT_CS=0x469	/* Warm bootCSɥ쥹 */
	};

	extern void mpstart();				/* setup.Sν */
	extern void switch_protect_mode();	/* setup.Sץƥȥ⡼ɰܹԥ */

	ushort *p;
	uint value;


	/*
	 * ץꥱץåεư
	 * ޤ2ĤINIT_IPIäSTARTUP_IPIդ褦ˤ롣STARTUP_IPIäBIOSưɤ˥פ롣
	 * BIOSɤ̤뤳Ȥˤäơץååԡɤư褦ˤʤ褦ơWarmBootꤷ
	 * ɤ˥פ롣
	 */
	/* Warm boot */
	write_cmos(0xf,0xa);
	p=(ushort*)WARMBOOT_IP;
	*p=(ushort)switch_protect_mode&0xf;
	p=(ushort*)WARMBOOT_CS;
	*p=(ushort)switch_protect_mode>>4;

	/* ޤINIT_IPI Assert mode */
	local_apic[LOCAL_APIC_ICR2]=0xf000000;
	value=local_apic[LOCAL_APIC_ICR1];
	value=(value&0xfff32000)|0xcc500;
	local_apic[LOCAL_APIC_ICR1]=value;
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);

	/* INIT_IPI Deassert mode */
	value=local_apic[LOCAL_APIC_ICR1];
	value=(value&0xfff32000)|0xc8500;
	local_apic[LOCAL_APIC_ICR1]=value;
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);

	/* 10msԤ */
	mili_timer(10);

	/*
	 * ǸSTARTUP_IPI
	 * 2뤳ȤˤʤäƤ뤬1ǵư褦
	 */
	value=local_apic[LOCAL_APIC_ICR1];
	value=(value&0xfff32000)|((uint)mpstart>>12)|0xc0600;
	local_apic[LOCAL_APIC_ICR1]=value;
	while(local_apic[LOCAL_APIC_ICR1]&0x1000);
}


/********************************************************************************************************
 *
 * 
 *
 *********************************************************************************************************/


/*
 * SMPƥν
 * return : 0 or Error=-1
 */
int init_mp()
{
	char *mp_floating,*mp_header,*mp_table;
	char *p;
	int cpu_num;
	uint64 timeout;


	mp_floating=(char*)MFPS_addres;
	mp_header=(char*)*(char**)(mp_floating+FLOAT_HEADER_ADDRES);
	mp_table=mp_header+HEADER_LENGTH;

	/* cpu򥫥Ȥ */
	for(p=mp_table,cpu_num=0;*p==TYPE_PROCESSOR;p+=TABLE_PROCESSOR_LENGTH)
	{
		if(*(p+TABLE_PROCESSOR_FLAG)&1)++cpu_num;
		if(cpu_num>MAX_CPU)return -1;
	}

	++*activ_cpu;	/* ƯcpuΥ */

	/* Init local apic */
	init_localapic(0);

	/* ϡɳߤEOIؿꤹ롣(ץꥱcpuư) */
	irq_eoi=mp_eoi;

	/* ץꥱcpuư */
	boot_acpu();

	/* pagingǻȤpage directoryߤ */
	set_idt(FLASH_PAGEDIR_VECT,flash_pagedir,IDT_TRAP);
	irq_entry[FLASH_PAGEDIR]=flash_pagedir_handler;

	/* Init IO apic٤Ƥcpuεưȯ */
	timeout=rdtsc()+clock_1m*1000;
	while(*activ_cpu!=cpu_num)
		if(rdtsc()>timeout)
		{
			printk("Booting application cpu isn't complete!\n");
			break;
		}
	init_ioapic(cpu_num);

	/* ϡɳߥޥؿ,ޥؿꤹ */
	release_irq_mask=release_ioapic_mask;
	set_irq_mask=set_ioapic_mask;

	return 0;
}


/*
 * Application cpuꤹ
 */
void init_application_cpu()
{
	static int spingate=0;

	uint *pagedir;
	int cpu;


	/* fpuν */
	asm("fninit");

	asm volatile(				/* spin lock */
			"movl	$1,%%edx\n"
		"1:	xchgl	%%edx,(%%eax)\n"
			"orl	%%edx,%%edx\n"
			"jnz	1b"
		::"a"(&spingate)
	);
	{
		cpu=*activ_cpu;

		/* TSSǥץɤ */
		set_tss(TSS_DES+cpu*8);

		/* Init parameters relatibe to task */
		init_cputask(cpu);

		/* cpu clockη¬ */
		printk("cpu%d clock = %d HZ\n",cpu,count_cpu_clock());

		++*activ_cpu;
	}
	spingate=0;

	/* LOCAL_APICν */
	init_localapic(cpu);

	/* ڡ󥰤 */
	if((pagedir=init_idle_page())==NULL)
	{
		printk("Fail init_idle_page!\n");
		idle();
	}

	if(set_idle_proc(cpu,pagedir)==-1)
	{
		printk("Fail set_idle_proc! cpu=%d.\n",cpu);
		idle();
	}

	/* 󥰳 */
	start_tasking();
}


/*
 * Init LOCAL APIC
 * Require atomic handlig
 * parameters : Cpu number
 */
void init_localapic(int cpu)
{
	uint value;


	/* LOCAL_APIC١ɥ쥹 */
	wr_apic_msr(LOCAL_APIC_BASE);		/* LOCAL_APICϡɥ֥͡ */

	/* LOCAL_APICեȥ֥͡ */
	local_apic[LOCAL_APIC_SVR]=0x12f;

	/* LOCAL_APIC_IDꤹ */
	local_apic[LOCAL_APIC_ID]=cpu<<24;

	/* ⡼ɤեåȥǥ(8cpu)ꤹ */
	local_apic[LOCAL_APIC_LDR]=0x1000000<<cpu;
	local_apic[LOCAL_APIC_DFR]=0xffffffff;

	/* ץ饤ƥ */
	local_apic[LOCAL_APIC_TPR]=0;

	/* ޡߤ */
	local_apic[LOCAL_APIC_TDVC]=0xb;					/* ʬ1 */
	local_apic[LOCAL_APIC_TIME]=APIC_TIMER_VECT;		/* 󥷥åȥ⡼|ޥ */
	if(cpu==0)
	{
		set_idt(APIC_TIMER_VECT,apictimer,IDT_TRAP);	/* idt */
		value=count_apictimer();						/* APICޡHZ¬ */
		printk("APIC TIMER = %d HZ\n",value);
		task_count=value/(1000/TASK_TIME);				/* ư */
		irq_entry[APIC_TIMER]=apictimer_handler;		/* APICޡInterrupt tableꤹ */
	}
	local_apic[LOCAL_APIC_ICNT]=task_count;				/* ޡư */
}


/*
 * APIC_BASE_MSR˽񤭹
 *  : 񤭹
 */
void wr_apic_msr(uint base)
{
	enum{APICBASE=27};


	asm volatile(
		"xorl	%%edx,%%edx\n"
		"wrmsr"
		::"a"(base|0x800),"c"(APICBASE)
	);
}


/*
 * Init IO APIC
 * param : cpu number
 */
void init_ioapic(int cpu)
{
	enum{
		IMCR_SEL=0x22,		/* IMCR쥯ȥݡȥɥ쥹 */
		IMCR_WRI=0x23		/* IMCR񤭹ߥݡȥɥ쥹 */
	};

	char *mp_floating;


	/* ߤSymmetric⡼ɤڤؤ */
	outb(OCW1S,0xff);				/* pic졼ֳߤޥ */
	outb(OCW1M,0xff);				/* picޥߤޥ */
	mp_floating=(char*)MFPS_addres;
	if(mp_floating[FLOAT_IMCR_FLAG]&(1<<7))
	{
		/*PIC⡼ɤ̵ˤ */
		outb(IMCR_SEL,0x70);		/* IMCR쥯 */
		outb(IMCR_WRI,1);			/* PIC⡼̵ */
	}
	else
	{
		/* Virtual Wire⡼ɤ̵ˤ */
		local_apic[LOCAL_APIC_LNT0]=0x10000;		/* LINT0ޥ */
		local_apic[LOCAL_APIC_LNT1]=0x10000;		/* LINT1ޥ */
	}

	/* IO_APIC_ID */
	write_ioapic(IO_APIC_ID,cpu<<24);

	/* idt */
	set_idt(IRQ0_VECT,irq0,IDT_TRAP);
	set_idt(IRQ1_VECT,irq1,IDT_TRAP);
	set_idt(IRQ3_VECT,irq3,IDT_TRAP);
	set_idt(IRQ4_VECT,irq4,IDT_TRAP);
	set_idt(IRQ5_VECT,irq5,IDT_TRAP);
	set_idt(IRQ6_VECT,irq6,IDT_TRAP);
	set_idt(IRQ7_VECT,irq7,IDT_TRAP);
	set_idt(IRQ8_VECT,irq8,IDT_TRAP);
	set_idt(IRQ9_VECT,irq9,IDT_TRAP);
	set_idt(IRQ10_VECT,irq10,IDT_TRAP);
	set_idt(IRQ11_VECT,irq11,IDT_TRAP);
	set_idt(IRQ12_VECT,irq12,IDT_TRAP);
	set_idt(IRQ13_VECT,irq13,IDT_TRAP);
	set_idt(IRQ14_VECT,irq14,IDT_TRAP);
	set_idt(IRQ15_VECT,irq15,IDT_TRAP);

	/* IOơ֥,All maske */
	write_ioapic(IO_APIC_LRT0,0x10900|IRQ0_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT0,0xff000000);
	write_ioapic(IO_APIC_LRT1,0x10900|IRQ1_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT1,0xff000000);
	write_ioapic(IO_APIC_LRT2,0x10900|IRQ0_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT2,0xff000000);
	write_ioapic(IO_APIC_LRT3,0x10900|IRQ3_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT3,0xff000000);
	write_ioapic(IO_APIC_LRT4,0x10900|IRQ4_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT4,0xff000000);
	write_ioapic(IO_APIC_LRT5,0x10900|IRQ5_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT5,0xff000000);
	write_ioapic(IO_APIC_LRT6,0x10000|IRQ6_VECT);	/* Physical Mode */
	write_ioapic(IO_APIC_HRT6,0x00000000);
	write_ioapic(IO_APIC_LRT7,0x10900|IRQ7_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT7,0xff000000);
	write_ioapic(IO_APIC_LRT8,0x10900|IRQ8_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT8,0xff000000);
	write_ioapic(IO_APIC_LRT9,0x10900|IRQ9_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT9,0xff000000);
	write_ioapic(IO_APIC_LRT10,0x10900|IRQ10_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT10,0xff000000);
	write_ioapic(IO_APIC_LRT11,0x10900|IRQ11_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT11,0xff000000);
	write_ioapic(IO_APIC_LRT12,0x10900|IRQ12_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT12,0xff000000);
	write_ioapic(IO_APIC_LRT13,0x10900|IRQ13_VECT);	/* Logcal mode,Lowest priority */
	write_ioapic(IO_APIC_HRT13,0xff000000);
	write_ioapic(IO_APIC_LRT14,0x10000|IRQ14_VECT);	/* Physical Mode */
	write_ioapic(IO_APIC_HRT14,0x00000000);
	write_ioapic(IO_APIC_LRT15,0x10000|IRQ15_VECT);	/* Physical Mode */
	write_ioapic(IO_APIC_HRT15,0x00000000);
}
