/*
 * fat_fs.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * FAT12FAT16(msdos)ե륷ƥ
 * VFAT(󥰥ե͡ࡢASCIIʸΤ)б
 * աFAT12512ХȥȤ롣
 */


#include"types.h"
#include"mm.h"
#include"lib.h"
#include"fs.h"
#include"device.h"


enum{
	BOOT_SECT=0,				/* boot sector */
	FAT_SECT=1,					/* FAT(cluster) sector */
	FAT12_CACHE_SIZE=0x600,		/* FAT12 cache size in bytes,3ǳڤ */
	FAT16_CACHE_SIZE=0x1000,	/* FAT16 cache size in bytes */

	MAX_NAME_SIZE=8,			/* max name size */
	MAX_EXT_SIZE=3,				/* max extension size */

	TYPE_FAT12=0x2020203231544146,	/* FAT12 */
	TYPE_FAT16=0x2020203631544146,	/* FAT16 */

	/* cluster value */
	CLST_ROOT_DIR=0,		/* 롼ȥǥ쥯ȥΥ饹ֹ */
	CLST_BEGIN=0x2,			/* begin cluster */
	CLST_LAST_FAT12=0xfef,	/* last cluster */
	CLST_EOF_FAT12=0xff8,	/* end of file cluster,0xff8 ʾ */
	CLST_LAST_FAT16=0xffef,	/* last cluster */
	CLST_EOF_FAT16=0xfff8,	/* end of file cluster,0xff8 ʾ */

	/* attribute flag */
	ATTR_RO=0x1,  			/* read-only */
	ATTR_HID=0x2,			/* hidden */
	ATTR_SYS=0x4,			/* system */
	ATTR_VOL=0x8,			/* volume label */
	ATTR_DIR=0x10,			/* directory */
	ATTR_ARC=0x20,			/* archived */
	ATTR_VFAT=0xf,			/* VFAT long name entry */

	SIG_DEL=0xe5,			/* ѥ󡢥ǥ쥯ȥꥨȥ꡼κǽΥХȤɽ */
};


/* boot sector + clusters,sectorPerDir,beginCluster */
typedef struct{
	char coad[3];								/* Boot coad */
	char oemName[8];							/* OEM name and version */
	ushort sectorSize __attribute__((packed));	/* number of bytes per sector */
	uchar clusterPerSect;						/* number of sectors per cluster,Must be one of 1, 2, 4, 8, 16, 32, 64, 128 */
	ushort reserveSector;						/* reserved sectors,FAT12 and FAT16 1. FAT32 32 */
	uchar fatNum;								/* number of FAT copies */
	ushort rootDirs __attribute__((packed));	/* root directory entries,FAT12:224 FAT16:512 FAT32:0 */
	ushort allSectors __attribute__((packed));	/* all number of sectors */
	uchar media;								/* Media type,f0:1.4 MB floppy f8:hard disk */
	ushort fatSectors;							/* number of sectors per FAT */
	ushort trackSectors;						/* number of sectors per track */
	ushort heads;								/* number of heads */
	uint hiddenSectors;							/* number of hidden sectors (unused) */
	uint totalSectors;							/* number of sectors (if allSectors=0) */
	char unuse[18];								/* unuse */
	int64 fatType __attribute__((packed));		/* Fat type,FAT12 or FAT16 or FAT or all zero */
	ushort clusters;							/* number of usable clusters */
	ushort clusterPerDirent;					/* cluster size per directory entory size */
	int beginCluster;							/* 饹κǽΥ */
}SUPER_BLOCK;

/* directory entry */
typedef struct{
	char name[MAX_NAME_SIZE];	/* name */
	char ext[MAX_EXT_SIZE];		/* extension */
	uchar attr;					/* attribute bits,Bit0: read only Bit1:hidden Bit2:system file Bit3:volume label,
								   Bit4:subdirectory,Bit5:archive Bits6-7:unused. */
	char reserve[10];			/* reserved */
	ushort time;				/* time,5/6/5 bits for hour/minutes/doubleseconds. */
	ushort date;				/* date,7/4/5 bits for year-since-1980/month/day. */
	ushort cluster;				/* starting cluster,0 for an empty file */
	uint size;					/* file size in bytes */
}DIR_ENT;

/* directory entry point */
typedef struct{
	int sector;			/* sector number */
	int index;			/* index in cluster */
	DIR_ENT *entry;		/* derectory entry buffer */
}DIR_ENT_POINT;


static SUPER_BLOCK *superBlock[MAX_DEVICE_OPEN];


/************************************************************************************
 *
 * < FAT class >
 *
 * FAT handling functions
 *
 * PUBLIC : clusterToSector()
 *          getNextCluster()
 *          writeCluster()
 *          getEmptyCluster()
 *          checkEmptySize()
 *          initFatCache()
 *          releaseFatCache()
 *
 ************************************************************************************/

/* FAT cache */
typedef struct{
	int beginCluster;		/* åκǽΥ饹 */
	ushort emptyClusters;	/* number of empty clusters */
	void *cache;			/* FAT cache */
}FAT_CACHE;


/* PRIVATE */
static FAT_CACHE *fatCache[MAX_DEVICE_OPEN];


/*
 * PRIVATE
 * FAT12γ饹ͤ롣
 * FAT12Υ饹¤ : ab cd ef  abd efc
 * parameters : baffer,ХåեХ饹
 * return : value of cluster
 */
extern inline int getFat12NextCluster(uchar *buf,int cluster)
{
	int offset=(cluster>>1)*3+(cluster&1);
	int next=0;


	next=buf[offset];
	next+=buf[offset+1]<<8;
	next>>=(cluster&1)*4;

	return next&0xfff;
}


/*
 * PRIVATE
 * FAT12γ饹ͤ롣
 * parameters : baffer,ХåեХ饹
 * return : value of cluster
 */
extern inline void putFat12Cluster(uchar *buf,int cluster,int value)
{
	int offset=(cluster>>1)*3+(cluster&1);


	value&=0xfff;
	value<<=(cluster&1)*4;
	buf[offset]&=~(0xff<<(cluster&1)*4);
	buf[offset]|=value;
	buf[offset+1]&=~(0xff>>(~cluster&1)*4);
	buf[offset+1]|=value>>8;
}


/*
 * PUBLIC
 * 饹ͤ򥻥Ѵ롣
 * parameters : super block address,cluster
 * return : sector
 */
extern inline uint clusterToSector(SUPER_BLOCK *sb,int cluster)
{
	return cluster*sb->clusterPerSect+sb->beginCluster;
}


/*
 * PUBLIC
 * Υ饹֤
 * parameters : device inode,cluster number,link count
 * return : next cluster or end=0 or error=-1
 */
static int getNextCluster(int din,int cluster,int count)
{
	void *cache=(uchar*)fatCache[din]->cache;
	int begin_cache=fatCache[din]->beginCluster;
	int i;


	if(superBlock[din]->fatType==TYPE_FAT12)
	{
		/* FAT12 */
		for(i=0;i<count;++i)
		{
			if((cluster&~(FAT12_CACHE_SIZE/3*2-1))!=begin_cache)
			{
				fatCache[din]->beginCluster=begin_cache=cluster&~(FAT12_CACHE_SIZE/3*2-1);
				if(read_cache(din,cache,FAT12_CACHE_SIZE/512,begin_cache*3/2/512+FAT_SECT)!=FAT12_CACHE_SIZE/512)return -1;
			}
			cluster=getFat12NextCluster((uchar*)cache,cluster-begin_cache);
		}

		if(cluster>=CLST_EOF_FAT12)cluster=0;
	}
	else
	{
		/* FAT16 */
		for(i=0;i<count;++i)
		{
			if((cluster&~(FAT16_CACHE_SIZE/2-1))!=begin_cache)
			{
				fatCache[din]->beginCluster=begin_cache=cluster&~(FAT16_CACHE_SIZE/2-1);
				if(read_cache(din,cache,FAT16_CACHE_SIZE/superBlock[din]->sectorSize,begin_cache*2/superBlock[din]->sectorSize+FAT_SECT)
						!=FAT16_CACHE_SIZE/superBlock[din]->sectorSize)return -1;
			}
			cluster=((ushort*)cache)[cluster-begin_cache];
		}

		if(cluster>=CLST_EOF_FAT16)cluster=0;
	}

	return cluster;
}


/*
 * PUBLIC
 * 饹ΰ֤ͤ񤭹ࡣ
 * 饹0ʤǥ쥯ȥΥȥ饹˽񤭹ࡣ
 * parameters : device inode,cluster number,value
 */
static void writeCluster(int din,DIR_ENT *dir,int cluster,int value)
{
	if(cluster==0)dir->cluster=value;
	else
	{
		if(superBlock[din]->fatType==TYPE_FAT12)
		{
			if((cluster&~(FAT12_CACHE_SIZE/3*2-1))!=fatCache[din]->beginCluster)
			{
				fatCache[din]->beginCluster=cluster&~(FAT12_CACHE_SIZE/3*2-1);
				if(read_cache(din,fatCache[din]->cache,FAT12_CACHE_SIZE/512,fatCache[din]->beginCluster*3/2/512+FAT_SECT)!=
					FAT12_CACHE_SIZE/512)return;
			}
			putFat12Cluster((uchar*)fatCache[din]->cache,cluster-fatCache[din]->beginCluster,value);
		}
		else
		{
			if((cluster&~(FAT16_CACHE_SIZE/2-1))!=fatCache[din]->beginCluster)
			{
				fatCache[din]->beginCluster=cluster&~(FAT16_CACHE_SIZE/2-1);
				if(read_cache(din,fatCache[din]->cache,FAT16_CACHE_SIZE/superBlock[din]->sectorSize,
					fatCache[din]->beginCluster*2/superBlock[din]->sectorSize+FAT_SECT)!=
					FAT16_CACHE_SIZE/superBlock[din]->sectorSize)return;
			}
			((ushort*)fatCache[din]->cache)[cluster-fatCache[din]->beginCluster]=value;
		}
	}
}


/*
 * PUBLIC
 * 饹롣
 * paramters : device inode
 * return : empty cluster or ʤ=0 or error=-1
 */
static int getEmptyCluster(int din)
{
	void *cache=fatCache[din]->cache;
	int sectors,clusters;
	int i,k,beg_sect,beg_clust,last;


	if(fatCache[din]->emptyClusters==0)return 0;

	if(superBlock[din]->fatType==TYPE_FAT12)
	{
		sectors=FAT12_CACHE_SIZE/512;			/* å奵Υ */
		clusters=FAT12_CACHE_SIZE/3*2;			/* å奵Υ饹 */
		beg_clust=fatCache[din]->beginCluster;

		for(i=beg_sect=beg_clust/(FAT12_CACHE_SIZE/3*2)*sectors;;)
		{
			/* FATåζ饹õ */
			if((i+=sectors)<superBlock[din]->fatSectors)
			{
				for(k=0;k<clusters;++k)
					if(getFat12NextCluster((uchar*)cache,k)==0)return k+beg_clust;
				beg_clust+=clusters;
			}
			else
			{
				last=superBlock[din]->clusters%sectors;
				for(k=0;k<last;++k)
					if(getFat12NextCluster((uchar*)cache,k)==0)return k+beg_clust;
				i=0;
				beg_clust=0;
			}

			if(i==beg_sect)return -1;

			/* 򥭥å夹롣 */
			fatCache[din]->beginCluster=beg_clust;
			if(read_cache(din,cache,sectors,i+FAT_SECT)!=sectors)return -1;
		}
	}
	else
	{
		sectors=FAT16_CACHE_SIZE/superBlock[din]->sectorSize;	/* å奵Υ */
		clusters=FAT16_CACHE_SIZE/2;							/* å奵Υ饹 */
		beg_clust=fatCache[din]->beginCluster;

		for(i=beg_sect=beg_clust/(FAT16_CACHE_SIZE/2)*sectors;;)
		{
			/* FATåζ饹õ */
			if((i+=sectors)<superBlock[din]->fatSectors)
			{
				for(k=0;k<clusters;++k)
					if(((ushort*)cache)[k]==0)return k+beg_sect;
				beg_clust+=clusters;
			}
			else
			{
				last=superBlock[din]->clusters%sectors;
				for(k=0;k<last;++k)
					if(((ushort*)cache)[k]==0)return k+beg_sect;
				i=0;
				beg_clust=0;
			}


			if(i==beg_sect)return -1;

			/* 򥭥å夹롣 */
			fatCache[din]->beginCluster=beg_clust;
			if(read_cache(din,cache,sectors,i+FAT_SECT)!=sectors)return -1;
		}
	}
}


/*
 * PUBLIC
 * 饹γǧ
 * parameters : device inode,size
 * return : yes=0 or no=-1
 */
extern inline int checkEmptySize(int din,int size)
{
	if(size>fatCache[din]->emptyClusters*superBlock[din]->sectorSize*superBlock[din]->fatSectors)
		return -1;

	return 0;
}


/*
 * PUBLIC
 * init FAT cache
 * parameters : device inode
 * return : 0 or error=-1
 */
static int initFatCache(int din)
{
	void *buf;
	int empties=0;		/* 饹 */
	int sectors,clusters;
	int i,k;


	/* FATΰ򥹥󤷤ơ饹롣 */
	if(superBlock[din]->fatType==TYPE_FAT12)
	{
		if((buf=kmalloc(FAT12_CACHE_SIZE))==NULL)return -1;
		sectors=FAT12_CACHE_SIZE/512;					/* cache per sector. */
		clusters=FAT12_CACHE_SIZE/3*2;					/* number of clusters in cache. */

		k=superBlock[din]->clusters%clusters-1+2;		/* ǸΥåΥ饹饹2ϤޤΤ2򤿤 */
		if(k==-1)k=clusters-1;
		for(i=ROUNDDOWN(superBlock[din]->fatSectors-1,sectors);i>=0;i-=sectors)
		{
			if(read_cache(din,buf,sectors,i+FAT_SECT)!=sectors)goto ERR;
			for(;k>=0;--k)
				if(getFat12NextCluster((uchar*)buf,k)==0)++empties;
			k=clusters-1;
		}
	}
	else
	{
		if((buf=kmalloc(FAT16_CACHE_SIZE))==NULL)return -1;
		sectors=FAT16_CACHE_SIZE/superBlock[din]->sectorSize;	/* cache per sector. */
		clusters=FAT16_CACHE_SIZE/2;							/* number of clusters in cache. */

		k=superBlock[din]->clusters%clusters-1+2;				/* ǸΥåΥ饹饹2ϤޤΤ2򤿤 */
		if(k==-1)k=clusters-1;
		for(i=ROUNDDOWN(superBlock[din]->fatSectors-1,sectors);i>=0;i-=sectors)
		{
			if(read_cache(din,buf,sectors,i+FAT_SECT)!=sectors)goto ERR;
			for(;k>=0;--k)
				if(((ushort*)buf)[k]==0)++empties;
			k=clusters-1;
		}
	}

	/* FATå롣 */
	if((fatCache[din]=(FAT_CACHE*)kmalloc(sizeof(FAT_CACHE)))==NULL)goto ERR;
	fatCache[din]->beginCluster=0;
	fatCache[din]->emptyClusters=empties;
	fatCache[din]->cache=buf;

	return 0;

ERR:
	kfree(buf);

	return -1;
}


/*
 * PUBLIC
 * release FAT cache
 * parameters : device inode
 */
static void releaseFatCache(int din)
{
	kfree(fatCache[din]->cache);
	kfree(fatCache[din]);
	fatCache[din]=NULL;
}


/************************************************************************************
 *
 * < Directory class >
 *
 * directory functions
 *
 * PUBLIC : searchPath()
 *
 ************************************************************************************/

enum{
	LONG_NAME_END=0x40,		/* long name end entry id. */
	LONG_NAME_1_5=5,		/* long name 1-5 size. */
	LONG_NAME_6_11=6,		/* long name 6-11 size. */
	LONG_NAME_12_13=2		/* long name 12-13 size. */
};


/* VFAT long name directory entry */
typedef struct{
	uchar id;											/* Bits 0-4: sequence number; bit 6: final entry of name. */
	short name1[LONG_NAME_1_5] __attribute__((packed));	/* Unicode characters 1-5 */
	uchar attr;											/* attribute bits */
	char reserved;										/* always 0 */
	uchar checksum;										/* Checksum of short name */
	short name2[LONG_NAME_6_11];						/* Unicode characters 6-11 */
	ushort cluster;										/* starting cluster number, always 0 */
	short name3[LONG_NAME_12_13];						/* Unicode characters 12-13 */
}DIR_ENT_LONG;


/*
 * PRIVATE
 * ASCIIʸUNICODEʸѴƥХåե˳Ǽ롣
 * Хåե512Хȡ
 * paraeters : destination buffer,sorce string
 * return : unicode string length or error=-1;
 */
extern inline int asciiToUnicode(char *buf,const char *str)
{
	enum{MAX_LEN=512};

	int i;


	i=0;
	while((*str!='\0')&&(*str!='/'))
	{
		if(i>MAX_LEN)return -1;
		buf[i++]=*str++;
		buf[i++]='\0';
	}
	buf[i++]='\0';
	buf[i]='\0';

	return i-1;
}


/*
 * PRIVATE
 * cmpare path strings
 * parameters : destination string(end=' ' or 8bytes),sorce path(end='/' or '\0')
 * return : =Υѥݥ or NULL;
 */
static const char *cmpPath(const char *path1,const char *path2)
{
	const char *p1,*p2;
	int i;


	/* compare name. */
	for(i=0;i<MAX_NAME_SIZE;++i)
		if(path1[i]!=path2[i])
		{
			if(path1[i]!=' ')return NULL;
			break;
		}
	if((path2[i]=='/')&&(path1[MAX_NAME_SIZE]==' '))return &path2[i+1];
	if((path2[i]=='\0')&&(path1[MAX_NAME_SIZE]==' '))return &path2[i];

	/* compare extension. */
	if(path2[i]=='.')
	{
		p1=&path1[MAX_NAME_SIZE];
		p2=&path2[i+1];
		for(i=0;i<MAX_EXT_SIZE;++i)
			if(p1[i]!=p2[i])
			{
				if(p1[i]!=' ')return NULL;
				break;
			}
		if(p2[i]=='/')return &p2[i+1];
		if(p2[i]=='\0')return &p2[i];
	}

	return NULL;
}


/*
 * PRIVATE
 * cpmpare long path.
 * parameters : special directory entry,sorce string
 * return : פΥѥ or ԰=NULL
 */
static const short *cmpLongPath(DIR_ENT_LONG *dir_long,short *str)
{
	int i;


	if(dir_long->id&LONG_NAME_END)
	{
		/* compare in end of long name entry. */
		for(i=0;i<LONG_NAME_1_5;++i)
		{
			if(dir_long->name1[i]!=str[i])return NULL;
			if(str[i]==0)return &str[i+1];
		}
		str=&str[i];
		for(i=0;i<LONG_NAME_6_11;++i)
		{
			if(dir_long->name2[i]!=str[i])return NULL;
			if(str[i]==0)return &str[i+1];
		}
		str=&str[i];
		for(i=0;i<LONG_NAME_12_13;++i)
		{
			if(dir_long->name3[i]!=str[i])return NULL;
			if(str[i]==0)return &str[i+1];
		}

		return &str[i];
	}
	else
	{
		for(i=0;i<LONG_NAME_1_5;++i)
			if(dir_long->name1[i]!=str[i])return NULL;
		str=&str[i];
		for(i=0;i<LONG_NAME_6_11;++i)
			if(dir_long->name2[i]!=str[i])return NULL;
		str=&str[i];
		for(i=0;i<LONG_NAME_12_13;++i)
			if(dir_long->name3[i]!=str[i])return NULL;

		return &str[i];
	}
}


#define NEXT_SECTOR()	if(cluster==CLST_ROOT_DIR)\
						{\
							if((sect+=superBlock[din]->clusterPerSect)>=sect_last)return -1;\
						}\
						else\
						{\
							sect=clusterToSector(superBlock[din],cluster);\
							if((cluster=getNextCluster(din,cluster,1))==-1)return -1;\
						}\

/*
 * PRIVATE
 * ǥ쥯ȥ򸡺
 * Υѥ˼Υѥ롣
 * Υǥ쥯ȥݥȤ˥ǥ쥯ȥꥻȥ饹⥤ǥå롣
 * parameters : path pointer,device inode,cluster,directory buffer(1 cluster),directory entry point,string buffer
 * return : 0 or error=-1
 */
static int searchDir(const char **path,int din,int cluster,DIR_ENT *dir_buf,DIR_ENT_POINT *dir_point,char *str_buf)
{
	enum{NAME_SIZE_PER_ENT=26};		/* name bytes per long name entry. */

	const char *p;
	uint sect;
	int clust_per_sect=superBlock[din]->clusterPerSect;
	int str_len,str_per_ent;
	int i,k,last,sect_last;


	/* ʸUNICODEѴ */
	if((str_len=asciiToUnicode(str_buf,*path))==-1)return -1;
	str_per_ent=(str_len+NAME_SIZE_PER_ENT-1)/NAME_SIZE_PER_ENT;	/* ʸ˻Ȥȥ꡼ */

	if(cluster==CLST_ROOT_DIR)
	{
		sect=FAT_SECT+superBlock[din]->fatSectors*superBlock[din]->fatNum;
		sect_last=sect+superBlock[din]->rootDirs/superBlock[din]->clusterPerDirent;
	}
	else sect=clusterToSector(superBlock[din],cluster);
	last=superBlock[din]->clusterPerDirent;
	for(i=0;;i=0)
	{
		if(read_cache(din,dir_buf,clust_per_sect,sect)!=clust_per_sect)return -1;

		while(i<last)
		{
			if(dir_buf[i].name[0]=='\0')return -1;			/* ȥ꡼Ϥǽꡣ */

			if(dir_buf[i].attr==ATTR_VFAT)
			{
				/*
				 * VFAT(long name) entry.
				 */
				int ent_num=((DIR_ENT_LONG*)dir_buf)[i].id&~LONG_NAME_END;	/* number of long name entries. */

				if(ent_num==str_per_ent)
					for(k=(ent_num-1)*NAME_SIZE_PER_ENT;cmpLongPath((DIR_ENT_LONG*)&dir_buf[i],(short*)&str_buf[k])!=NULL;
						k-=NAME_SIZE_PER_ENT)
					{
						if(++i>=last)
						{
							/* Υ饹Хåեɤ߹ࡣ */
							NEXT_SECTOR();
							if(read_cache(din,dir_buf,clust_per_sect,sect)!=clust_per_sect)return -1;
							i=0;
						}

						/* 󥰥͡बפ롣 */
						if(--ent_num<=0)
						{
							dir_point->sector=sect;
							dir_point->index=i;
							*path=((*path)[str_len/2]=='/')?&(*path)[str_len/2+1]:&(*path)[str_len/2];

							return 0;
						}

					}

				/* Υȥ꡼˿ʤ롣 */
				for(i+=ent_num;i>=last;i-=last)NEXT_SECTOR();
				if(read_cache(din,dir_buf,clust_per_sect,sect)!=clust_per_sect)return -1;
			}
			else
			{
				/*
				 * normal entry.
				 */
				if((p=cmpPath(dir_buf[i].name,*path))!=NULL)
				{
					dir_point->sector=sect;
					dir_point->index=i;
					*path=p;

					return 0;
				}
				else ++i;
			}
		}

		/* Υ饹 */
		NEXT_SECTOR();
	}

	return -1;
}


/*
 * PUBLIC
 * ѥ򸡺롣
 * Υǥ쥯ȥݥȤ˥ǥ쥯ȥꥻȥ饹⥤ǥå롣
 * parameters : path,device inode,cluster,directory buffer(1 cluster),directory entry point
 * return : 0 or error=-1
 */
static int searchPath(const char *path,int din,int cluster,DIR_ENT *dir_buf,DIR_ENT_POINT *dir_point)
{
	enum{LONG_NAME_SIZE=512};

	const char *p=path;
	char *str_buf;


	if((str_buf=(char*)kmalloc(LONG_NAME_SIZE))==NULL)goto ERR;
	for(;;)
	{
		if(searchDir(&p,din,cluster,dir_buf,dir_point,str_buf)==-1)goto ERR;
		if(*p=='\0')break;
		if(dir_buf[dir_point->index].attr!=ATTR_DIR)goto ERR;
		cluster=dir_buf[dir_point->index].cluster;
	}
	kfree(str_buf);

	return 0;

ERR:
	kfree(str_buf);

	return -1;
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

static uint mount(int din)
{
	int root_sector;
	SUPER_BLOCK *boot_sect;
	DEV_STAT dev_stat;


	/* Ǥ˥ޥȤƤ뤫ǧ */
	if(superBlock[din]!=NULL)return -1;

	/* ֡ȥɤࡣ */
	if(get_dev_stat(din,&dev_stat)==-1)return 0;
	if((boot_sect=(SUPER_BLOCK*)kmalloc(dev_stat.sect_size))==NULL)return -1;
	if(read_direct(din,boot_sect,1,BOOT_SECT)!=1)goto ERR;

	/* ե륷ƥγǧ */
	if((boot_sect->fatType!=TYPE_FAT12)&&(boot_sect->fatType!=TYPE_FAT16))goto ERR;

	/* Ѳǽʥ饹 */
	root_sector=boot_sect->fatSectors*boot_sect->fatNum+FAT_SECT;	/* 롼ȥ */
	boot_sect->clusters=
		(boot_sect->allSectors-root_sector-(boot_sect->rootDirs*sizeof(DIR_ENT)/boot_sect->sectorSize))/boot_sect->clusterPerSect;

	/* 1Υǥ쥯ȥꥨȥ꡼ */
	boot_sect->clusterPerDirent=boot_sect->sectorSize*boot_sect->clusterPerSect/sizeof(DIR_ENT);

	/* 饹κǽΥ */
	boot_sect->beginCluster=FAT_SECT+boot_sect->fatSectors*boot_sect->fatNum+
		boot_sect->rootDirs*sizeof(DIR_ENT)/boot_sect->sectorSize-CLST_BEGIN*boot_sect->clusterPerSect;

	superBlock[din]=boot_sect;

	/* FATåν */
	if(initFatCache(din)==-1)goto ERR;

	return 0;

ERR:
	kfree(boot_sect);

	return -1;
}


static int umount(int din)
{
	kfree(superBlock[din]);
	superBlock[din]=NULL;
	releaseFatCache(din);

	return 0;
}


/*
 * parameters : path,device inode,cluster
 * return : directory point structure address
 */
static int open(const char *path,int din,uint cluster)
{
	DIR_ENT *dir_buf;
	DIR_ENT_POINT *dir_point=NULL;


	if((dir_buf=(DIR_ENT*)kmalloc(superBlock[din]->sectorSize*superBlock[din]->clusterPerSect))==NULL)return -1;
	if((dir_point=(DIR_ENT_POINT*)kmalloc(sizeof(DIR_ENT_POINT)))==NULL)goto ERR;

	if(searchPath(path,din,cluster,dir_buf,dir_point)==-1)goto ERR;
	if(dir_buf[dir_point->index].attr&(ATTR_VOL|ATTR_DIR))goto ERR;

	if((dir_point->entry=(DIR_ENT*)kmalloc(sizeof(DIR_ENT)))==NULL)goto ERR;
	*dir_point->entry=dir_buf[dir_point->index];

	kfree(dir_buf);

	return (int)dir_point;

ERR:
	kfree(dir_point);
	kfree(dir_buf);

	return -1;
}


static int close(int din,uint dir_point)
{
	kfree(((DIR_ENT_POINT*)dir_point)->entry);
	kfree((DIR_ENT*)dir_point);

	return 0;
}


static int read(int din,uint dir_point,void *buf,size_t size,size_t begin)
{
	DIR_ENT *dir=((DIR_ENT_POINT*)dir_point)->entry;
	int sectors=superBlock[din]->clusterPerSect;
	int cluster_size=superBlock[din]->sectorSize*sectors;
	int first_size;
	char *tmp_buf=NULL;
	int clust,sect,beg;


	/* γǧ */
	if(begin>=dir->size)return 0;
	if(begin+size>=dir->size)size=dir->size-begin;

	/*
	 * Хåեɤ߹ࡣ
	 */
	first_size=size;
	if((clust=getNextCluster(din,dir->cluster,begin/cluster_size))==-1)return -1;

	/* ϤΥ饹ʲɤ߹ߡ */
	if((beg=begin%cluster_size)!=0)
	{
		if((tmp_buf=(char*)kmalloc(cluster_size))==NULL)return -1;
		sect=clusterToSector(superBlock[din],clust);
		if(read_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
		if(size<=cluster_size-beg)
		{
			memcpy(buf,tmp_buf+beg,size);
			size=0;
		}
		else
		{
			memcpy(buf,tmp_buf+beg,cluster_size-beg);
			(char*)buf+=cluster_size-beg;
			size-=cluster_size-beg;
			if((clust=getNextCluster(din,clust,1))==-1)return -1;
		}
	}

	for(;size>=cluster_size;size-=cluster_size)
	{
		sect=clusterToSector(superBlock[din],clust);
		if(read_cache(din,buf,sectors,sect)!=sectors)goto ERR;
		(char*)buf+=cluster_size;
		if((clust=getNextCluster(din,clust,1))==-1)return -1;
	}

	if(size!=0)
	{
		if(tmp_buf==NULL)
			if((tmp_buf=(char*)kmalloc(cluster_size))==NULL)return -1;
		sect=clusterToSector(superBlock[din],clust);
		if(read_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
		memcpy(buf,tmp_buf,size);
	}

	kfree(tmp_buf);

	return first_size;

ERR:
	kfree(tmp_buf);

	return -1;
}


static int write(int din,uint dir_point,void *buf,size_t size,size_t begin)
{
	int sectors=superBlock[din]->clusterPerSect;
	int cluster_size=superBlock[din]->sectorSize*sectors;
	DIR_ENT *dir=((DIR_ENT_POINT*)dir_point)->entry;
	char *tmp_buf=NULL;
	int size1=0,size2=0;
	int clust,sect,beg,last,next_clust;


	/* 񤭹߳ϥɥ쥹γǧ */
	if(begin>dir->size)return -1;

	last=ROUNDUP(dir->size,cluster_size);		/* ¸饹ʥХȡˡ */
	if(size+begin>last)
	{
		size1=last-begin;
		size2=size-size1;
		if(checkEmptySize(din,size2)==-1)return -1;		/* ɲåγǧ */
	}
	if((clust=getNextCluster(din,dir->cluster,begin/cluster_size))==-1)return -1;

	/* ¸饹ν񤭹ߡ */
	if(size1)
	{
		/* ϤΥ饹ʲɤ߹ߡ */
		if((beg=begin%cluster_size)!=0)
		{
			if((tmp_buf=(char*)kmalloc(cluster_size))==NULL)return -1;
			sect=clusterToSector(superBlock[din],clust);
			if(read_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
			memcpy(tmp_buf,buf,cluster_size-beg);
			if(write_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
			(char*)buf+=cluster_size-beg;
			size1-=cluster_size-beg;
			if((clust=getNextCluster(din,clust,1))==-1)return -1;
		}

		for(;size1>=cluster_size;size1-=cluster_size)
		{
			sect=clusterToSector(superBlock[din],clust);
			if(write_cache(din,buf,sectors,sect)!=sectors)goto ERR;
			(char*)buf+=cluster_size;
			if((clust=getNextCluster(din,clust,1))==-1)return -1;
		}

		if(size1!=0)
		{
			if(tmp_buf==NULL)
				if((tmp_buf=(char*)kmalloc(cluster_size))==NULL)return -1;
			sect=clusterToSector(superBlock[din],clust);
			if(read_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
			memcpy(tmp_buf,buf,size1);
			if(write_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
		}
	}

	/*
	 * ɲå饹ؤν񤭹ߡ
	 */
	if(size2)
	{
		for(;size2>=cluster_size;size2-=cluster_size)
		{
			if((next_clust=getEmptyCluster(din))<=0)goto ERR;
			sect=clusterToSector(superBlock[din],clust);
			if(write_cache(din,buf,sectors,sect)!=sectors)goto ERR;
			(char*)buf+=cluster_size;
			writeCluster(din,dir,clust,next_clust);
			clust=next_clust;
		}

		if(size2!=0)
		{
			if(tmp_buf==NULL)
				if((tmp_buf=(char*)kmalloc(cluster_size))==NULL)return -1;
			memcpy(tmp_buf,buf,size2);
			if((next_clust=getEmptyCluster(din))<=0)goto ERR;
			sect=clusterToSector(superBlock[din],clust);
			if(write_cache(din,tmp_buf,sectors,sect)!=sectors)goto ERR;
			writeCluster(din,dir,clust,next_clust);
			clust=next_clust;
		}

		writeCluster(din,dir,clust,0xffff);

		/* ǥ쥯ȥꥨȥ꡼ι */
		dir->size=size+begin;
		if(tmp_buf==NULL)
			if((tmp_buf=(char*)kmalloc(cluster_size))==NULL)return -1;
		if(read_cache(din,tmp_buf,sectors,((DIR_ENT_POINT*)dir_point)->sector)!=sectors)goto ERR;
		((DIR_ENT*)tmp_buf)[((DIR_ENT_POINT*)dir_point)->index]=*((DIR_ENT_POINT*)dir_point)->entry;
		if(write_cache(din,tmp_buf,sectors,((DIR_ENT_POINT*)dir_point)->sector)!=sectors)goto ERR;
	}

	kfree(tmp_buf);

	return size;

ERR:
	kfree(tmp_buf);

	return -1;
}

/*********************************** ̤ ***************************************/
static int mkdir(const char *path,int din,uint dir_blk)
{
	return 0;
}


static int creat(const char *path,int din,uint dir_blk)
{
	return 0;
}


static int opendir(const char *path,int din,uint dir_blk)
{
	return 0;
}


static int ioctr(int din,uint inode,int cmd,void *param)
{
	return 0;
}


static int rename(int din,uint inode,const char *name)
{
	return 0;
}


/************************************************************************************
 *
 * Init functions
 *
 ************************************************************************************/

static FS fatFs={
	"fat_fs",mount,umount,open,close,read,write,ioctr,rename,creat,opendir,mkdir
};


int initFatFs()
{
	int i;


	for(i=0;i<MAX_DEVICE_OPEN;++i)superBlock[i]=NULL;

	return regist_fs(&fatFs);
}
/****************************************************************************************/
void test_fatFs()
{
	char *buf=(char*)0x80000;
	uint dir_point;
	int fd,din,root;


	{
		volatile int *keyDown=(int*)0x9f000;

		*keyDown=0;
		printk("Push any key please!\n");
		while(*keyDown==0);
	}

	if((fd=sys_open("/dev/fd",0))==-1)return;
	if((din=get_inode(fd))==-1)return;
	if((root=mount(din))==-1)return;

	dir_point=open("samp_fibonacci",din,root);
	printk("open=%d\n",dir_point);

	printk("read=%d\n",read(din,dir_point,buf,0xc800,0));
	printk("buf[323]=%x,buf[383]=%x,buf[384]=%x,buf[385]=%x\n",buf[382],buf[383],buf[384],buf[385]);
}
