/*
 * fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ե륷ƥ
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"mm.h"
#include"proc.h"
#include"fs.h"


enum{
	MOUNT_DEV=0,		/* ǥХե륷ƥdevice inodeɬ0 */
};


/* ޥȥե륷ƥ।ǥå */
typedef struct{
	ushort fs_num;			/* ե륷ƥʥС */
	ushort ref_count;		/* ȥ */
}MOUNT_FS;


static FS *fs_info[MAX_REGIST_FS];
static MOUNT_FS mount_fs[MAX_DEVICE_OPEN];


/************************************************************************************
 *
 * < ե륷ƥඦ̥饹 >
 *
 ************************************************************************************/

/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or ԰=NULL;
 */
extern inline const char *cmp_path(const char *path1,const char *path2)
{
	while(*path1==*path2++)
		if(*path1++=='\0')return path2-1;

	if((*(path2-1)=='/')&&(*path1=='\0'))return path2;
	else return NULL;
}


/************************************************************************************
 *
 * < ۥե륷ƥ९饹 >
 *
 * ޥȻȥȥǥ쥯ȥѹȥե¹Իɲä롣
 * ǥ쥯ȥꥨȥ꡼ʬڹ¤ˤ롣
 * rootdevǥ쥯ȥϲۥե륷ƥ˺Ƥ
 *
 * PUBLIC : search_upper_entry()
 *          search_path()
 *          delete_entry()
 *          make_entry()
 *          make_vdir()
 *          make_vinode()
 *
 ************************************************************************************/

enum{
	VDIR_MAX_NAME_SIZE=127,	/* ̥ե륷ƥκ̾ */
	SPLAY_COUNT=5			/* ʿԤޤǤθ */
};


/* ۥǥ쥯ȥꥨȥ꡼ */
typedef struct VDIR_ENT{
	void *addr;					/* ǥ쥯ȥޤinodeɥ쥹 */
	void *parent;				/* ƥǥ쥯ȥ */
	struct VDIR_ENT *low;		/* low branch entry */
	struct VDIR_ENT *high;		/* high branch entry */
	short low_num;				/* number of low branch entries */
	short high_num;				/* number of high branch entries */
	uchar type;					/* ե륿 */
	char name[0];				/* ѥ͡ */
}VDIR_ENT;

/*
 * ۥǥ쥯ȥ
 * ȥ󥿤ȸȥ꡼ΰ֤ϲinodeƱˤ롣
 */
typedef struct VDIR{
	ushort ref_count;		/* ȥ󥿡ޥȤ䥫ȥǥ쥯ȥ䤹 */
	uchar splay_count;		/* ȥ꡼ʿ¹ԥ */
	uchar din;				/* ǥХinode */
	uint block;				/* ǥХ֥å */
	VDIR_ENT *entry;		/* ȥ꡼ */
	VDIR_ENT *top;			/* ǥ쥯ȥꥨȥ꡼ȥå */
	struct VDIR *mount_dir;	/* ޥȤۥǥ쥯ȥ */
}VDIR;

/*
 * inode
 * ȥ󥿤ȸȥ꡼ΰ֤ϲۥǥ쥯ȥƱˤ롣
 */
typedef struct{
	ushort ref_count;		/* ȥ */
	ushort din;				/* ǥХinode */
	uint block;				/* ǥХ֥å */
	VDIR_ENT *entry;		/* ȥ꡼ */
	uint *exe_page;			/* ɤ߼ѥڡ */
}VINODE;


static VDIR_ENT rootEnt=							/* rootȥ꡼ */
	{NULL,NULL,NULL,NULL,0,0,DIRECTORY};
static char dev_ent[sizeof(VDIR_ENT)+4];			/* 4"dev"ȥ󥰥Хȿ */
static VDIR root=									/* 롼ȥǥ쥯ȥ */
	{0,0,0,0,&rootEnt,(VDIR_ENT*)&dev_ent,NULL};
static VDIR dev=									/* devǥ쥯ȥ */
	{0,0,MOUNT_DEV,0,(VDIR_ENT*)&dev_ent,NULL,NULL};


/*
 * PRIVATE
 * ѥ'/'ޤ'\0'ޤǥԡơ'\0'ղä롣
 * parameters : Destination string,Sorce string
 * return : next path
 */
extern inline const char *cpy_path(char *str,const char *path)
{
	while((*str=*path++)!='\0')
		if(*str++=='/')
		{
			*(str-1)='\0';
			return path;
		}

	return path-1;
}


/*
 * ѥʸ󥵥Ϥ롣
 * parmeters :
 */
extern inline size_t path_len(const char *s)
{
	const char *p=s;


	while(*p++!='/')
		if(*p=='\0')break;

	return (size_t)(p-s-1);
}


/*
 * PRIVATE
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or =1 or =-1;
 */
extern inline int cmp_path_in_tree(const char *path1,const char *path2)
{
	while(*path1==*path2++)
		if(*path1++=='\0')return (int)path2-1;

	if((*(path2-1)=='/')&&(*path1=='\0'))return (int)path2;

	if(*path1<*(path2-1))return 1;
	else return -1;
}


/*
 * PRIVATE
 * ʬڤlow¦˲ž롣
 * parameters : ž륨ȥ꡼Ƥݥ󥿥ɥ쥹
 */
extern inline void round_low(VDIR_ENT **upper)
{
	VDIR_ENT *top=*upper;
	VDIR_ENT *high;


	/* highޤtopοƤλޤ˰ư */
	*upper=high=top->high;

	/* highޤlowޤtophighޤ˰ư */
	top->high_num=high->low_num;
	top->high=high->low;

	/* tophigh꡼դlow꡼դ˰ư */
	high->low=top;
	high->low_num=top->low_num+top->high_num;
}


/*
 * PRIVATE
 * ʬڤhigh¦˲ž롣
 * parameters : ž륨ȥ꡼Ƥݥ󥿥ɥ쥹
 */
extern inline void round_high(VDIR_ENT **upper)
{
	VDIR_ENT *top=*upper;
	VDIR_ENT *low;


	/* lowޤtopοƤλޤ˰ư */
	*upper=low=top->low;

	/* lowޤhighޤtoplowޤ˰ư */
	top->low_num=low->high_num;
	top->low=low->high;

	/* toplowޤhighޤ˰ư */
	low->high=top;
	low->high_num=top->low_num+top->high_num;
}


/*
 * PRIVATE
 * ʬ٨ʿؿ
 * ¦Υȥ꡼ȿ¦Υȥ꡼2ܤ¿
 * ¦¦Υȥ꡼¦Υȥ꡼1/2꾯ʤ硢ȿ¦زž롣
 * parameters : ȥ꡼Ƥݥ󥿥ɥ쥹
 */
static void splay(VDIR_ENT **upper)
{
	VDIR_ENT *top=*upper;


	if((top->high_num>top->low_num*2)&&(top->high->low_num<top->high_num/2))
		round_low(upper);
	else if((top->low_num>top->high_num*2)&&(top->low->high_num<top->low_num/2))
		round_high(upper);
}


/*
 * PRIVATE
 * ǥ쥯ȥꥨȥ꡼򸡺롣
 * Υѥ˼Υѥݥ󥿤֤
 * parameters : ѥ,ȥ꡼
 * return : ȥ꡼ or ʤ=NULL
 */
extern inline VDIR_ENT *search_entry(const char **path,VDIR *dir)
{
	int c;
	VDIR_ENT *p=dir->top;


	while(p!=NULL)
	{
		c=cmp_path_in_tree(p->name,*path);
		if(c==-1)p=p->low;
		else if(c==1)p=p->high;
		else
		{
			*path=(const char*)c;
			return p;
		}
	}

	return NULL;
}


/*
 * PUBLIC
 * ѥ̾ξ̥ȥ꡼ݥ󥿤򸡺ͤȥåץȥ꡼­Ƥ
 * parameters : path name,directory,add value
 * return : upper entry point
 */
static VDIR_ENT **search_upper_entry(const char *name,VDIR *dir,int add)
{
	int c;
	VDIR_ENT **p=&dir->top;


	if(dir->splay_count++==SPLAY_COUNT)
	{
		dir->splay_count=0;

		while(*p!=NULL)
		{
			splay(p);

			c=cmp_path_in_tree((*p)->name,name);
			if(c==-1)
			{
				p=&((*p)->low);
				(*p)->low_num+=add;
			}
			else if(c==1)
			{
				p=&((*p)->high);
				(*p)->high_num+=add;
			}
			else break;
		}
	}
	else
		while(*p!=NULL)
		{
			c=cmp_path_in_tree((*p)->name,name);
			if(c==-1)
			{
				p=&((*p)->low);
				(*p)->low_num+=add;
			}
			else if(c==1)
			{
				p=&((*p)->high);
				(*p)->high_num+=add;
			}
			else break;
		}

	return p;
}


/*
 * PUBLIC
 * ѥ̾Υȥ꡼򸡺롣
 * Υѥݥ󥿤ˤϡΥѥݥ󥿤롣
 * Υǥ쥯ȥݥ󥿤ˤϸǥ쥯ȥޤinode롣
 * parameters : path address pointer,vdir address pointer
 * return : file type
 */
static int search_path(const char **ppath,VDIR **pdir)
{
	const char *path=*ppath;
	const char *next_path;
	VDIR *vdir=*pdir;
	VDIR_ENT *entry=NULL;


	if(*path=='\0')return DIRECTORY;

	do
	{
		if((next_path=cmp_path(".",path))!=NULL)
		{
			path=next_path;
			continue;
		}
		else if((next_path=cmp_path("..",path))!=NULL)
		{
			path=next_path;
			vdir=vdir->entry->parent;
			continue;
		}
		else
		{
			if((entry=search_entry(&path,vdir))==NULL)break;
			vdir=(VDIR*)entry->addr;
			while(vdir->mount_dir!=NULL)vdir=vdir->mount_dir;
		}
	}while((*path!='\0')&&(entry->type==DIRECTORY));

	*ppath=path;
	*pdir=vdir;

	return (entry==NULL)?DIRECTORY:entry->type;
}


/*
 * PUBLIC
 * ȥ꡼ʬڤ롣
 * ǿξʤزžʬǲߤƺ롣
 * parameters : upper entry pointer addres
 * return : 0 or error=-1
 */
static void delete_entry(VDIR_ENT **p)
{
	VDIR_ENT *del;


	/* λޤ0ˤʤޤǲߤ롣 */
	while((*p)->low_num*(*p)->high_num)
	{
		/* ʤޤ˲ž롣 */
		if((*p)->low_num<(*p)->high_num)
		{
			round_low(p);
			--(*p)->low_num;
			p=&(*p)->low;
		}
		else
		{
			round_high(p);
			--(*p)->high_num;
			p=&(*p)->high;
		}
	}

	del=*p;
	*p=(VDIR_ENT*)((int)del->low+(int)del->high);
	kfree(del);
}


/*
 * PUBLIC
 * ۥǥ쥯ȥꥨȥ꡼롣
 * pathˤϼpath pinter롣
 * parameers : path pointer,parent directory
 * return : directory entry or error=NULL
 */
extern inline VDIR_ENT *make_entry(const char **path,VDIR *dir)
{
	VDIR_ENT *entry;


	if((entry=(VDIR_ENT*)kmalloc(sizeof(VDIR_ENT)+path_len(*path)+1))==NULL)return NULL;
	entry->parent=dir;
	entry->low=NULL;
	entry->high=NULL;
	entry->low_num=0;
	entry->high_num=0;
	*path=cpy_path(entry->name,*path);

	return entry;
}


/*
 * PUBLIC
 * ۥǥ쥯ȥ롣
 * parameters : device inode,block
 * return : directory or error=NULL
 */
extern inline VDIR *make_vdir(int din,uint block,VDIR_ENT *entry)
{
	VDIR *vdir;


	if((vdir=(VDIR*)kmalloc(sizeof(VDIR)))==NULL)return NULL;
	vdir->ref_count=0;
	vdir->splay_count=0;
	vdir->din=din;
	vdir->block=block;
	vdir->entry=entry;
	vdir->top=NULL;
	vdir->mount_dir=NULL;

	return vdir;
}


/*
 * PUBLIC
 * inode롣
 * parameters : device inode,block
 * return : directory or error=NULL
 */
extern inline VINODE *make_vinode(int din,uint block,VDIR_ENT *entry)
{
	VINODE *vinode;


	if((vinode=(VINODE*)kmalloc(sizeof(VINODE)))==NULL)return NULL;
	vinode->ref_count=0;
	vinode->din=din;
	vinode->block=block;
	vinode->entry=entry;
	vinode->exe_page=NULL;

	return vinode;
}


/************************************************************************************
 *
 * < ե륷ƥ饹 >
 *
 ************************************************************************************/

/* եǥץ */
typedef struct{
	ushort ref_count;	/* ȥ */
	ushort din;			/* device inode number */
	uint inode;			/* inode֥å */
	size_t offset;		/* ɤ߽񤭳ϥեå */
/*	VDIR *vdir;*/			/* ۥǥ쥯ȥޤϲinode */
}F_DSC;

/* ץѥե빽¤ */
typedef struct{
	VDIR *current_dir;			/* ȥǥ쥯ȥ */
	VINODE *exe_entry;			/* ¹ԥե륨ȥ꡼ */
	F_DSC *fd[MAX_FILE_OPEN];
	uchar num[MAX_FILE_OPEN];
	uchar fd_count;				/* եǥץץ */
	uchar next_fd;				/* ζեǥץ */
}FILE_STRUCT;


/*
 * GLOBAL
 * Register filesystem
 * parameters : Filesystem struct pinter
 * return : 0 or Error=-1
 */
int regist_fs(FS *fs)
{
	int i;


	for(i=0;i<MAX_REGIST_FS;++i)
		if(fs_info[i]==NULL)
		{
			fs_info[i]=fs;
			return 0;
		}

	return -1;
}


/*
 * GLOBAL
 * Search file system
 * parameters : file system name
 * return : file system number or noshing=-1
 */
int search_fs(const char *name)
{
	int i;


	for(i=0;fs_info[i]!=NULL;++i)
		if(strcmp(fs_info[i]->name,name)==0)return i;

	return -1;
}


/*
 * GLOBAL
 * mount filesystem
 * parameters : 벾ۥǥ쥯ȥ
 * return : 0 or error=-1
 */
int mountRoot(const char *dev_path,const char *fs_name)
{
	enum{DEV_NAME_SIZE=5};		/* "/dev/"Υ */

	int fs,mount_din;
	uint root_blk;

	/* Search file system number */
	if((fs=search_fs(fs_name))==-1)return -1;

	/* ǥХץ */
	if(cmp_path("/dev",dev_path)==NULL)return -1;
	if((mount_din=fs_info[mount_fs[MOUNT_DEV].fs_num]->open(dev_path+DEV_NAME_SIZE,0,0))==-1)return -1;
	else mount_fs[mount_din].fs_num=fs;

	/* ǥХ˥ޥȤƤ뤫 */
	if((++mount_fs[mount_din].ref_count>1)&&(mount_fs[mount_din].fs_num!=fs))goto ERR;

	/* ޥȴؿƤӽФ */
	if((root_blk=fs_info[fs]->mount(mount_din))==-1)goto ERR;

	/* 롼Ȳۥǥ쥯ȥꡣ */
	root.din=mount_din;
	root.block=root_blk;

	return 0;

ERR:
	fs_info[mount_fs[MOUNT_DEV].fs_num]->close(MOUNT_DEV,mount_din);

	return -1;
}


/*
 * GLOBAL
 * ץѥե빽¤Τν
 * parameters : process
 * return : 0 or error=-1
 */
int init_file_struct(PROC *proc)
{
	int i;
	FILE_STRUCT *p;


	if((p=(FILE_STRUCT*)kmalloc(sizeof(FILE_STRUCT)))==NULL)return -1;
	p->fd_count=0;
	p->next_fd=0;
	memset(p->fd,0,sizeof(F_DSC*)*MAX_FILE_OPEN);
	for(i=0;i<MAX_FILE_OPEN;++i)p->num[i]=i+1;
	p->current_dir=NULL;
	p->exe_entry=NULL;
	proc->file_struct=(void*)p;

	return 0;
}


/*
 * GLOBAL
 * fork˥եطι¤Τƥץ饳ԡ롣
 * parameters : parent process,chils process
 * return : 0 or error=-1
 */
int cpy_file_struct(PROC *parent,PROC *child)
{
	int i,j,fd_count;
	F_DSC **fd;


	if((child->file_struct=kmalloc(sizeof(FILE_STRUCT)))==NULL)return -1;
	memcpy(child->file_struct,parent->file_struct,sizeof(FILE_STRUCT));

	/* եǥץλȥ󥿤1䤹 */
	fd=((FILE_STRUCT*)child->file_struct)->fd;
	fd_count=((FILE_STRUCT*)child->file_struct)->fd_count;
	for(i=0,j=0;;++i)
		if(fd[i]!=NULL)
		{
			++fd[i]->ref_count;
			if(++j>=fd_count)break;
		}

	return 0;
}


/*
 * GLOBAL
 * եطι¤Τ롣
 * parameters : FILE_STRUCT address
 * return : 0 or error=-1
 */
int releaseFileStruct(void *fstruct)
{
	int i;


	for(i=0;i<MAX_FILE_OPEN;++i)
	{
		if(((FILE_STRUCT*)fstruct)->fd[i]!=NULL)
		{
			if(sys_close(i)==-1)return -1;
			if(((FILE_STRUCT*)fstruct)->fd_count<=0)return 0;
		}
	}

	return -1;
}


/*
 * GLOBAL
 * inode֤
 * parameters : file descriptor
 * return : inode block or error=-1
 */
int get_inode(int fd)
{
	F_DSC *fdsc;


	if(fd>MAX_FILE_OPEN)return -1;

	if((fdsc=((FILE_STRUCT*)(get_current_task()->file_struct))->fd[fd])==NULL)return -1;

	return fdsc->inode;
}


/************************************************************************************
 *
 * ե¹
 *
 ************************************************************************************/

/*
 * PUBLIC
 * ե륪ץ
 * parameters : path,current directory,open struct
 */
extern inline int open(const char *path,VDIR *current_dir,OPEN_F *open_f)
{
	int type;
	VDIR *vdir;


	/* եõ */
	if(*path=='/')
	{
		path+=1;
		vdir=&root;
	}
	else vdir=current_dir;

	type=search_path(&path,&vdir);

	if((*path=='\0')&&(type==NORMAL_FILE))
	{
		open_f->inode=((VINODE*)vdir)->block;
		++((VINODE*)vdir)->ref_count;
	}
	else if((*path!='\0')&&(type==DIRECTORY))
	{
		if((open_f->inode=fs_info[mount_fs[vdir->din].fs_num]->open(path,vdir->din,vdir->block))==-1)
				return -1;
	}
	else return -1;

	open_f->din=vdir->din;

	return 0;
}


/*
 * GLOBAL
 * ¹ԥե륪ץ̾Υץδάؿ
 * parameters : path,open file struct
 * return : 0 or error=-1
 */
int exec_open(const char *path,OPEN_F *open_f)
{
	FILE_STRUCT *fstruct;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if(open(path,fstruct->current_dir,open_f)==-1)return -1;

	return 0;
}


/*
 * GLOBAL
 * ¹ԥեɤ߹ߡ̾Υ꡼ɤδάؿ
 * parameters : open file struct,buffer,read size
 * return : read byte or error=-1
 */
int exec_read(OPEN_F *open_f,void *buf,size_t size)
{
	return fs_info[mount_fs[open_f->din].fs_num]->read(open_f->din,open_f->inode,buf,size,open_f->offset);
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

int sys_mount(const char *dev_path,const char *fs_name,const char *path)
{
	enum{DEV_NAME_SIZE=5};		/* "/dev/"Υ */

	int fs;
	int din,mount_din;
	int block;
	uint root_blk;
	FILE_STRUCT *fstruct;
	VDIR *vdir;
	VDIR_ENT *ventry,**up_entry;
	int (*opendir)(const char*,int,uint);
	const char *q;
	VDIR *p;


	/* Search file system number */
	if((fs=search_fs(fs_name))==-1)return -1;

	/* ǥХץ */
	if(cmp_path("/dev",dev_path)==NULL)return -1;
	if((mount_din=fs_info[mount_fs[MOUNT_DEV].fs_num]->open(dev_path+DEV_NAME_SIZE,0,0))==-1)return -1;

	/* ǥХ˥ޥȤƤ뤫 */
	if((++mount_fs[mount_din].ref_count>1)&&(mount_fs[mount_din].fs_num!=fs))goto ERR;
	else mount_fs[mount_din].fs_num=fs;

	/* ޥȴؿƤӽФ */
	if((root_blk=fs_info[fs]->mount(mount_din))==-1)goto ERR;

	/* ۥե륷ƥΥǥ쥯ȥ򸡺롣 */
	if(*path=='/')
	{
		path+=1;
		vdir=&root;
	}
	else
	{
		fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
		vdir=fstruct->current_dir;
	}
	if(search_path(&path,&vdir)!=DIRECTORY)goto ERR;

	if(*path!='\0')
	{
		din=vdir->din;
		block=vdir->block;
		opendir=fs_info[mount_fs[din].fs_num]->opendir;
		p=vdir;
		q=path;

		do
		{
			up_entry=search_upper_entry(q,p,1);
			if((ventry=make_entry(&q,p))==NULL)goto ERR2;
			ventry->type=DIRECTORY;
			*up_entry=ventry;
			if((block=opendir(ventry->name,din,block))==-1)goto ERR2;
			if((p=make_vdir(din,block,ventry))==NULL)goto ERR2;
			ventry->addr=p;
		}while(*q!='\0');

		vdir=p;
	}

	/* ޥȤ벾ۥǥ쥯ȥ롣 */
	if((p=make_vdir(mount_din,root_blk,vdir->entry))==NULL)goto ERR;
	vdir->mount_dir=p;

	return 0;

ERR2:
	if((ventry=*search_upper_entry(path,vdir,-1))!=NULL)
		while(ventry!=NULL)
		{
			vdir=(VDIR*)ventry->addr;
			kfree(ventry);
			if(vdir==NULL)break;
			ventry=vdir->top;
			kfree(vdir);
		}
ERR:
	--mount_fs[mount_din].ref_count;
	fs_info[mount_fs[MOUNT_DEV].fs_num]->close(MOUNT_DEV,mount_din);

	return -1;
}

int sys_umount(const char *path)
{
	int fs;
	FILE_STRUCT *fstruct;
	VDIR *vdir;
	VDIR *p;
	VDIR_ENT *q,**r;


	/* ǥ쥯ȥõ */
	if(*path=='/')
	{
		path+=1;
		vdir=&root;
	}
	else
	{
		fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
		vdir=fstruct->current_dir;
	}
	if(search_path(&path,&vdir)!=DIRECTORY)return -1;
	if(*path!='\0')return -1;
	if(vdir->ref_count==0)return -1;
	if(vdir->entry->addr==(void*)vdir)return -1;	/* ޥȥǥ쥯ȥǤϤʤ */

	/* ޥȡ */
	if(--vdir->ref_count==0)
	{
		fs=mount_fs[vdir->din].fs_num;
		if(fs_info[fs]->umount(vdir->din)==-1)return -1;
		--mount_fs[vdir->din].ref_count;

		/*
		 * ۥǥ쥯ȥ롣
		 */

		/* ¿ťޥȤϡǸΥޥȤΤߺ */
		vdir=p=vdir->entry->addr;
		for(;p->mount_dir!=vdir;p=p->mount_dir);
		kfree(p->mount_dir);
		p->mount_dir=NULL;

		if(vdir->mount_dir==NULL)
			while((vdir->ref_count==0)&&(vdir->top==NULL))
			{
				q=vdir->entry;
				kfree(vdir);
				vdir=q->parent;
				r=search_upper_entry(q->name,vdir,-1);
				delete_entry(r);
			}
	}

	return 0;
}

/*
 * parameters : path,flag
 * return : file descriptor number or error=-1
 */
int sys_open(const char *path,int flag)
{
	int fd_num;
	FILE_STRUCT *fstruct;
	F_DSC *fd;
	OPEN_F open_f;


	/* ץΥå */
	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if(fstruct->fd_count>=MAX_FILE_OPEN)return -1;

	/* եõ */
	if(open(path,fstruct->current_dir,&open_f)==-1)return -1;

	/* եǥץϿ롣 */
	if((fd=(F_DSC*)kmalloc(sizeof(F_DSC)))==NULL)
	{
		fs_info[mount_fs[open_f.din].fs_num]->close(open_f.din,open_f.inode);
		return -1;
	}
	fd->din=open_f.din;
	fd->inode=open_f.inode;
	fd->offset=0;
	fd->ref_count=1;
/*	fd->vdir=vdir;*/
	fstruct->fd[fstruct->next_fd]=fd;
	fd_num=fstruct->next_fd;
	fstruct->next_fd=fstruct->num[fstruct->next_fd];
	++fstruct->fd_count;

	return fd_num;
}

/*
 * parameters : file descriptor number
 * return : 0 or error=-1
 */
int sys_close(int fd_num)
{
	FILE_STRUCT *fstruct;
	F_DSC *fd;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if((fd=fstruct->fd[fd_num])==NULL)return -1;

	if(--fd->ref_count>0)return 0;										/* ȥ󥿤1餹 */
	if(fs_info[mount_fs[fd->din].fs_num]->close(fd->din,fd->inode)==-1)	/* ե򥯥롣 */
		return -1;

	kfree(fd);

	fstruct->fd[fd_num]=NULL;
	fstruct->num[fd_num]=fstruct->next_fd;
	fstruct->next_fd=fd_num;
	--fstruct->fd_count;

	return 0;
}

/*
 * parameters : file descriptor number,baffer,read bytes
 * return : read bytes or error=-1
 */
int sys_read(int fd_num,void *buf,size_t size)
{
	FILE_STRUCT *fstruct;
	F_DSC *fd;
	int rest;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if((fd=fstruct->fd[fd_num])==NULL)return -1;

	/* readؿƤӽФ */
	rest=fs_info[mount_fs[fd->din].fs_num]->read(fd->din,fd->inode,buf,size,fd->offset);
	if(rest==-1)return -1;
	fd->offset+=rest;

	return rest;
}

int sys_write(int fd_num,void *buf,size_t size)
{
	FILE_STRUCT *fstruct;
	F_DSC *fd;
	int rest;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;

	if((fd=fstruct->fd[fd_num])==NULL)return -1;

	/* writeؿƤӽФ */
	rest=fs_info[mount_fs[fd->din].fs_num]->write(fd->din,fd->inode,buf,size,fd->offset);
	if(rest==-1)return -1;
	fd->offset+=rest;

	return rest;
}

int sys_mkdir(const char *path)
{
	FILE_STRUCT *fstruct;
	VDIR *vdir;


	if(*path=='/')
	{
		path+=1;
		vdir=&root;
	}
	else
	{
		fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
		vdir=fstruct->current_dir;
	}

	if(search_path(&path,&vdir)==NORMAL_FILE)return -1;

	return fs_info[mount_fs[vdir->din].fs_num]->mkdir(path,vdir->din,vdir->block);
}

/************************************* ̤ ******************************************/
int sys_lseek(int fd_num,int offset,int flag)
{
	enum{
		SEEK_SET=0,
		SEEK_CUR,
		SEEK_END
	};

	return 0;
}

int sys_creat()
{
	return 0;
}

int sys_rename()
{
	return 0;
}

int sys_unlink()
{
	return 0;
}

int sys_lock()
{
	return 0;
}

int chdir()
{
	return 0;
}


/************************************************************************************
 *
 * 
 *
 ************************************************************************************/

/*
 * Init virtual filesystem
 */
void init_fs()
{
	memset(fs_info,0,sizeof(FS*)*MAX_REGIST_FS);
	memset(mount_fs,0,sizeof(MOUNT_FS)*MAX_DEVICE_OPEN);
	rootEnt.addr=&root;
	rootEnt.parent=&root;
	((VDIR_ENT*)dev_ent)->addr=&dev;
	((VDIR_ENT*)dev_ent)->parent=&root;
	((VDIR_ENT*)dev_ent)->low=NULL;
	((VDIR_ENT*)dev_ent)->high=NULL;
	((VDIR_ENT*)dev_ent)->low_num=0;
	((VDIR_ENT*)dev_ent)->high_num=0;
	((VDIR_ENT*)dev_ent)->type=DIRECTORY;
	((VDIR_ENT*)dev_ent)->name[0]='d';
	((VDIR_ENT*)dev_ent)->name[1]='e';
	((VDIR_ENT*)dev_ent)->name[2]='v';
	((VDIR_ENT*)dev_ent)->name[3]='\0';
}


/*
 * Mount device file
 * parameters : file system register number
 * return : 0 or error=-1
 */
int mount_dev_fs(int fs)
{
	if(mount_fs[MOUNT_DEV].ref_count!=0)return -1;
	mount_fs[MOUNT_DEV].ref_count=1;
	mount_fs[MOUNT_DEV].fs_num=fs;

	return 0;
}

/*************************************************************************************************/
void test_fs()
{
	FILE_STRUCT *fstruct=(FILE_STRUCT*)get_current_task()->file_struct;;


	printk("fd=%x\n",fstruct->fd[1]);
}
/**************************************************************************************************/

