/*
 * mm.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * mm.c ѥإåե
 */


#ifndef mm_h
#define mm_h


#include"types.h"
#include"proc.h"
#include"fs.h"


#ifndef ASM_FILE


enum{
	PAGE_SIZE=0x1000,			/* Page size */
	PAGEDIR_SIZE=0x400000,		/* Page directory size */

	/* loadBinary() flag. */
	LB_R=1,
	LB_WR=2,
};


extern inline void flash_tbl(uint *pagedir)
{
	asm volatile(
		"movl	%%eax,%%cr3"
		::"a"(pagedir)
	);
}

extern void initMm();
extern uint *initPaging();
extern uint *forkPage(PROC*,void**);
extern int loadBinary(OPEN_F*,size_t,uint,int);
extern void releaseUserPage();
extern void *kmalloc(size_t);
extern void kfree(void*);
extern void *getPhysAddrFromLinearAddr(void*,int*);


#endif


#endif
