/*
 * proc.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץط
 */


#include"types.h"
#include"mm.h"
#include"fs.h"
#include"errno.h"
#include"interrupt.h"
#include"lock.h"
#include"segment.h"
#include"time.h"
#include"elf.h"
#include"proc.h"


/* tssǼ¤(104Х) */
typedef struct{
	uint link,esp0,ss0,esp1,ss1,esp2,ss2,cr3,eip,eflags,eax,ecx,
		edx,ebx,esp,ebp,esi,edi,es,cs,ss,ds,fs,gs,ldts,tflag_iomap;
}TSS;


CPU cputask[MAX_CPU];		/* Task infomations for each cpu */

/* TSS󥰻Υååɬ */
static TSS kernel_tss={
	0,
	KERNEL_ESP_BEG,	/* esp0 */
	KERNEL_DATA_DES,	/* ss0 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
static PROC *idle_proc[MAX_CPU];	/* Idle process */
static CPU guard[2]={				/* Guard for link */
	{0,NULL,0,NULL,NULL},
	{0,NULL,~0,NULL,NULL}
};
static int cputask_gate=0;			/* Lock gate for cputask[] */
static int few_task_cpu=0;			/* ΰ־ʤcpu */
static int page_table_gate=0;		/* Lock gate for page table */


static void add_proc(PROC*);
static int change_cpu_link(int);


/******************************************************************************************************
 *
 * 塼ط
 *
 *******************************************************************************************************/


/*
 * Add task to shedule
 * parameters : Process
 */
void add_to_schedule(PROC *proc)
{
	int eflag;
	int cpu;


	cpu=proc->cpu;

	enterCli(&eflag);
	enter_spinlock(&cputask[cpu].gate);
	{
		if(cputask[cpu].current_task==idle_proc[cpu])
		{
			proc->next=proc;
			proc->prev=proc;
			idle_proc[cpu]->next=proc;
		}
		else
		{
			/*ߥ󥯤ƤȤ롣 */
			proc->prev->next=proc->next;
			proc->next->prev=proc->prev;

			/* ȥץμ˲ä */
			proc->prev=cputask[cpu].current_task;
			proc->next=cputask[cpu].current_task->next;
			cputask[cpu].current_task->next=proc;
			proc->next->prev=proc;
		}
	}
	exit_spinlock(&cputask[cpu].gate);
	exitCli(&eflag);
}


/*
 * Delete process
 * parameters : process
 */
void del_from_schedule(PROC *proc)
{
	int eflag;
	int cpu;


	cpu=proc->cpu;

	/* Delete current task */
	enterCli(&eflag);
	enter_spinlock(&cputask[cpu].gate);
	{
		if(proc->next==proc)
		{
			idle_proc[cpu]->next=idle_proc[cpu];
			idle_proc[cpu]->prev=idle_proc[cpu];
			proc->next=idle_proc[cpu];
		}
		else
		{
			proc->prev->next=proc->next;
			proc->next->prev=proc->prev;
		}
	}
	exit_spinlock(&cputask[cpu].gate);
	exitCli(&eflag);
}


/*
 * Process switch
 * parameters : γ߻Υ֥åȥåesp,γ߻espͤ¸륹å
 * returns : Page directory
 */
uint *switch_task(volatile uint esp,volatile uint before_esp)
{
	int cpu;
	PROC *current;


	cpu=get_current_cpu();
	current=cputask[cpu].current_task;
	before_esp=current->esp;
	current->esp=esp;

	current=current->next;
	esp=(uint)&current->esp;
	cputask[cpu].current_task=current;

	return current->pagedir;
}


/******************************************************************************************************
 *
 * ץ
 *
 *******************************************************************************************************/


/*
 * ץ¹Բǽˤ
 * parameters : process
 */
void add_proc(PROC *proc)
{
	int cpu;


	if(proc==NULL)return;

	cpu=few_task_cpu;
	proc->cpu=cpu;
	add_to_schedule(proc);
	++cputask[cpu].proc_num;

	/* Change cpu in which minimum numbers of task */
	few_task_cpu=change_cpu_link(cpu);
}


/*
 * Change cpu struct link to previous
 * parameters : cpu number
 * retuuns : Top link cpu number
 */
int change_cpu_link(int cpu)
{
	CPU *p;


	enter_spinlock(&cputask_gate);
	{
		/* to previous */
		if(cputask[cpu].proc_num<cputask[cpu].prev->proc_num)
		{
			for(p=cputask[cpu].prev->prev;cputask[cpu].proc_num<p->proc_num;p=p->prev);
			cputask[cpu].prev->next=cputask[cpu].next;
			cputask[cpu].next->prev=cputask[cpu].prev;
			cputask[cpu].prev=p;
			cputask[cpu].next=p->next;
			p->next->prev=&cputask[cpu];
			p->next=&cputask[cpu];
		}
		/* to next */
		else if(cputask[cpu].proc_num>cputask[cpu].next->proc_num)
		{
			for(p=cputask[cpu].next->next;cputask[cpu].proc_num>p->proc_num;p=p->next);
			cputask[cpu].prev->next=cputask[cpu].next;
			cputask[cpu].next->prev=cputask[cpu].prev;
			cputask[cpu].prev=p->prev;
			cputask[cpu].next=p;
			p->prev->next=&cputask[cpu];
			p->prev=&cputask[cpu];
		}
	}
	exit_spinlock(&cputask_gate);

	return guard[0].next->cpu;
}


/******************************************************************************************************
 *
 * 
 *
 *******************************************************************************************************/


/*
 * Init taskcpu
 * cpu˥ꥢꤹɬפ
 * parameters : number of cpu
 * returns : NOERROR
 */
int init_cputask(int cpu)
{
	cputask[cpu].cpu=cpu;
	cputask[cpu].current_task=NULL;
	cputask[cpu].proc_num=0;
	cputask[cpu].gate=0;
	cputask[cpu].next=&guard[1];
	guard[1].prev=&cputask[cpu];
	if(cpu==0)
	{
		cputask[cpu].prev=&guard[0];
		guard[0].next=&cputask[cpu];
	}
	else
	{
		cputask[cpu].prev=&cputask[cpu-1];
		cputask[cpu-1].next=&cputask[cpu];
	}

	return 0;
}


/*
 * TSSǥץꤹ
 *  : ǥץ͡TSSɥ쥹
 */
void set_tss(int des)
{
	set_gdt(des,&kernel_tss,104,TYPE_TSS);

	asm volatile(
		"movl	%0,%%eax\n"
		"ltr	%%ax"
		::"m"(des)
	);
}


/*
 * Set idle process table
 * parameters : Page directory
 * returns : 0 or Error number
 */
int set_idle_proc(int cpu)
{
	/* Set process table */
	if((idle_proc[cpu]=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	idle_proc[cpu]->next=idle_proc[cpu];
	idle_proc[cpu]->prev=idle_proc[cpu];
	idle_proc[cpu]->cpu=cpu;

	/* init paging */
	if((idle_proc[cpu]->pagedir=initPaging())==NULL)return -1;;
	idle_proc[cpu]->pagedir_gate=0;

	if(init_file_struct(idle_proc[cpu])==-1)return -ENOMEM;

	/* add to schedule queue */
	cputask[cpu].current_task=idle_proc[cpu];

	return 0;
}


/******************************************************************************************************
 *
 * Task wait
 *
 *******************************************************************************************************/


/*
 * Wait process
 * ñ
 * parameters : Wait queue
 */
void wait_proc(WAIT_QUEUE *queue)
{
	PROC *proc;


	enter_spinlock(&queue->gate);
	{
		if(queue->flag==0)
		{
			queue->flag=1;
			exit_spinlock(&queue->gate);
			return;
		}
		else
		{
			proc=cputask[get_current_cpu()].current_task;

			/* Add process to wait queue */
			queue->wait_prev->wait_next=proc;
			proc->wait_next=(PROC*)queue;
			queue->wait_prev=proc;

			del_from_schedule(proc);
		}
	}
	exit_spinlock(&queue->gate);

	wait_task();
}


/*
 * Wake up process
 * parameters : Wait queue
 */
void wake_proc(WAIT_QUEUE *queue)
{
	PROC *proc;


	/* Delete process from wait queue */
	enter_spinlock(&queue->gate);
	{
		if(queue->wait_prev==(PROC*)queue)queue->flag=0;
		else
		{
			proc=queue->wait_next;
			queue->wait_next=proc->wait_next;
			if(queue->wait_prev==proc)queue->wait_prev=(PROC*)queue;

			/* Add process to schedule */
			add_to_schedule(proc);
		}
	}
	exit_spinlock(&queue->gate);
}


/*
 * ޡԤ
 * parameters : ޡ߹¤,(ms)
 * return : 0,ॢ-1
 */
int wait_intr(WAIT_INTR *queue,int time)
{
	queue->proc=cputask[get_current_cpu()].current_task;

	cli();
	{
		if(queue->flag==1)
		{
			queue->flag=0;
			sti();
			return 0;
		}
		del_from_schedule(queue->proc);
		queue->flag=-1;
	}
	sti();

	sleep_task(time);

	if(queue->flag==1)queue->flag=0;

	return queue->flag;
}


/*
 * ޡԤ롣
 * parameters : ޡ߹¤
 * return : åɬ1,åʤ0
 */
int wake_intr(WAIT_INTR *queue)
{
	if(queue->flag==-1)
	{
		add_to_schedule(queue->proc);
		del_timer(queue->proc);
	}
	queue->flag=1;

	return 1;
}


/******************************************************************************************************
 *
 * System call interface
 *
 *******************************************************************************************************/

/*
 * forkλҥץΥƥȤۤ롣
 * ҥץγϥɥ쥹Ϥδؿꥢɥ쥹
 * Ҥδؿϡinterrupt.SΥƥ¸ɤ˰¸롣
 * parameters : ҥץΥåΥڡɥ쥹
 * return : ҥץΥå
 */
uint set_context(uint stack);
asm(
"set_context:"
	"movl	%esp,%edx\n"
	"andl	$0xfff,%esp\n"		/* ҥץΥåꡣ */
	"orl	4(%edx),%esp\n"
	"addl	$4,%esp\n"			/*  */
	"pushfl\n"
	"pushl	%cs\n"
	"pushl	(%edx)\n"
	"pushal\n"
	"pushl	%es\n"
	"pushl	%ds\n"
/*	"pushl	%fs\n"
	"pushl	%gs\n"*/
	"pushl	$0\n"				/* before_esp */
	"movl	%edx,%eax\n"		/* ҥץϥåͤꡣ */
	"andl	$~0xfff,%eax\n"
	"andl	$0xfff,%esp\n"
	"orl	%esp,%eax\n"		/*  */
	"movl	%edx,%esp\n"
	"ret\n"
);


/*
 * return : ƥץʤҥץID,ҥץʤ0,error=error number
 */
int sys_fork()
{
	void *stack;
	PROC *parent,*child;


	/* PROC¤ΤƤ */
	if((child=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	parent=cputask[get_current_cpu()].current_task;
	child->timer_count=0;
	child->parent=parent;
	child->child=NULL;
	if(cpy_file_struct(parent,child)==-1)
		{kfree(child);return -ENOMEM;}
	enter_spinlock(&page_table_gate);
	{
		child->brother=parent->child;
		parent->child=child;
	}
	exit_spinlock(&page_table_gate);
	child->pagedir_gate=0;

	/* Page tableƤ */
	if((child->pagedir=forkPage(parent,&stack))==NULL)
		{kfree(child);return -ENOMEM;}

	/* ҥץstack˥ƥȤꤹ */
	child->esp=set_context((uint)stack&~(PAGE_SIZE-1));
	if(get_current_task()==child)return 0;

	/* Add child process to schedule queue */
	add_proc(child);

	return (int)child;
}


int sys_exec(char *path,char *argv[],char *env[],volatile SYSCALL4_FRAME frame)
{
	enum{PARAM=sizeof(int)*4};	/* ƥॳΰο  Хȿ */

	uint entry_addr;
	OPEN_F open_f;


	if(exec_open(path,&open_f)==-1)return -1;

	/* ELFХʥΥɡ */
	if((entry_addr=loadElf(&open_f))==0)return -1;

	/* ȴĶѿ桼å˥ԡ롣 */

	/* 桼åɥ쥹򿷤åꤹ롣 */
	frame.esp=USER_ESP_BEG-PARAM;

	/* ƥॳ뤫ꥢɥ쥹򥨥ȥ꡼ɥ쥹ꤹ롣 */
	frame.eip=entry_addr;

	return 0;
}


/*
 * ڡǥ쥯ȥγ̥ץԤ
 * parameters : ƥץϤ
 */
int sys_exit(int state)
{
	PROC *proc=get_current_task();
	uint *pdir;


	/* եǥץγ */
	if(releaseFileStruct(proc->file_struct)==-1)return -1;

	/* ޡγ */

	/* 桼ڡγ */
	releaseUserPage();

	/* 塼뤫 */
	cli();
	del_from_schedule(proc);

	/* ץ¤Τγ */
	pdir=proc->pagedir;
	kfree(proc);

	/* Υ˥åơڡǥ쥯ȥ롣 */
	returnExit(pdir);

	return 0;
}
