/*
 * except.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * 㳰ϥɥ
 */


#include"lib.h"
#include"proc.h"
#include"interrupt.h"
#include"segment.h"
#include"except.h"


/*
 * 㳰ϥɥ
 * åѤޤ줿ͤɽƥɥ˥פ
 */
void tmp_except(TMP_EXCEPT_FRAME frame)
{
	if(frame.cs==KERNEL_CODE_DES)
		printk("\nException%d!\nerror=0x%x eip=0x%x cs=0x%x esp=0x%x,process=0x%x\n",
			frame.except,frame.error,frame.eip,frame.cs,&frame.user_esp,get_current_task());
	else
		printk("\nException%d!\nerror=0x%x eip=0x%x cs=0x%x esp=0x%x,ss=0x%x process=0x%x\n",
			frame.except,frame.error,frame.eip,frame.cs,frame.user_esp,frame.user_ss,cputask[get_current_cpu()].current_task);

	idle();
}


/************************************************************************************************
 *
 * ǥХå
 *
 ************************************************************************************************/

/*
 * PRIVATE
 * ǥХå쥸ؤɤ߽񤭡
 */
static inline uint readDr0()
{
	uint rest;
	
	asm volatile(
		"movl	%%dr0,%%eax"
		:"=a"(rest):
	);
	
	return rest;
}

static inline void writeDr0(uint value)
{
	asm volatile(
		"movl	%%eax,%%dr0"
		::"a"(value)
	);
}

static inline void writeDr6(uint value)
{
	enum{DR6_RESERVE_BIT=0xffff0ff0,};	/* DR6ͽӥåȡ */
	
	value|=DR6_RESERVE_BIT;
	asm volatile(
		"movl	%%eax,%%dr6"
		::"a"(value)
	);
} 

static inline void writeDr7(uint value)
{
	enum{DR7_RESERVE_BIT=0x400,};		/* DR7ͽӥåȡ */

	value|=DR7_RESERVE_BIT;
	asm volatile(
		"movl	%%eax,%%dr7"
		::"a"(value)
	);
}


/*
 * GLOBAL
 * ǥХåϥɥ顣
 */
void debug(DEBUG_FRAME frame)
{
	if(frame.cs==KERNEL_CODE_DES)
		printk("\nBreak point trap! : break point=0x%x,eip=0x%x,cs=0x%x,esp=0x%x,process=0x%x\n",
			readDr0(),frame.eip,frame.cs,&frame.user_esp,get_current_task());
	else
		printk("\nBreak point trap! : break point=0x%x,eip=0x%x,cs=0x%x,esp=0x%x,process=0x%x\n",
			readDr0(),frame.eip,frame.cs,frame.user_esp,get_current_task());
	
	/* ǥХå쥸Υꥻåȡ */
	writeDr7(0);
	writeDr6(0);
	
	idle();
}


/*
 * GLOBAL
 * ǥХåꡣ1ĤΥ֥졼ݥȤΤꡣ
 * parameters : ֥졼ݥȥ˥ɥ쥹,֥졼
 */
void setDebug(uint break_addr,int condition)
{
	enum{		
		DR7_LEGE_BIT=0x300,			/* DR7 LEGEӥåȡ */
		DR7_LEN0_1BYTE=0x0,			/* DR7 LEN0 1ХĹ */
		DR7_LEN0_4BYTE=0xc0000,		/* DR7 LEN0 4ХĹ */
		DR7_G0_BIT=0x2,				/* DR7 DR0 global break enableӥåȡ */
	};

	cli();

	/* ֥졼ݥȤꡣ */
	writeDr0(break_addr);

	/* ꡣ */
	if(condition==DEBUG_EXEC)
	{	
		condition<<=16;
		condition|=DR7_LEN0_1BYTE;
	}
	else if((condition==DEBUG_WRITE)||(condition==DEBUG_RW))
	{
		condition<<=16;
		condition|=DR7_LEN0_4BYTE;
	}
	else return;
	condition|=DR7_LEGE_BIT|DR7_G0_BIT;
	writeDr7(condition);
	
	sti();
}


/************************************************************************************************
 *
 * ؿ
 *
 ************************************************************************************************/

/*
 * Init exception
 */
void init_except()
{
	set_idt(0,except0,IDT_INTR);
	set_idt(1,except1,IDT_INTR);
	set_idt(2,except2,IDT_INTR);
	set_idt(3,except3,IDT_INTR);
	set_idt(4,except4,IDT_INTR);
	set_idt(5,except5,IDT_INTR);
	set_idt(6,except6,IDT_INTR);
	set_idt(7,except7,IDT_INTR);
	set_idt(8,except8,IDT_INTR);
	set_idt(9,except9,IDT_INTR);
	set_idt(10,except10,IDT_INTR);
	set_idt(11,except11,IDT_INTR);
	set_idt(12,except12,IDT_INTR);
	set_idt(13,except13,IDT_INTR);
	set_idt(14,except14,IDT_TRAP);
	set_idt(15,except15,IDT_INTR);
	set_idt(16,except16,IDT_INTR);
	set_idt(17,except17,IDT_INTR);
	set_idt(18,except18,IDT_INTR);
}
