/*
 * proc.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץط
 */


#include"types.h"
#include"mm.h"
#include"fs.h"
#include"errno.h"
#include"interrupt.h"
#include"lock.h"
#include"segment.h"
#include"time.h"
#include"elf.h"
#include"proc.h"
#include"except.h"
#include"test.h"


/* tssǼ¤(104Х) */
typedef struct{
	uint link,esp0,ss0,esp1,ss1,esp2,ss2,cr3,eip,eflags,eax,ecx,
		edx,ebx,esp,ebp,esi,edi,es,cs,ss,ds,fs,gs,ldts,tflag_iomap;
}TSS;


CPU cputask[MAX_CPU];		/* Task infomations for each cpu */

/* TSS󥰻Υååɬ */
static TSS kernel_tss={
	0,
	KERNEL_ESP_BEG,		/* esp0 */
	KERNEL_DATA_DES,	/* ss0 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
static PROC *idle_proc[MAX_CPU];	/* Idle process */
static CPU guard[2]={				/* Guard for link */
	{0,NULL,0,NULL,NULL},
	{0,NULL,~0,NULL,NULL}
};
static int cputask_gate=0;			/* Lock gate for cputask[] */
static int few_task_cpu=0;			/* ΰ־ʤcpu */


/******************************************************************************************************
 *
 * 塼ط
 *
 *******************************************************************************************************/


/*
 * GLOBAL
 * Add task to shedule
 * parameters : Process
 */
void add_to_schedule(PROC *proc)
{
	int eflag;
	int cpu;
	PROC *p;


	cpu=proc->cpu;

	enterCli(&eflag);
	enter_spinlock(&cputask[cpu].gate);
	{
		if(proc->state!=TASK_RUNNING)
		{
			if(cputask[cpu].current_task==idle_proc[cpu])
			{
				if(idle_proc[cpu]->next==idle_proc[cpu])
				{
					proc->next=proc;
					proc->prev=proc;
					idle_proc[cpu]->next=proc;
				}
				else
				{
					p=idle_proc[cpu]->next;
					proc->next=p;
					proc->prev=p->prev;
					p->prev->next=proc;
					p->prev=proc;
				}
			}
			else
			{
				/*ߥ󥯤ƤȤ롣*/
				proc->prev->next=proc->next;
				proc->next->prev=proc->prev;

				/* ȥץμ˲ä */
				p=cputask[cpu].current_task;
				proc->prev=p;
				proc->next=p->next;
				p->next->prev=proc;
				p->next=proc;
			}

			proc->state=TASK_RUNNING;
		}
	}
	exit_spinlock(&cputask[cpu].gate);
	exitCli(&eflag);
}


/*
 * GLOBAL
 * Delete process
 * parameters : process
 */
void del_from_schedule(PROC *proc)
{
	int eflag;
	int cpu;


	cpu=proc->cpu;

	/* Delete current task */
	enterCli(&eflag);
	enter_spinlock(&cputask[cpu].gate);
	{
		if(proc->next==proc)
		{
			idle_proc[cpu]->next=idle_proc[cpu];
			idle_proc[cpu]->prev=idle_proc[cpu];
			proc->next=idle_proc[cpu];
		}
		else
		{
			proc->prev->next=proc->next;
			proc->next->prev=proc->prev;
		}

		proc->state=TASK_WAIT;
	}
	exit_spinlock(&cputask[cpu].gate);
	exitCli(&eflag);
}


/*
 * GLOBAL
 * Process switch
 * parameters : γ߻Υ֥åȥåesp,γ߻espͤ¸륹å
 * returns : Page directory
 */
uint *switch_task(uint esp,volatile uint before_esp)
{
	uint volatile *pbefore_esp=&before_esp;
	uint volatile *pesp=&esp;
	int cpu;
	PROC *current;


	cpu=get_current_cpu();
	current=cputask[cpu].current_task;
	*pbefore_esp=current->esp;
	current->esp=esp;

	current=current->next;
	*pesp=(uint)&current->esp;
	cputask[cpu].current_task=current;

	return getPageDir(current->mm_struct);
}


/******************************************************************************************************
 *
 * ץ
 *
 *******************************************************************************************************/

/*
 * Change cpu struct link to previous
 * parameters : cpu number
 * retuuns : Top link cpu number
 */
static int change_cpu_link(int cpu)
{
	CPU *p;


	enter_spinlock(&cputask_gate);
	{
		/* to previous */
		if(cputask[cpu].proc_num<cputask[cpu].prev->proc_num)
		{
			for(p=cputask[cpu].prev->prev;cputask[cpu].proc_num<p->proc_num;p=p->prev);
			cputask[cpu].prev->next=cputask[cpu].next;
			cputask[cpu].next->prev=cputask[cpu].prev;
			cputask[cpu].prev=p;
			cputask[cpu].next=p->next;
			p->next->prev=&cputask[cpu];
			p->next=&cputask[cpu];
		}
		/* to next */
		else if(cputask[cpu].proc_num>cputask[cpu].next->proc_num)
		{
			for(p=cputask[cpu].next->next;cputask[cpu].proc_num>p->proc_num;p=p->next);
			cputask[cpu].prev->next=cputask[cpu].next;
			cputask[cpu].next->prev=cputask[cpu].prev;
			cputask[cpu].prev=p->prev;
			cputask[cpu].next=p;
			p->prev->next=&cputask[cpu];
			p->prev=&cputask[cpu];
		}
	}
	exit_spinlock(&cputask_gate);

	return guard[0].next->cpu;
}


/*
 * ץ¹Բǽˤ
 * parameters : process
 */
void addNewProc(PROC *proc)
{
	proc->cpu=few_task_cpu;
	proc->state=TASK_WAIT;
	add_to_schedule(proc);
	++cputask[few_task_cpu].proc_num;

	/* Change cpu in which minimum numbers of task */
	few_task_cpu=change_cpu_link(few_task_cpu);
}


/******************************************************************************************************
 *
 * Task wait
 *
 *******************************************************************************************************/


/*
 * Wait process
 * ñ
 * parameters : Wait queue
 */
void wait_proc(WAIT_QUEUE *queue)
{
	PROC *proc;


	enter_spinlock(&queue->gate);
	{
		if(queue->flag==0)
		{
			queue->flag=1;
			exit_spinlock(&queue->gate);

			return;
		}
		else
		{
			proc=get_current_task();

			/* Add process to wait queue */
			queue->wait_prev->wait_next=proc;
			proc->wait_next=(PROC*)queue;
			queue->wait_prev=proc;

			cli();
			del_from_schedule(proc);
		}
	}
	exit_spinlock(&queue->gate);
	sti();

	wait_task();
}


/*
 * Wake up process
 * parameters : Wait queue
 */
void wake_proc(WAIT_QUEUE *queue)
{
	PROC *proc;


	/* Delete process from wait queue */
	enter_spinlock(&queue->gate);
	{
		if(queue->wait_prev!=(PROC*)queue)
		{
			proc=queue->wait_next;
			queue->wait_next=proc->wait_next;
			proc->wait_next->wait_prev=(PROC*)queue;

			/* Add process to schedule */
			add_to_schedule(proc);
		}
		else queue->flag=0;
	}
	exit_spinlock(&queue->gate);
}


/*
 * ޡԤ
 * parameters : ޡ߹¤,(ms)
 * return : 0,ॢ-1
 */
int wait_intr(WAIT_INTR *queue,int time)
{
	queue->proc=cputask[get_current_cpu()].current_task;

	cli();
	{
		if(queue->flag==1)
		{
			queue->flag=0;
			sti();
			return 0;
		}
		del_from_schedule(queue->proc);
		queue->flag=-1;
	}
	sti();

	sleep_task(time);

	if(queue->flag==1)queue->flag=0;

	return queue->flag;
}


/*
 * ޡԤ롣
 * parameters : ޡ߹¤
 * return : åɬ1,åʤ0
 */
int wake_intr(WAIT_INTR *queue)
{
	if(queue->flag==-1)
	{
		add_to_schedule(queue->proc);
		del_timer(queue->proc);
	}
	queue->flag=1;

	return 1;
}


/******************************************************************************************************
 *
 * System call interface
 *
 *******************************************************************************************************/

/*
 * return : ƥץʤҥץID,ҥץʤ0,error=error number
 */
int sys_fork()
{
	void *stack;
	uint esp;
	PROC *parent,*child;


	parent=cputask[get_current_cpu()].current_task;
	if(parent->count_child>=MAX_CHILD)return -EAGAIN;

	/* PROC¤ΤƤ */
	if((child=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	memset(child,0,sizeof(PROC));
	child->parent=parent;
	child->brother=parent->child;
	parent->child=child;
	child->uid=parent->uid;
	child->gid=parent->gid;

	/* եط¤Τγơ */
	if(cpy_file_struct(parent,child)==-1)goto ERR;

	/* Page tableƤ */
	if((child->mm_struct=forkPage(parent->mm_struct,&stack))==NULL)goto ERR;

	/* ҥץstack˥ƥȤꤹ */
	if((esp=setContext((uint)stack))==0)return 0;		/* ҥץ */
	child->esp=esp;

	/* Add child process to schedule queue */
	addNewProc(child);

	++parent->count_child;

	return (int)child;

ERR:
	kfree(child);

	return -ENOMEM;
}


int sys_exec(const char *path,char **argv,char **envp,volatile SYSCALL4_FRAME frame)
{
	enum{PARAM=sizeof(int)*4};	/* ƥॳΰο  Хȿ */

	uint entry_addr,stack_esp;
	int rest;
	OPEN_F open_f;
	SYS_INFO *sys_info;


	if((rest=exec_open(path,&open_f))<0)return rest;

	/* ȴĶѿ桼å˥ԡ롣 */
	if((stack_esp=setArgAndEnv(argv,envp))==0)return -1;

	/* 桼ڡ롣 */
	releaseUserTextDataPage(get_current_task()->mm_struct);

	/* ELFХʥΥɡ */
	if((entry_addr=loadElf(&open_f))==0)return -1;

	/* å˥ƥꡣ */
	sys_info=(SYS_INFO*)(USER_ESP_BEG-sizeof(SYS_INFO));
	sys_info->lastAddr=getLastLinearAddr();

	/* ʥ륢ν */

	/* ƥॳե졼ꡣ */
	frame.es=USER_DATA_DES;
	frame.ds=USER_DATA_DES;
	frame.eip=entry_addr;
	frame.cs=USER_CODE_DES;
	frame.esp=stack_esp-PARAM;
	frame.ss=USER_DATA_DES;

	return 0;
}


/*
 * ڡǥ쥯ȥγ̥ץԤ
 * parameters : ƥץϤ
 */
int sys_exit(int state)
{
	void *mm_struct;
	PROC *proc=get_current_task();


	/* եǥץγ */
	releaseFileStruct(proc->file_struct);

	/* ޡγ */

	/* 塼뤫 */
	cli();
	del_from_schedule(proc);

	/* ץ¤Τγ */
	mm_struct=proc->mm_struct;
	kfree(proc);

	/* Υ˥åơڡǥ쥯ȥ롣 */
	returnExit(mm_struct);

	return 0;
}


/******************************************************************************************************
 *
 * 
 *
 *******************************************************************************************************/

/*
 * Init taskcpu
 * cpu˥ꥢꤹɬפ
 * parameters : number of cpu
 * returns : NOERROR
 */
int init_cputask(int cpu)
{
	cputask[cpu].cpu=cpu;
	cputask[cpu].current_task=NULL;
	cputask[cpu].proc_num=0;
	cputask[cpu].gate=0;
	cputask[cpu].next=&guard[1];
	guard[1].prev=&cputask[cpu];
	if(cpu==0)
	{
		cputask[cpu].prev=&guard[0];
		guard[0].next=&cputask[cpu];
	}
	else
	{
		cputask[cpu].prev=&cputask[cpu-1];
		cputask[cpu-1].next=&cputask[cpu];
	}

	return 0;
}


/*
 * TSSǥץꤹ
 *  : ǥץ͡TSSɥ쥹
 */
void set_tss(int des)
{
	set_gdt(des,&kernel_tss,104,TYPE_TSS);

	asm volatile(
		"movl	%0,%%eax\n"
		"ltr	%%ax"
		::"m"(des)
	);
}


/*
 * Set idle process table
 * parameters : Page directory
 * returns : 0 or Error number
 */
int set_idle_proc(int cpu)
{
	/* Set process table */
	if((idle_proc[cpu]=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	memset(idle_proc[cpu],0,sizeof(PROC));
	idle_proc[cpu]->next=idle_proc[cpu];
	idle_proc[cpu]->prev=idle_proc[cpu];
	idle_proc[cpu]->cpu=cpu;
	idle_proc[cpu]->state=TASK_RUNNING;

	/* init paging */
	if((idle_proc[cpu]->mm_struct=initPaging())==NULL)return -1;

	if(init_file_struct(idle_proc[cpu])==-1)return -ENOMEM;

	/* add to schedule queue */
	cputask[cpu].current_task=idle_proc[cpu];

	return 0;
}
/*************************************************************************************************/
void test_proc()
{
	PROC *proc=get_current_task();
	PROC *p;

	p=proc;
	do
	{
		printk("proc=%x\n",p);
		p=p->next;
	}while(p!=proc);
}
/**************************************************************************************************/
