/*
 * fcntl.h
 */


#ifndef share_fcntl_h
#define share_fcntl_h


#ifndef ASM_FILE


enum{
	/* File access modes used for open() and fcntl(). */
	O_RDONLY=0x1,		/* Open for reading only. */
	O_RDWR=0x2,			/* Open for reading and writing. */
	O_WRONLY=0x4,		/* Open for writing only. */

	/* Flags and are used in the oflag value to open(). They shall be bitwise-distinct. */
	O_CREAT=0x8,		/* Create file if it does not exist. */
	O_EXCL=0x10,		/* Exclusive use flag. */
	O_NOCTTY=0x20,		/* Do not assign controlling terminal. */
	O_TRUNC=0x40,		/* Truncate flag. */

	/* File status flags used for open() and fcntl(). */
	O_APPEND=0x80,		/* Set append mode. */
	O_NONBLOCK=0x100, 	/* Non-blocking mode. */
};


#endif


#endif
