/*
 * fs.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef fs_h
#define fs_h


#include"types.h"
#include"proc.h"
#include"user/include/share/fcntl.h"
#include"user/include/share/unistd.h"
#include"user/include/share/stat.h"
#include"user/include/share/dirent.h"


#ifndef ASM_FILE


enum{
	/* File type */
	NORMAL_FILE=1,
	DIRECTORY=2,
	SYMBOL_LINK=3,
	DEVICE_FILE=4,
};


/* fstatѥե¤Ρ */
typedef struct stat FSTAT;

/* ե륷ƥ।ե᡼¤ */
typedef struct FS{
	const char *name;
	uint (*mount)(int);							/* prm:device inode ret:root directory block or error=0 */
	int (*umount)(int);							/* prm:device inode ret:0 or error=-1 */
	int (*open)(const char*,int,uint,int);		/* prm:path,device inode,directory inode,flag ret:inode block or error number */
	int (*close)(int,uint);						/* prm:device inode,inode ret:0 or error=-1 */
	int (*read)(int,uint,void*,size_t,size_t);	/* prm:device inode,inode,bffer,read bytes,begin byte ret:read bytes or error=-1 */
	int (*write)(int,uint,void*,size_t,size_t);	/* prm:device inode,inode,bffer,write bytes,begin byte ret:write bytes or error=-1 */
	int (*ioctr)(int,uint,int,void*);			/* prm:device inode,inode,command,parameter ret:0 or error=-1 */
	int (*rename)(int,uint,const char*,uint,const char*);	/* prm:device inode,old dir inode,old path,new dir inode,new path ret:0 or error number */
	int (*creat)(const char*,int,uint,int);		/* prm:path,device inode,directory inode,mode ret:directory block or error=0 */
	int (*opendir)(const char*,int,uint,DIR*);	/* prm:path,device inode,directory inode,DIR struct ret:inode block or error number */
	int (*mkdir)(const char*,int,uint,int);		/* prm:path,device inode,parent directory block,mode ret:directory block or error=0 */
	int (*stat)(uint,const char*,int,uint,FSTAT*);		/* prm:inode,path,device inode,directoru inode,FSTAT buffer ret:0 or error number */
	int (*delete)(const char*,int,uint,int);	/* prm:path,device inod,directory block,file type ret:0 or error number */
	int (*readdir)(int,uint,DIR*,char*);		/* prm:device inode,inode,DIR struct,name buffer ret:0 or error number */
	struct FS *next;
}FS;

/* ۥȥ꡼ */
typedef struct VENTRY{
	struct VENTRY *next;		/* 饦ɥ󥯥ꥹȥͥ */
	struct VENTRY *prev;		/* 饦ɥ󥯥ꥹȥץӥ塼 */
	uint block;					/* ǥХ֥å */
	struct VENTRY *parent;		/* ƥȥ꡼ */
	struct VENTRY *child;		/* ΥΡɤΥȥåץȥ꡼ */
	struct VENTRY *mount;		/* ޥȥȥ꡼ */
	FS *fs;						/* Filesystem. */
	int busy;					/* busy flag. */
	uchar refCount;				/* ȥ󥿡ޥȤ䥫ȥǥ쥯ȥ¹ԥե¹ԥ */
	uchar din;					/* ǥХinode */
	uchar type;					/* ե륿 */
	uchar len;					/* Name size. */
	char name[0];				/* ѥ͡ */
}VENTRY;

/* եǥץ */
typedef struct{
	ushort refCount;	/* ȥȡ */
	ushort accessMode;	/* Access mode. */
	size_t offset;		/* ɤ߽񤭳ϥեåȡ */
	VENTRY *vent;		/* ۥȥ꡼ */
}F_DSC;

/* ץѥե빽¤ */
typedef struct{
	VENTRY *current_dir;		/* ȥǥ쥯ȥꡣ */
	F_DSC *fd[MAX_FILE_OPEN];
	uchar flag[MAX_FILE_OPEN];	/* եǥץե饰 */
	uchar fd_count;				/* եǥץץ */
	uchar next_fd;				/* ζեǥץ */
}FILE_STRUCT;

/* ե륪ץؿѹ¤ */
typedef struct{
	VENTRY *vent;		/* ۥȥ꡼ */
	size_t offset;		/* ɤ߽񤭳ϥեå */
}OPEN_F;


extern FS *fs_info[];


/*
 * ʸNULLʸޤӤפХȿ֤
 * parameters : Destination string,Sorce string
 */
extern inline int cmpString(const char *str1,const char *str2)
{
	int i;


	for(i=0;str1[i]&str2[i];++i)
		if(str1[i]!=str2[i])break;

	return i;
}


/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or ԰=NULL;
 */
extern inline const char *cmpPathNull(const char *path1,const char *path2)
{
	while(*path1==*path2++)
		if(*path1++=='\0')return path2-1;

	if((*(path2-1)=='/')&&(*path1=='\0'))return path2;
	else return NULL;
}

/*
 * ̾ʸȥѥʸӤ롣
 * parameters : destination name string,sorce path string,ӥХȿ
 * return : =0 or 礭=1 or =-1
 */
extern inline int cmpPathLength(const char *name,const char *path,int count)
{
	int i;


	for(i=0;i<count;++i)
		if(name[i]!=path[i])
		{
			if((uchar)name[i]>(uchar)path[i])return 1;
			else return -1;
		}

	if((path[count]=='/')||(path[count]=='\0'))return 0;

	return -1;
}

/*
 * ̾ʸȥѥʸӤ롣
 * פ˼Υѥɥ쥹롣
 * parameters : destination name string,sorce path string pointer
 * return : =0 or 礭=1 or =-1
 */
extern inline int cmpPath(const char *name,const char **path)
{
	const char *p=*path;


	while(*name==*p++)
		if(*name++=='\0')
		{
			*path=p-1;
			return 0;
		}

	if((*--p=='/')&&(*name=='\0'))
	{
		*path=p+1;
		return 0;
	}
	if(*name>*p)return 1;
	return -1;
}

/*
 * ѥʸ󥵥Ϥ롣
 * parmeters : path
 */
extern inline size_t pathLen(const char *path)
{
	const char *p=path;


	while(*p++!='/')
		if(*p=='\0')return (size_t)(p-path);

	return (size_t)(p-path-1);
}

/*
 * ѥ饹ȥѥɤȽꤹ롣
 * parameters : path
 * return : name size or failed=-1;
 */
extern inline int isLastPath(const char *path)
{
	int i;


	for(i=0;path[i]!='\0';++i)
		if(path[i]=='/')return -1;

	return i;
}

extern void initExecFs();
extern void init_fs();
extern int mount_dev_fs(FS*);
extern int regist_fs(FS*);
extern FILE_STRUCT *cpy_file_struct(FILE_STRUCT*);
extern void releaseFileStruct(FILE_STRUCT*);
extern int init_file_struct(PROC*);
extern int initProc0Fs();
extern int get_inode(int);
extern int mountRoot(const char*,const char*);
extern int mountPageBackupDev(const char*);
extern int exec_open(const char*,OPEN_F*);
extern int exec_read(OPEN_F*,void*,size_t);
extern int sys_open();
extern int sys_close();
extern int sys_read();
extern int sys_write();
extern int sys_ioctr();
extern int sys_lseek();
extern int sys_mkdir();
extern int sys_creat();
extern int sys_rename();
extern int sys_unlink();
extern int sys_rmdir();
extern int sys_lock();
extern int sys_mount();
extern int sys_umount();
extern int sys_opendir();
extern int sys_closedir();
extern int sys_readdir();
extern int sys_chdir();
extern int sys_getcwd();
extern int sys_stat();
extern int sys_umount_root();
extern int sys_fcntl();


#endif


#endif
