/*
 * lib.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥ饤֥꡼
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"time.h"
#include"console.h"
#include"mm.h"


int (*write_tty)(void*,size_t,size_t);


/*
 * ̽ϴؿ
 *  : ʸ(%d,%u,%x,%sб)...
 */
void printk(const char *str,...)
{
	enum{
		BUF_SIZE=240,
		TMP_BUF_SIZE=12,
	};

	char buf[BUF_SIZE];
	char tmp_buf[TMP_BUF_SIZE];
	uint *arg=(uint*)&str+1;
	int ivalue;
	uint uvalue;
	int i,j,size;


	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			switch(*++str)
			{
				case 'd':		/* Ѵ */
					ivalue=*arg++;
					if(ivalue>=0)
						for(j=TMP_BUF_SIZE-1;;--j)
						{
							tmp_buf[j]=ivalue%10+'0';
							if(!(ivalue/=10))break;
						}
					else
						for(j=TMP_BUF_SIZE-1;;--j)
						{
							tmp_buf[j]=(ivalue%10)*-1+'0';
							if(!(ivalue/=10))
							{
								tmp_buf[--j]='-';
								break;
							}
						}

					size=TMP_BUF_SIZE-j;
					if(size>=(BUF_SIZE-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 'u':		/* ̵Ѵ */
					uvalue=*arg++;
					for(j=TMP_BUF_SIZE-1;;--j)
					{
						tmp_buf[j]=uvalue%10+'0';
						if(!(uvalue/=10))break;
					}

					size=TMP_BUF_SIZE-j;
					if(size>=(BUF_SIZE-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 'x':		/* 16ʿѴ */
					uvalue=*arg++;
					for(j=TMP_BUF_SIZE-1;;--j)
					{
						tmp_buf[j]=uvalue%16+'0';
						if(tmp_buf[j]>'9')tmp_buf[j]+='a'-'9'-1;
						if(!(uvalue/=16))break;
					}

					size=TMP_BUF_SIZE-j;
					if(size>=(BUF_SIZE-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 's':		/* ʸɽ */
					size=strlen((char*)*arg);
					if(size>=(BUF_SIZE-i))goto END;
					memcpy(&buf[i],(void*)*arg,size);
					++arg;
					i+=size;
					break;

				case '%':
					if((BUF_SIZE-i)<=1)goto END;
					buf[i++]='%';
					break;

				default:
					if((BUF_SIZE-i)<=2)goto END;
					buf[i++]='%';
					buf[i++]=*str;
			}
		}
		else buf[i++]=*str;
	}

END:
	write_tty(buf,i,0);
}


/*
 * micro seccond ޡ
 *  : (1microseccondñ)
 */
void micro_timer(uint count)
{
	uint64 end;


	end=rdtsc();
	end+=count*clock_1micro;
	while(rdtsc()<end);
}


/*
 * mili seccond timer
 * param : value of counts(1ms)
 */
void mili_timer(uint count)
{
	uint64 end;


	end=rdtsc();
	end+=count*clock_1m;
	while(rdtsc()<end);
}


/*
 * Convert ascii to integer
 * parameters : string
 * return : integer or 0(Ǥʤ)
 */
int atoi(const char *str)
{
	int rest=0;


	for(;*str!='\0';++str)
	{
		if((*str<'0')||(*str>'9'))return 0;
		rest=rest*10+*str-'0';
	}

	return rest;
}
