/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include"segment.h"
#include"user/include/share/wait.h"


#ifndef ASM_FILE


enum{
	MAX_CHILD=8,		/* Max number of child processes */

	/* ץξ֡ */
	TASK_RUNNING=1<<0,
	TASK_WAIT=1<<1,
	TASK_DEVICE_WAIT=1<<2,	/* ǥХԤ */
	TASK_SIGNAL_WAIT=1<<3,	/* ʥԤ */
	TASK_TRACE=1<<4,		/* ȥ졼档 */
	TASK_EXIT=1<<5,			/* Exit. */
};


#define PROC_ZERO_TOP child			/* 0λϤǡ */
#define PROC_ZERO_END cpu			/* 0κǸμǡ */

/* ץ¤ */
typedef struct PROC{
	struct PROC *next;			/* Schedule linkμΥץ */
	struct PROC *prev;			/* Schedule linkΥץ */
	struct PROC *wait_next;		/* next link for wait */
	struct PROC *wait_prev;		/* prev link for wait */
	struct PROC *proc_next;		/* Process list link next. */
	struct PROC *proc_prev;		/* Process list link prev. */
	uint esp;					/* ֤ƥȤΥåȥåesp */
	struct PROC *parent;		/* Parent process. */
	struct PROC *brother;		/* Brother process */
	struct PROC *child;			/* Child process */
	ushort count_child;			/* Number of child processes */
	ushort lock_flag;			/* Lock flag. */
	uchar exit_state;			/* Exit state. */
	uchar signum;				/* Exit signal number. */
	uchar cpu;					/* running cpu number ƯƤʤ-1ʲ*/
	uchar state;				/* ץξ֡ */
	int pid;					/* process ID. */
	int gid;					/* groupe ID. */
	int uid;					/* user ID. */
	void *timer_struct;			/* ޡ¤Ρ */
	void *signal_struct;		/* ʥ¤Ρ */
	void *mm_struct;			/* ꡼¤Υɥ쥹 */
	void *file_struct;			/* ե빽¤Υɥ쥹 */
}PROC;

/* ץꥹȹ¤Ρ */
typedef struct PROC_LIST{
	struct PROC_LIST *next;
	struct PROC_LIST *prev;
	int lockGate;
}PROC_LIST;

/* ץ󥯹¤ */
typedef struct PROC_LINK{
	struct PROC_LINK *next;
	struct PROC_LINK *prev;
}PROC_LINK;

/* ץȥå塼¤ */
typedef struct WAIT_QUEUE{
	void *wait_next;			/* ȥ󥯤μΥץ */
	void *wait_prev;			/* ȥ󥯤Υץ */
	int flag;					/* Wait flag */
	int gate;					/* Lock gate */
}WAIT_QUEUE;

/* ޡԤѹ¤ */
typedef struct WAIT_INTR{
	PROC *proc;					/* Ԥץ */
	int flag;					/* ॢȥե饰 */
}WAIT_INTR;

/* cpuȤΥ¤ */
typedef struct CPU{
	int cpu;				/* number of cpu */
	PROC *current_task;		/* ߤβƯprocess */
	uint proc_num;			/* ưץ */
	int gate;				/* Lock gate */
}CPU;


extern CPU cputask[];
extern PROC_LIST procHash[];


/*
 * Get current cpu number
 * returns : current cpu number
 */
extern inline int get_current_cpu()
{
	int result;


	asm volatile(
		"xorl	%%eax,%%eax\n"\
		"str	%%ax\n"\
		"subl	%1,%%eax\n"\
		"shrl	$3,%%eax"
		:"=a"(result):"i"(TSS_DES)
	);

	return result;
}

/*
 * Get current task
 * return : Current process
 */
extern inline PROC *get_current_task()
{
	return cputask[get_current_cpu()].current_task;
}

/*
 * Set/release process lock flag.
 */
extern inline void set_proc_lockflag()
{
	get_current_task()->lock_flag=1;
}

extern inline void release_proc_lockflag(PROC *proc)
{
	proc->lock_flag=0;
}



extern void add_to_schedule(PROC*,int);
extern void del_from_schedule(int);
extern PROC *searchProcList(int);
extern int *getProcListRockGate(int);
extern void waitProc0();
extern int initProc0();
extern void waitProc(PROC_LINK*,int);
extern void wakeProc(PROC_LINK*);
extern void wait_proc(WAIT_QUEUE*);
extern void wake_proc(WAIT_QUEUE*);
extern int wait_intr(WAIT_INTR*,int);
extern void wake_intr(WAIT_INTR*);
extern int init_cputask(int);
extern int set_idle_proc(int);
extern void set_tss(int);
extern void start_tasking();
extern PROC *getNextProc(int,PROC*);
extern PROC *getAllProc(PROC*);
extern void exit(int,int);
extern int sys_fork();
extern int sys_exit();
extern int sys_exec();
extern int sys_wait();
extern int sys_setgid();


#endif


#endif
