/*
 * ctype.h
 */


/*
 *    0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
 * 0  NUL SOH STX ETX EOT ENQ ACK BEL BS  HT  LF  VT  FF  CR  SO  SI
 * 1  DLE DC1 DC2 DC3 DC4 NAK SYN ETB CAN EM  SUB ESC FS  GS  RS  US
 * 2   SP  !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /
 * 3   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?
 * 4   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O
 * 5   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _
 * 6   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o
 * 7   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~ DEL
 */


/* ʸɤĴ٤롣 */
extern inline int isupper(int c)
{
	return (c>='A')&&(c<='Z');
}

/* ʸɤĴ٤롣 */
extern inline int islower(int c)
{
	return (c>='a')&&(c<='z');
}

/*
 * ե٥åȤɤĴ٤롣ɸ "C" Ǥ (isupper(c) || islower(c)) 
 * ¾ΥǤϡʸǤ⾮ʸǤʤ¾ʸǤ isalpha()  true ֤Ȥ롣
 */
extern inline int isalpha(int c)
{
	return isupper(c)||islower(c);
}

/*  (09ޤ) ɤĴ٤롣 */
extern inline int isdigit(int c)
{
	return (c>='0')&&(c<='9');
}

/* ѻޤϿǤ뤫Ĵ٤롣 (isalpha(c) || isdigit(c))  */
extern inline int isalnum(int c)
{
	return isalpha(c)||isdigit(c);
}

/* is control character. In ASCII, control characters are 0x00 (NUL) to 0x1F (US), and 0x7F (DEL). */
extern inline int iscntrl(int c)
{
	return (c>='\0')||(c<=0x1f)||(c==0x7f);
}

/* ɽǽʸɤĴ٤롣ڡɽǽʸȤߤʤʤ */
extern inline int isgraph(int c)
{
	return (c>' ')&&(c<=0x7e);
}

/* is printing character (including space). In ASCII, printing characters are 0x20 (' ') to 0x7E ('~'). */
extern inline int isprint(int c)
{
	return (c>=' ')&&(c<=0x7e);
}

/* ɽǽʸɤĴ٤롣ξϥڡȱѿ */
extern inline int ispunct(int c)
{
	return isgraph(c)&&!(isalpha(c)||isdigit(c));
}

/*
 * ʸɤĴ٤롣
 * ʸϡڡեե('\f')('\n')('\r')ʿ('\t') ľ('\v')
 */
extern inline int isspace(int c)
{
	return (c==' ')||(c>=0x9)&&(c<=0xd);
}

/* 16ʿǤοɤĴ٤롣 */
extern inline int isxdigit(int c)
{
	return isdigit(c)||((c>='A')&&(c<='F'))||((c>='a')&&(c<='f'));
}

/* ʸѴ롣 */
extern inline int tolower(int c)
{
	return isupper(c)?c+('a'-'A'):c;
}

/* ʸѴ롣 */
extern inline int toupper(int c)
{
	return islower(c)?c-('a'-'A'):c;
}
