/*
 * locale.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<limits.h>
#include<string.h>
#include<locale.h>


static struct lconv crtConve;
static char *DefLcl="C";
static char *strNull="";


struct lconv* localeconv(void)
{
	crtConve.decimal_point=".";
	crtConve.grouping=strNull;
	crtConve.thousands_sep=strNull;
	crtConve.currency_symbol=strNull;
	crtConve.int_curr_symbol=strNull;
	crtConve.mon_decimal_point=strNull;
	crtConve.mon_grouping=strNull;
	crtConve.mon_thousands_sep=strNull;
	crtConve.negative_sign=strNull;
	crtConve.positive_sign=strNull;
	crtConve.frac_digits=CHAR_MAX;
	crtConve.int_frac_digits=CHAR_MAX;
	crtConve.n_cs_precedes=CHAR_MAX;
	crtConve.n_sep_by_space=CHAR_MAX;
	crtConve.n_sign_posn=CHAR_MAX;
	crtConve.p_cs_precedes=CHAR_MAX;
	crtConve.p_sep_by_space=CHAR_MAX;
	crtConve.p_sign_posn=CHAR_MAX;

	return &crtConve;
}


char* setlocale(int category, const char* locale)
{
	if(locale==NULL)return DefLcl;
	if(strcmp(DefLcl,locale)!=0)return NULL;
	if((category<LC_ALL)||(category>LC_TIME))return NULL;
	return DefLcl;
}
