/*
 * stdio.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<string.h>
#include<stdarg.h>
#include<system.h>
#include<errno.h>
#include<stdio.h>


/**************** ǥХå ****************************
static int cnv(uint uvalue,char *buf)
{
	enum{BUF_SIZE=8};
	int i;
	

	for(i=BUF_SIZE-1;;--i)
	{
		buf[i]=uvalue%16+'0';
		if(buf[i]>'9')buf[i]+='a'-'9'-1;
		if(!(uvalue/=16))break;
	}
	memcpy(buf,&buf[i],BUF_SIZE-i);
	
	return BUF_SIZE-i;
}
********************************************************/


/***************************************************************************
 *
 * ʸϴؿ
 *
 ***************************************************************************/

enum{
	/* IA32ưեޥåȡ */
	SIGN_BIT=63,		/* +-ӥåȰ֡ */
	EXP_BIT=52,			/* ؿӥåȰ֡ */
	MAX_DIGIT=20,		/* ͺ */
	EXP_BASE=0x3ff,		/* ؿ0 */
};


/*
 * PRIVATE
 * ưeʸѴ롣
 * parameters : ư,̳ǼʸХåե,ٷ,eʸ
 * return : Ѵʸ
 */
static int dtoe(double value,char *str_buf,int sdigit,int cnv)
{
	char tmpstr[MAX_DIGIT];
	char *buf=str_buf;
	int sign,sign10;
	int exp,exp10;
	unsigned long long *vl=(unsigned long long*)&value;
	unsigned long long tmp,log10;
	int i;


	sign=*vl>>SIGN_BIT;				/* +-. */
	exp=(*vl>>EXP_BIT)&0x7ff;		/* ؿ͡ */

	*vl&=~((long long)1<<SIGN_BIT);		/* clear sign bit. */

	/* 10Ȥؿͤ׻ */
	if(exp<EXP_BASE)
	{
		tmp=(unsigned long long)2<<(EXP_BASE-exp);
		log10=10;
		for(i=0;(tmp/=10)!=0;++i)log10*=10;
		value*=log10;
		sign10='-';
		if(value<10)
		{
			exp10=i+1;
			log10=10;
		}
		else
		{
			exp10=i;
			log10=1;
		}
	}
	else
	{
		tmp=(unsigned long long)2<<(exp-EXP_BASE);
		log10=1;
		for(i=0;(tmp/=10)>=10;++i)log10*=10;
		value/=log10;
		sign10='+';
		if(value<10)
		{
			exp10=i;
			log10=10;
		}
		else
		{
			exp10=i+1;
			log10=1;
		}
	}

	/* ͤ׻ */
	for(i=0;i<sdigit;++i)log10*=10;		/* +sdigitʬ10**sdigit */
	value*=(double)log10;
	tmp=(long long)value;
	tmp+=5;								/* ͼθ */

	/* 10ʸѴ */
	if(sign)*buf++='-';
	i=0;
	do
	{
		tmpstr[i++]=tmp%10+'0';
	}while((tmp/=10)!=0);
	*buf++=tmpstr[--i];
	*buf++='.';
	while(--i>0)*buf++=tmpstr[i];
	*buf++=cnv;
	*buf++=sign10;
	*buf++=exp10/10+'0';
	*buf++=exp10%10+'0';

	return (int)buf-(int)str_buf;
}


/*
 * PRIVATE
 * ưfʸѴ롣
 * parameters : ư,̳ǼʸХåե,
 * return : Ѵʸ
 */
static int dtof(double value,char *str_buf,int sdigit)
{
	char tmpstr[MAX_DIGIT];
	char *buf=str_buf;
	int sign,exp;
	unsigned long long *vl=(unsigned long long*)&value;
	unsigned long long integer,log10;
	int i;


	sign=*vl>>SIGN_BIT;				/* +-. */
	exp=(*vl>>EXP_BIT)&0x7ff;		/* ؿ͡ */

	*vl&=~((long long)1<<SIGN_BIT);		/* clear sign bit. */

	/* 10**(sdigit+1) */
	log10=10;
	for(i=0;i<sdigit;++i)log10*=10;
	value*=log10;
	integer=(long long)value;
	integer=(integer+5)/10;							/* ͼθ */

	/* 10ʸѴ */
	if(sign)*buf++='-';
	i=0;
	do
	{
		tmpstr[i++]=integer%10+'0';
	}while((integer/=10)!=0);

	if(i<=sdigit)
	{
		*buf++='0';
		*buf++='.';
		memset(buf,'0',sdigit-1);
		buf+=sdigit-1;
		while(--i>=0)buf[-i]=tmpstr[i];
		++buf;
	}
	else
	{
		while(--i>=0)
		{
			*buf++=tmpstr[i];
			if(i<=sdigit)
			{
				*buf++='.';
				break;
			}
		}
		while(--i>=0)*buf++=tmpstr[i];
	}

	return (int)buf-(int)str_buf;
}


/*
 * PRIVATE
 * ʸѴƥХåե¸롣
 * parameters :
 * return : converted string size
 */
static int convertString(const char *str,char *buf,int buf_size,uint *arg)
{
	enum{BUF_SIZE=12};

	char tmp_buf[BUF_SIZE];
	int ivalue;
	uint uvalue;
	double *dvalue;
	int i,j,size;


	if(buf_size==0)return 0;

	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			switch(*++str)
			{
				case 'd':		/* Ѵ */
					ivalue=*arg++;
					if(ivalue>=0)
						for(j=BUF_SIZE-1;;--j)
						{
							tmp_buf[j]=ivalue%10+'0';
							if(!(ivalue/=10))break;
						}
					else
						for(j=BUF_SIZE-1;;--j)
						{
							tmp_buf[j]=(ivalue%10)*-1+'0';
							if(!(ivalue/=10))
							{
								tmp_buf[--j]='-';
								break;
							}
						}

					size=BUF_SIZE-j;
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 'u':		/* ̵Ѵ */
					uvalue=*arg++;
					for(j=BUF_SIZE-1;;--j)
					{
						tmp_buf[j]=uvalue%10+'0';
						if(!(uvalue/=10))break;
					}

					size=BUF_SIZE-j;
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 'x':		/* 16ʿѴ */
					uvalue=*arg++;
					for(j=BUF_SIZE-1;;--j)
					{
						tmp_buf[j]=uvalue%16+'0';
						if(tmp_buf[j]>'9')tmp_buf[j]+='a'-'9'-1;
						if(!(uvalue/=16))break;
					}

					size=BUF_SIZE-j;
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 's':		/* ʸɽ */
					size=strlen((char*)*arg);
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],(void*)*arg,size);
					++arg;
					i+=size;
					break;

				case 'f':
					dvalue=(double*)arg;
					i+=dtof(*dvalue,&buf[i],6);
					arg+=2;
					break;
				
				case 'e':
				case 'E':
					dvalue=(double*)arg;
					i+=dtoe(*dvalue,&buf[i],6,*str);
					arg+=2;
					break;

				case '%':
					if((buf_size-i)<=1)goto END;
					buf[i++]='%';
					break;

				default:
					if((buf_size-i)<=2)goto END;
					buf[i++]='%';
					buf[i++]=*str;
			}
		}
		else buf[i++]=*str;
	}

END:
	buf[i]='\0';

	return i;
}


int printf(const char *str,...)
{
	enum{BUF_SIZE=1024};

	char buf[BUF_SIZE];
	int size;


	size=convertString(str,buf,BUF_SIZE,(uint*)&str+1);

	return write(STDOUT_FILENO,buf,size);
}


/************************************************************************************/


int rename(const char *old, const char *new)
{
	int rest;


	if((rest=syscall3(SYS_RENAME,(int)old,(int)new))<0)
	{
		errno=-rest;
		return -1;
	}

	return 0;
}
