/*
 * signal.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<callgate.h>
#include<system.h>
#include<share/syscall.h>
#include<errno.h>
#include<signal.h>


int sigaction(int signum,const struct sigaction *act,struct sigaction *oldact)
{
	int rest;


	if((rest=syscall4(SYS_SIGACTION,signum,(int)act,(int)oldact))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int sigprocmask(int how,const sigset_t *set,sigset_t *oldset)
{
	int rest;


	if((rest=syscall4(SYS_SIGPROCMASK,how,(int)set,(int)oldset))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int sigpending(sigset_t *set)
{
	int rest;


	if((rest=syscall2(SYS_SIGPENDING,(int)set))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int sigsuspend(const sigset_t *mask)
{
	errno=syscall2(SYS_SIGSUSPEND,(int)mask);

	return -1;
}


int sigemptyset(sigset_t *set)
{
	*set=0;

	return 0;
}


int sigfillset(sigset_t *set)
{
	sigset_t sig;


	sig=-1;
	sig>>=sizeof(sigset_t)*8-SIG_ACTIONS;
	*set=sig;

	return 0;
}


int sigaddset(sigset_t *set,int signum)
{
	if((signum<0)&&(signum>=SIG_ACTIONS))
	{
		errno=EINVAL;
		return -1;
	}

	*set|=1<<signum;

	return 0;
}


int sigdelset(sigset_t *set,int signum)
{
	if((signum<0)&&(signum>=SIG_ACTIONS))
	{
		errno=EINVAL;
		return -1;
	}

	*set^=1<<signum;

	return 0;
}


int sigismember(const sigset_t *set,int signum)
{
	if((signum<0)&&(signum>=SIG_ACTIONS))
	{
		errno=EINVAL;
		return -1;
	}

	if(*set&(1<<signum))return 1;
	else return 0;
}
