/**
 *  mAbstractModel
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: abstractModel.js,v $ $Revision: 1.3 $ $Date: 2006/11/13 09:26:01 $
 * 
 *  @requires mUtils
 *  @requires mAction
 *  @member   mAction
**/
mAbstractModel = function()
{
 /**
  *  mDataObject
  * 
  *  @private
 **/
 this._dataObject = [];

 /**
  *  init
  * 
  *  @param   mRequest  request
  * 
  *  @return  void
 **/
 this.init = function(request)
 {
 };

 /**
  *  initVar
  * 
  *  @param   string  type
  *  @param   string  keyName
  *  @param   object  value
  *  @param   array   validator
  *  @param   array   filter
  * 
  *  @return  void
 **/
 this.initVar = function(type,keyName,value,validator,filter)
 {
  this._dataObject[keyName] =
  {
   'type'      : type,
   'validator' : validator,
   'filter'    : filter
  };
  this.set(keyName,value);
 };

 /**
  *  get
  * 
  *  @param   string  keyName
  * 
  *  @return  string
 **/
 this.get = function(keyName)
 {
  return this._dataObject[keyName].value;
 };

 /**
  *  show
  * 
  *  @param   string  keyName
  * 
  *  @return  string
 **/
 this.show = function(keyName)
 {
  var obj = this._dataObject[keyName];
  return mUtils.doFilter(obj.value,obj.filter,{});
 };

 /**
  *  set
  * 
  *  @param   string  keyName
  *  @param   string  value
  * 
  *  @return  void
 **/
 this.set = function(keyName,value)
 {
  var obj   = this._dataObject[keyName];
  value     = mUtils.doTypeSafe(obj.type,value);
  value     = mUtils.doValidate(value,obj.validator,{});
  obj.value = value;
 };
};
