/**
 *  onloadAction
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name: nekotan2ndDay $ $RCSfile: onloadAction.js,v $ $Revision: 1.2 $ $Date: 2006/11/23 13:52:22 $
 * 
 *  @requires mController
 *  @member   mController
**/
{
 /**
  *  defaultView
  * 
  *  @private
 **/
 this._defaultView = 'executeViewIndex';

 /**
  *  nekotan controll panel
  * 
  *  @private
 **/
 this._panel = {};

 /**
  *  init
  * 
  *  @param   mModel  model  // target model object
  * 
  *  @return  void
 **/
 this.init = function(model)
 {
 };

 /**
  *  execute
  * 
  *  @param   mRequest  request  // request object
  * 
  *  @return  string
 **/
 this.execute = function(request)
 {
  // create nekotan controll panel
  var panel = DomUtils.createObject('nekotanPanel','div',{},{});
  var list  = DomUtils.createObject('actionList','ul',{},{});
  panel.appendChild(list);

  // nekotan controll button array
  var arr = ['Punch','Nya','Up','Right','Down','Left','Special'];
  for(var i in arr)
  {
   var act = arr[i];
   // create nekotan controll button
   var but = DomUtils.createObject('nekotan' + act,'li',
            {'innerHTML' : mUtils.language.getLanguage('nekotanButton' + act)},{});
   // create doAction function
   var fnc = new Function('mController.doAction("' + act.toLowerCase() + '");');
   // append event for onclick to nekotan controll button
   DomUtils.appendEvent(but,'click',fnc,'normal');
   // append nekotan controll button to nekotan controll panel
   list.appendChild(but);
  }

  // store nekotan controll panel to private variable
  this._panel = panel;
  // return view name string
  return this._defaultView;
 };

 /**
  *  executeViewIndex
  * 
  *  @param   mRender  render  // render object
  * 
  *  @return  void
 **/
 this.executeViewIndex = function(render)
 {
  // set body for render target
  render.setRenderTarget(document.body);
  // set nekotan controll panel for render value
  render.setRenderValue(this._panel);
 };

};
