/**
 *  nyaAction
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name: nekotan4thDay $ $RCSfile: nyaAction.js,v $ $Revision: 1.2 $ $Date: 2006/11/25 12:35:13 $
 * 
 *  @requires mController
 *  @member   mController
**/
{
 /**
  *  defaultView
  * 
  *  @private
 **/
 this._defaultView = 'executeViewNone';

 /**
  *  init
  * 
  *  @param   mModel  model  // target model object
  * 
  *  @return  void
 **/
 this.init = function(model)
 {
 };

 /**
  *  execute
  * 
  *  @param   mRequest  request  // request object
  * 
  *  @return  string
 **/
 this.execute = function(request)
 {
  // alias of mConfig object
  var cnf  = mUtils.config;
  // alias of mLanguage object
  var lng  = mUtils.language;
  // nekotan image object
  var img  = DomUtils.getObject('nekotan');
  // alias of serif object
  var ser  = mUtils.context.nekotanSerif;
  // view name string
  var view = this._defaultView;

  // serif object is defined?
  if(!ser)
  {
   // create serif object
   ser = DomUtils.createObject(
        'nekotanSerif','div',
        {'innerHTML' : lng.getLanguage('nekotanButtonNya')},
        {'position' : 'absolute','width' : '40px','height' : '40px',
         'backgroundImage' : 'url(' + cnf.getConfig('nekotanImgSerif') + ')',
         'textAlign' : 'center','lineHeight' : '40px','display' : 'none'
         });
   // set serif object to context
   mUtils.context.nekotanSerif = ser;
   // set view name
   view = 'executeViewIndex';
  }

  // move serif object to nekotan image object
  ser.style.top     = (img.offsetTop  - 35) + 'px';
  ser.style.left    = (img.offsetLeft + 40) + 'px';

  // status check
  if(ser.style.display == 'none')
  {
   ser.style.display = 'block';
   // set timeout for return of nomal state
   window.setTimeout(function(){mController.doAction('nya');},500);
  }
  else
  {
   ser.style.display = 'none';
  }

  // return view name string
  return view;
 };

 /**
  *  executeViewIndex
  * 
  *  @param   mRender  render  // render object
  * 
  *  @return  void
 **/
 this.executeViewIndex = function(render)
 {
  render.setRenderTarget(document.body);
  render.setRenderValue(mUtils.context.nekotanSerif);
 };

 /**
  *  executeViewNone
  * 
  *  @param   mRender  render  // render object
  * 
  *  @return  void
 **/
 this.executeViewNone = function(render)
 {
  render.display = function(){};
 };
};
